/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast.util;

import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserTracker;
import com.vladsch.flexmark.util.BlockTracker;
import com.vladsch.flexmark.util.Computable;
import com.vladsch.flexmark.util.Paired;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.collection.ClassificationBag;
import com.vladsch.flexmark.util.collection.CollectionHost;
import com.vladsch.flexmark.util.collection.OrderedMultiMap;
import com.vladsch.flexmark.util.collection.OrderedSet;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterable;
import com.vladsch.flexmark.util.mappers.NodeClassifier;

public class ClassifyingBlockTracker
implements BlockTracker,
BlockParserTracker {
    protected final ClassificationBag<Class<?>, Node> nodeClassifier = new ClassificationBag((Computable)NodeClassifier.INSTANCE);
    protected final OrderedMultiMap<BlockParser, Block> allBlockParsersMap = new OrderedMultiMap((CollectionHost)new CollectionHost<Paired<BlockParser, Block>>(){

        public void adding(int index, Paired<BlockParser, Block> paired, Object v) {
            Block block = (Block)paired.getSecond();
            if (block != null) {
                ClassifyingBlockTracker.this.nodeClassifier.add((Object)block);
            }
        }

        public Object removing(int index, Paired<BlockParser, Block> paired) {
            Block block = (Block)paired.getSecond();
            if (block != null) {
                ClassifyingBlockTracker.this.nodeClassifier.remove((Object)block);
            }
            return paired;
        }

        public void clearing() {
            ClassifyingBlockTracker.this.nodeClassifier.clear();
        }

        public void addingNulls(int index) {
        }

        public boolean skipHostUpdate() {
            return false;
        }

        public int getIteratorModificationCount() {
            return ClassifyingBlockTracker.this.allBlockParsersMap.getModificationCount();
        }
    });

    public OrderedSet<BlockParser> allBlockParsers() {
        return this.allBlockParsersMap.keySet();
    }

    public OrderedSet<Block> allBlocks() {
        return this.allBlockParsersMap.valueSet();
    }

    public Block getValue(BlockParser parser) {
        return (Block)this.allBlockParsersMap.getKeyValue((Object)parser);
    }

    public BlockParser getKey(Block parser) {
        return (BlockParser)this.allBlockParsersMap.getValueKey((Object)parser);
    }

    public boolean containsKey(BlockParser parser) {
        return this.allBlockParsersMap.containsKey((Object)parser);
    }

    public boolean containsValue(Block parser) {
        return this.allBlockParsersMap.containsValue((Object)parser);
    }

    public ClassificationBag<Class<?>, Node> getNodeClassifier() {
        return this.nodeClassifier;
    }

    @Override
    public void blockParserAdded(BlockParser blockParser) {
        this.allBlockParsersMap.putKeyValue((Object)blockParser, (Object)blockParser.getBlock());
    }

    @Override
    public void blockParserRemoved(BlockParser blockParser) {
        this.allBlockParsersMap.removeKey((Object)blockParser);
    }

    private void validateLinked(Node node) {
        if (node.getNext() == null && node.getParent() == null) {
            throw new IllegalStateException("Added block " + node + " is not linked into the AST");
        }
    }

    public void blockAdded(Block node) {
        this.validateLinked((Node)node);
        this.allBlockParsersMap.putValueKey((Object)node, null);
    }

    public void blockAddedWithChildren(Block node) {
        this.validateLinked((Node)node);
        this.allBlockParsersMap.putValueKey((Object)node, null);
        this.addBlocks((ReversiblePeekingIterable<Node>)node.getChildren());
    }

    public void blockAddedWithDescendants(Block node) {
        this.validateLinked((Node)node);
        this.allBlockParsersMap.putValueKey((Object)node, null);
        this.addBlocks((ReversiblePeekingIterable<Node>)node.getDescendants());
    }

    private void addBlocks(ReversiblePeekingIterable<Node> nodes) {
        for (Node child : nodes) {
            if (!(child instanceof Block)) continue;
            this.allBlockParsersMap.putValueKey((Object)((Block)child), null);
        }
    }

    private void validateUnlinked(Node node) {
        if (node.getNext() != null || node.getParent() != null) {
            throw new IllegalStateException("Removed block " + node + " is still linked in the AST");
        }
    }

    public void blockRemoved(Block node) {
        this.validateUnlinked((Node)node);
        this.allBlockParsersMap.removeValue((Object)node);
    }

    public void blockRemovedWithChildren(Block node) {
        this.validateUnlinked((Node)node);
        this.allBlockParsersMap.removeValue((Object)node);
        this.removeBlocks((ReversiblePeekingIterable<Node>)node.getChildren());
    }

    public void blockRemovedWithDescendants(Block node) {
        this.validateUnlinked((Node)node);
        this.allBlockParsersMap.removeValue((Object)node);
        this.removeBlocks((ReversiblePeekingIterable<Node>)node.getDescendants());
    }

    private void removeBlocks(ReversiblePeekingIterable<Node> nodes) {
        for (Node child : nodes) {
            if (!(child instanceof Block)) continue;
            this.allBlockParsersMap.removeValue((Object)child);
        }
    }
}

