/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.codehighlight.core;

import com.codewaves.codehighlight.core.Highlighter;
import com.codewaves.codehighlight.core.Keyword;
import com.codewaves.codehighlight.core.Language;
import com.codewaves.codehighlight.core.Mode;
import com.codewaves.codehighlight.core.StyleRenderer;
import com.codewaves.codehighlight.core.StyleRendererFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class HighlightParser {
    private Language mLanguage;
    private StyleRendererFactory mRendererFactory;
    private StyleRenderer mBlockRenderer;
    private String mModeBuffer;
    private ParentWrapper mTop;
    private HashMap<String, ParentWrapper> mContinuations;
    private boolean mIgnoreIllegals;
    private int mRelevance;

    HighlightParser(Language language, StyleRendererFactory styleRendererFactory, StyleRenderer styleRenderer) {
        this.mLanguage = language;
        this.mRendererFactory = styleRendererFactory;
        this.mBlockRenderer = styleRenderer;
    }

    private boolean testRe(Pattern pattern, String string) {
        if (pattern == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(string);
        return matcher.find() && matcher.start() == 0;
    }

    private Mode subMode(String string, Mode mode) {
        int n = mode.contains.length;
        for (int i = 0; i < n; ++i) {
            if (!this.testRe(mode.contains[i].beginRe, string)) continue;
            return mode.contains[i];
        }
        return null;
    }

    private void startNewMode(Mode mode) {
        if (mode.className != null) {
            this.mBlockRenderer.onPushStyle(mode.className);
        }
        this.mTop = new ParentWrapper(mode, this.mTop);
    }

    private ParentWrapper endOfMode(ParentWrapper parentWrapper, String string) {
        if (this.testRe(parentWrapper.mode.endRe, string)) {
            while (parentWrapper.mode.endsParent && parentWrapper.parent != null) {
                parentWrapper = parentWrapper.parent;
            }
            return parentWrapper;
        }
        if (parentWrapper.mode.endsWithParent) {
            return this.endOfMode(parentWrapper.parent, string);
        }
        return null;
    }

    private void processBuffer() {
        if (this.mTop.mode.subLanguage != null || this.mTop.mode.subLanguages != null) {
            this.processSubLanguage();
        } else {
            this.processKeywords();
        }
        this.mModeBuffer = "";
    }

    private boolean isIllegal(String string, Mode mode) {
        return !this.mIgnoreIllegals && this.testRe(mode.illegalRe, string);
    }

    private Keyword keywordMatch(Mode mode, String string) {
        String string2;
        String string3 = string2 = this.mLanguage.caseInsensitive ? string.toLowerCase() : string;
        if (mode.compiledKeywords != null) {
            return mode.compiledKeywords.get(string2);
        }
        return null;
    }

    private void processKeywords() {
        if (this.mTop.mode.compiledKeywords == null) {
            this.mBlockRenderer.onPushCodeBlock(this.mModeBuffer);
            return;
        }
        int n = 0;
        Matcher matcher = this.mTop.mode.lexemesRe.matcher(this.mModeBuffer);
        while (matcher.find()) {
            this.mBlockRenderer.onPushCodeBlock(this.mModeBuffer.substring(n, matcher.start()));
            Keyword keyword = this.keywordMatch(this.mTop.mode, matcher.group());
            if (keyword != null) {
                this.mRelevance += keyword.relevance;
                this.mBlockRenderer.onPushStyle(keyword.className);
                this.mBlockRenderer.onPushCodeBlock(matcher.group());
                this.mBlockRenderer.onPopStyle();
            } else {
                this.mBlockRenderer.onPushCodeBlock(matcher.group());
            }
            n = matcher.end();
        }
        this.mBlockRenderer.onPushCodeBlock(this.mModeBuffer.substring(n));
    }

    private void processSubLanguage() {
        String string;
        CharSequence charSequence;
        int n;
        boolean bl;
        boolean bl2 = bl = this.mTop.mode.subLanguage != null;
        if (bl) {
            Language language = Highlighter.findLanguage(this.mTop.mode.subLanguage);
            if (language == null) {
                this.mBlockRenderer.onPushSubLanguage(null, this.mModeBuffer);
                return;
            }
            StyleRenderer styleRenderer = this.mRendererFactory.create(this.mTop.mode.subLanguage);
            HighlightParser highlightParser = new HighlightParser(language, this.mRendererFactory, styleRenderer);
            n = highlightParser.highlight(this.mModeBuffer, true, this.mContinuations.get(this.mTop.mode.subLanguage));
            charSequence = styleRenderer.getResult();
            string = this.mTop.mode.subLanguage;
            this.mContinuations.put(this.mTop.mode.subLanguage, highlightParser.mTop);
        } else {
            Highlighter highlighter = new Highlighter(this.mRendererFactory);
            Highlighter.HighlightResult highlightResult = highlighter.highlightAuto(this.mModeBuffer, this.mTop.mode.subLanguages);
            n = highlightResult.getRelevance();
            charSequence = highlightResult.getResult();
            string = highlightResult.getLanguage();
        }
        if (this.mTop.mode.relevance > 0) {
            this.mRelevance += n;
        }
        this.mBlockRenderer.onPushSubLanguage(string, charSequence);
    }

    private int processLexeme(String string, String string2) throws Exception {
        this.mModeBuffer = this.mModeBuffer + string;
        if (string2 == null) {
            this.processBuffer();
            return 0;
        }
        Mode mode = this.subMode(string2, this.mTop.mode);
        if (mode != null) {
            if (mode.skip) {
                this.mModeBuffer = this.mModeBuffer + string2;
            } else {
                if (mode.excludeBegin) {
                    this.mModeBuffer = this.mModeBuffer + string2;
                }
                this.processBuffer();
                if (!mode.returnBegin && !mode.excludeBegin) {
                    this.mModeBuffer = string2;
                }
            }
            this.startNewMode(mode);
            return mode.returnBegin ? 0 : string2.length();
        }
        ParentWrapper parentWrapper = this.endOfMode(this.mTop, string2);
        if (parentWrapper != null) {
            Mode mode2 = this.mTop.mode;
            if (mode2.skip) {
                this.mModeBuffer = this.mModeBuffer + string2;
            } else {
                if (!mode2.returnEnd && !mode2.excludeEnd) {
                    this.mModeBuffer = this.mModeBuffer + string2;
                }
                this.processBuffer();
                if (mode2.excludeEnd) {
                    this.mModeBuffer = string2;
                }
            }
            do {
                if (this.mTop.mode.className != null) {
                    this.mBlockRenderer.onPopStyle();
                }
                if (!this.mTop.mode.skip && this.mTop.mode.subLanguage == null) {
                    this.mRelevance += this.mTop.mode.relevance;
                }
                this.mTop = this.mTop.parent;
            } while (this.mTop != parentWrapper.parent);
            if (parentWrapper.mode.starts != null) {
                this.startNewMode(parentWrapper.mode.starts);
            }
            return mode2.returnEnd ? 0 : string2.length();
        }
        if (this.isIllegal(string2, this.mTop.mode)) {
            throw new Exception("Illegal lexeme \"" + string2 + "\" for mode \"" + this.mTop.mode.className + "\"");
        }
        this.mModeBuffer = this.mModeBuffer + string2;
        return string2.length() > 0 ? string2.length() : 1;
    }

    /*
     * WARNING - void declaration
     */
    int highlight(String string, boolean bl, ParentWrapper parentWrapper) {
        try {
            void var6_12;
            Matcher matcher;
            this.mBlockRenderer.onStart();
            this.mLanguage.compile();
            this.mModeBuffer = "";
            this.mIgnoreIllegals = bl;
            this.mRelevance = 0;
            this.mTop = parentWrapper == null ? new ParentWrapper(this.mLanguage, null) : parentWrapper;
            this.mContinuations = new HashMap();
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object2 = this.mTop;
            while (object2 != null && ((ParentWrapper)object2).mode != this.mLanguage) {
                if (((ParentWrapper)object2).mode.className != null) {
                    arrayList.add(0, ((ParentWrapper)object2).mode.className);
                }
                object2 = ((ParentWrapper)object2).parent;
            }
            for (String object3 : arrayList) {
                this.mBlockRenderer.onPushStyle(object3);
            }
            int n = 0;
            while (this.mTop.mode.terminators != null && (matcher = this.mTop.mode.terminators.matcher(string)).find(n)) {
                int n2 = this.processLexeme(string.substring(n, matcher.start()), matcher.group());
                n = matcher.start() + n2;
            }
            this.processLexeme(string.substring(n), null);
            ParentWrapper parentWrapper2 = this.mTop;
            while (var6_12.parent != null) {
                if (var6_12.mode.className != null) {
                    this.mBlockRenderer.onPopStyle();
                }
                ParentWrapper parentWrapper3 = var6_12.parent;
            }
            this.mBlockRenderer.onFinish();
        }
        catch (Exception exception) {
            this.mBlockRenderer.onAbort(string);
            this.mRelevance = 0;
        }
        return this.mRelevance;
    }

    private static class ParentWrapper {
        private Mode mode;
        private ParentWrapper parent;

        private ParentWrapper(Mode mode, ParentWrapper parentWrapper) {
            this.mode = mode;
            this.parent = parentWrapper;
        }
    }
}

