<?php
class ActionHandler {
	var $mTable = "cartb2b_order";
	var $mPrimary = "orderid";
	var $records = array();
	var $formInput = array();
	var $message = "";
	var $ctrl = "orderList";
	var $submitValue = _MD_CARTB2B_SHIPTO_CONTINUE;
	var $debstr="";	// for debug
	var $orderid = 0;
	var $wherestr;
	var $orderstr = " ORDER BY order_status ASC, order_date desc";
	var $is_mod_admin = false;
	var $order_status;
	var $cartRecords = array();
	var $sub_total = 0;
	var $module_header="";
	function ActionHandler($ctrl=""){
		global $xoopsUser;
		
		$this->getParam();
		switch($ctrl){
			case "order_setAddress":
				$this->ctrl = "setAddress" ;
				break;
			case "order_makeSure":
				$this->ctrl = "makeSure" ;
				break;
			case "order_orderList":
				$this->ctrl = "orderList" ;
				break;
			case "order_editStatus":
				$this->ctrl = "editStatus" ;
				break;
		}
		$this->is_mod_admin = $this->is_mod_admin();
		if ( !$this->is_mod_admin )
			$this->wherestr = " WHERE uid=".$xoopsUser->uid();	
	}
	function load(){
		global $xoopsDB;
		if ($this->orderid){
			$this->wherestr .= $this->wherestr!="" ? " AND " : " WHERE ";
			$this->wherestr .= "orderid=".$this->orderid;
			$this->orderstr = "";
		}
		$sql = "SELECT * FROM " . $xoopsDB->prefix( $this->mTable ) . $this->wherestr . $this->orderstr;
		$result = $xoopsDB->query( $sql ) ;
		$this->records = array();
		$this->order_status = explode(",",_MD_CARTB2B_STATUSPARAMS);
		while( $myrow = $xoopsDB->fetchArray($result) ){
			$myrow['order_date'] = $myrow['order_date']>0 ? date(_MD_CARTB2B_DATEFORMAT,$myrow['order_date']) : NULL;
			$myrow['invoice_date'] = $myrow['invoice_date']>0 ? date(_MD_CARTB2B_DATEFORMAT,$myrow['invoice_date']) : NULL;
			$myrow['ship_date'] = $myrow['ship_date']>0 ? date(_MD_CARTB2B_DATEFORMAT,$myrow['ship_date']) : NULL;
			$myrow['lupdate'] = $myrow['lupdate']>0 ? date(_MD_CARTB2B_DATEFORMAT,$myrow['lupdate']) : NULL;
			$myrow['order_status_desc'] = $this->order_status[$myrow['order_status']];
			$this->records[] = $myrow;
		}
		//var_dump($this->records); die;
		$this->debstr .= $sql."<br />";
		return $result;
	}
	function assignRecords(){
		global $xoopsTpl;
		switch($this->ctrl){ 
			case "orderList":
				$xoopsTpl->assign( 'records', $this->records ) ;
				break;
			case "editStatus":
				$xoopsTpl->assign( 'records', $this->records[0] ) ;
				break;
			default:
				$xoopsTpl->assign( 'records', $this->formInput);
		}
		$xoopsTpl->assign( 'message', $this->message ) ;
		$xoopsTpl->assign( 'ctrl', $this->ctrl ) ;
		$xoopsTpl->assign( 'submitValue', $this->submitValue ) ;
		$xoopsTpl->assign( 'is_mod_admin' , $this->is_mod_admin );
		$xoopsTpl->assign( 'order_status' , $this->order_status );
		$xoopsTpl->assign( 'cartRecords' , $this->cartRecords );
		$xoopsTpl->assign( 'sub_total', $this->sub_total ) ;
		$xoopsTpl->assign('xoops_module_header', $this->module_header);
	}
	function getParam(){
		global $xoopsUser;
		$this->orderid = isset($_GET['orderid']) ? intval($_GET['orderid']) : 0;
		$this->orderid = isset($_POST['orderid']) ? intval($_POST['orderid']) : $this->orderid;
		// for set address
		$this->formInput['firstname'] = isset($_POST['firstname']) ? htmlspecialchars($_POST['firstname'],ENT_QUOTES) : "";
		$this->formInput['lastname'] = isset($_POST['lastname']) ? htmlspecialchars($_POST['lastname'],ENT_QUOTES) : "";
		$this->formInput['areacode'] = isset($_POST['areacode']) ? htmlspecialchars($_POST['areacode'],ENT_QUOTES) : "";
		$this->formInput['phone'] = isset($_POST['phone']) ? htmlspecialchars($_POST['phone'],ENT_QUOTES) : "";
		$this->formInput['address'] = isset($_POST['address']) ? htmlspecialchars($_POST['address'],ENT_QUOTES) : "";
		$this->formInput['address2'] = isset($_POST['address2']) ? htmlspecialchars($_POST['address2'],ENT_QUOTES) : "";
		$this->formInput['city'] = isset($_POST['city']) ? htmlspecialchars($_POST['city'],ENT_QUOTES) : "";
		$this->formInput['state'] = isset($_POST['state']) ? htmlspecialchars($_POST['state'],ENT_QUOTES) : "";
		$this->formInput['zipcode'] = isset($_POST['zipcode']) ? htmlspecialchars($_POST['zipcode'],ENT_QUOTES) : "";
		$this->formInput['country'] = isset($_POST['country']) ? htmlspecialchars($_POST['country'],ENT_QUOTES) : "";
		$this->formInput['uid'] = $xoopsUser->uid();
		// for editStatus
		$this->formInput['order_status'] = isset($_POST['order_status']) ? intval($_POST['order_status']) : 0;
		$this->formInput['sales_person'] = isset($_POST['sales_person']) ? htmlspecialchars($_POST['sales_person'],ENT_QUOTES) : "";
		$this->formInput['invoice_no'] = isset($_POST['invoice_no']) ? htmlspecialchars($_POST['invoice_no'],ENT_QUOTES) : "";
		//$this->formInput['invoice_date'] = isset($_POST['invoice_date']) ? htmlspecialchars($_POST['invoice_date'],ENT_QUOTES) : "";
		//$this->formInput['ship_date'] = isset($_POST['ship_date']) ? htmlspecialchars($_POST['ship_date'],ENT_QUOTES) : "";
		$this->formInput['carrier'] = isset($_POST['carrier']) ? htmlspecialchars($_POST['carrier'],ENT_QUOTES) : "";
		$this->formInput['tracking_no'] = isset($_POST['tracking_no']) ? htmlspecialchars($_POST['tracking_no'],ENT_QUOTES) : "";
		list( $invoice_date , $invoice_date_str , $use_default ) = $this->parse_posted_date( $_POST[ 'invoice_date' ], $this->records[0]['invoice_date'] ) ;
		list( $ship_date , $ship_date_str , $use_default ) = $this->parse_posted_date( $_POST[ 'ship_date' ], $this->records[0]['ship_date'] ) ;
		$this->formInput['invoice_date'] = $invoice_date;
		$this->formInput['ship_date'] = $ship_date;
	}
	function debug(){
		return $this->debstr;
	}
	function checkoutByUser(){
		global $xoopsDB, $xoopsUser;
		$rec = $this->formInput;
		foreach ($rec as $key => $val) {
			 $rec[$key] = '"' . addslashes($val) . '"';
		}
		$rec["order_date"] = $rec["lupdate"] = '"'. time() . '"';
		$sql ="INSERT INTO ".$xoopsDB->prefix($this->mTable)
			." (".implode(",", array_keys($rec)).") VALUES(".implode(",", array_values($rec)).")";
		$this->debstr .= $sql."<br />";
		$result = $xoopsDB->query( $sql );
		if ($result){
			$this->orderid = $xoopsDB->getInsertID(); 
			$sql = 'UPDATE ' . $xoopsDB->prefix("cartb2b_cart") . ' SET orderid="' . $this->orderid . '" WHERE uid="' . $xoopsUser->uid() . '"';
			$result = $xoopsDB->query( $sql );
			$this->debstr .= $sql."<br />";
		}
		return $result;
	}
	function updateBySales(){
		global $xoopsDB;
		$rec = $this->formInput;
		foreach ($rec as $key => $val) {
			 $rec[$key] = '"' . addslashes($val) . '"';
		}
		$rec["lupdate"] = '"'. time() . '"';
		$sql = "UPDATE ".$xoopsDB->prefix($this->mTable) . " SET ";
		$i=0;
		foreach ($rec as $key=>$val ){
			if ($i>0) $sql .= ",";
			$sql .= " " . $key . "=" . $val;
			$i++;
		}
		$sql .= " WHERE orderid=" . $this->orderid;
		$result = $xoopsDB->query( $sql );
		$this->debstr .= $sql."<br />";
		return $result;
	}
	function checkInput($order_status=0){		
		if ($this->formInput['firstname']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_SHIPTO_FIRSTNAME); return 0; }
		if ($this->formInput['lastname']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_SHIPTO_LASTNAME); return 0; }
		if ($this->formInput['areacode']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_SHIPTO_AREACODE); return 0; }
		if ($this->formInput['phone']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_SHIPTO_PHONE); return 0; }
		if ($this->formInput['address']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_SHIPTO_ADDRESS); return 0; }
		if ($this->formInput['city']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_SHIPTO_CITY); return 0; }
		if ($this->formInput['state']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_SHIPTO_STATE); return 0; }
		if ($this->formInput['zipcode']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_SHIPTO_ZIPCODE); return 0; }
		if ($this->formInput['country']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_SHIPTO_COUNTRY); return 0; }
		if ($order_status>0){
			if ($this->formInput['sales_person']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_SALESPERSON); return 0; }
		}
		if ($order_status>3){
			if ($this->formInput['invoice_no']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_INVOICENO); return 0; }
			if ($this->formInput['invoice_date']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_INVOICEDATE); return 0; }
		}
		if ($order_status>4){
			if ($this->formInput['ship_date']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_SHIPDATE); return 0; }
			if ($this->formInput['carrier']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_CARRIER); return 0; }
			if ($this->formInput['tracking_no']==""){ $this->message = sprintf(_MD_CARTB2B_SHIPTO_PLEASEINPUT,_MD_CARTB2B_TRACKINGNO); return 0; }
		}
	}
	function order_makeSure(){
		$this->checkInput();
		if ($this->message==""){
			$this->ctrl = "orderList";
			$this->submitValue = _MD_CARTB2B_SHIPTO_CHECKYOURORDER;
			$ret = $this->checkoutByUser();
			$this->message = sprintf(_MD_CARTB2B_SHIPTO_FINISHORDER , $this->orderid) ;
			if ($ret) $this->load();
			return $ret;
		}
		$this->CartLoader();
		return 1;
	}
	function order_setAddress(){
		$this->checkInput();
		if ($this->message==""){
			$this->ctrl = "makeSure";
		}
		$this->CartLoader();
		return 1;
	}
	function order_editStatus(){
		if ($this->formInput['order_status']>0){
			$this->checkInput( $this->formInput['order_status'] );
			if ($this->message==""){
				$ret = $this->updateBySales();
				if ($ret) $this->load();
			}
		}
		ob_start();
		include XOOPS_ROOT_PATH.'/include/calendarjs.php' ;
		$this->module_header = ob_get_clean();
		$this->records[0]['invoice_date'] = $this->get_formtextdateselect('invoice_date',$this->records[0]['invoice_date']);
		$this->records[0]['ship_date'] = $this->get_formtextdateselect('ship_date',$this->records[0]['ship_date']);
		$this->CartLoader($this->orderid);
		return 1;
	}
	function CartLoader($orderid=0){
		global $xoopsDB,$xoopsUser;
		$sql = "SELECT c.*,g.image,g.title,(c.qty * c.price) AS amount FROM " . $xoopsDB->prefix( "cartb2b_cart" ) 
			. " c LEFT JOIN ".$xoopsDB->prefix( "cartb2b_goods" )." g ON g.gid=c.gid WHERE ";
		if ($orderid>0)
			$sql .= "orderid=". $orderid;
		else
			$sql .= "orderid=0 AND uid=". $xoopsUser->uid();
		$result = $xoopsDB->query( $sql ) ;
		//echo $sql; die;
		while( $myrow = $xoopsDB->fetchArray($result) ){
			$this->cartRecords[] = $myrow;
			$this->sub_total += $myrow['amount'];
		}
		return $result;
	}
	function is_mod_admin(){
		global $xoopsUser,$xoopsModule;
		if ($xoopsUser){
			if ($xoopsModule){
				$mid = $xoopsModule->mid();
			}else{
				$module_handler =& xoops_gethandler('module');
				$xoopsModule =& $module_handler->getByDirname("cartb2b");
				$mid = $xoopsModule->mid();
			}
			$ret = ( $xoopsUser->isAdmin($mid) ) ? true : false;
		}else{
			$ret = false;
		}
		return $ret;
	}
	function get_formtextdateselect( $name , $ymd , $long_ymdn = '' )
	{

		$jstime = formatTimestamp( time() , 'F j Y, H:i:s' ) ;
	
		if( $this->week_start ) $js_cal_week_start = 'true' ;	// Monday
		else $js_cal_week_start = 'false' ;						// Sunday
	
	
		// <input type='reset' value='...' onclick='
	
		return "
			<input type='text' name='$name' id='$name' size='15' maxlength='15' value='$ymd' />
			<input type='image' src='./images/button_date_selecting.gif' onclick='
	
		  var el = xoopsGetElementById(\"$name\");
		  if (calendar != null) {
		    calendar.hide();
		    calendar.parseDate(el.value);
		  } else {
		    var cal = new Calendar($js_cal_week_start, new Date(\"$jstime\"), selected, closeHandler);
		    calendar = cal;
		    cal.setRange(2000, 2015); // GIJ TODO
		    calendar.create();
		    calendar.parseDate(el.value);
		  }
		  calendar.sel = el;
		  calendar.showAtElement(el);
		  Calendar.addEvent(document, \"mousedown\", checkCalendar);
		  return false;

		' />
		" ;
	}
	function parse_posted_date( $date_desc , $default_unixtime=NULL )
	{
		if( ! ereg( "^([0-9][0-9]+)[-./]?([0-1]?[0-9])[-./]?([0-3]?[0-9])$" , $date_desc , $regs ) ) {
			$unixtime = $default_unixtime ;
			$use_default = true ;
			$iso_date = '' ;
		} else if( $regs[1] >= 2038 ) {
			$unixtime = mktime( 0 , 0 , 0 , 1 , 1 , 2038 ) ;
			$use_default = false ;
			$iso_date = "{$regs[1]}-{$regs[2]}-{$regs[3]}" ;
		} else if( $regs[1] <= 1970 ) {
			$unixtime = mktime( 0 , 0 , 0 , 12 , 31 , 1970 ) ;
			$use_default = false ;
			$iso_date = "{$regs[1]}-{$regs[2]}-{$regs[3]}" ;
		} else if( ! checkdate( $regs[2] , $regs[3] , $regs[1] ) ) {
			$unixtime = $default_unixtime ;
			$use_default = true ;
			$iso_date = '' ;
		} else {
			$unixtime = mktime( 0 , 0 , 0 , $regs[2] , $regs[3] , $regs[1] ) ;
			$use_default = false ;
			$iso_date = '' ;
		}

		return array( $unixtime , $iso_date , $use_default ) ;
	}
}
?>