/*
 * YuuMail.java
 *
 * Created on 2000/08/09, 14:07
 */

package jp.co.areaweb.tools.mail;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.*;         // jaxp.jar
import org.w3c.dom.*;               // jaxp.jar

/** Ｅメールを送信するためのクラス
 * JavaMailを使用する機能拡張版
 * @author techno-infinitus Co,Ltd. Yuu Hayashi.
 * @version 00-00
 */
public class YuuMailXml extends SendMail {
    /** Creates new YuuMail */
    public YuuMailXml(SiteData siteData) {
        super(siteData);
    }
    public YuuMailXml(String propertyFile) {
        super(propertyFile);
    }

    public void setXmlData(Node sendMailTag) throws java.io.FileNotFoundException {
        NodeList nl = sendMailTag.getChildNodes();
        for (int i=0; i < nl.getLength(); i++) {
            Node mailDataTag = nl.item(i);
            if (mailDataTag.getNodeType() == Node.ELEMENT_NODE) {
                String nodeName = mailDataTag.getNodeName();
                if (nodeName.equals("to")) {
                    this.setTo(mailDataTag.getFirstChild().getNodeValue());
                }
                else if (nodeName.equals("cc")) {
                    Node ccNode = mailDataTag.getFirstChild();
                    if (ccNode != null) {
                        this.setCc(ccNode.getNodeValue());
                    }
                }
                else if (nodeName.equals("bcc")) {
                    Node bccNode = mailDataTag.getFirstChild();
                    if (bccNode != null) {
                        this.setBcc(bccNode.getNodeValue());
                    }
                }
                else if (nodeName.equals("from")) {
                    Node fromNode = mailDataTag.getFirstChild();
                    if (fromNode != null) {
                        this.setFrom(fromNode.getNodeValue());
                    }
                }
                else if (nodeName.equals("subject")) {
                    this.setSubject(mailDataTag.getFirstChild().getNodeValue());
                }
                else if (nodeName.equals("content")) {
                    this.setContent(mailDataTag.getFirstChild().getNodeValue());
                }
                else if (nodeName.equals("attachment")) {
                	Node attachNode = mailDataTag.getFirstChild();
                	File attachFile = new File(attachNode.getNodeValue());
                    Attr attrNode = (Attr)mailDataTag.getAttributes().getNamedItem("file");
                    if (attrNode != null) {
                        this.setAttachment(attachFile, attrNode.getValue());
                    }
                    else {
                        this.setAttachment(attachFile);
                    }
                }
            }
        }
    }
    
    public void setXmlData(String inputFile) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Node rootNode = builder.parse(new FileInputStream(inputFile));
            NodeList rootNodeList = rootNode.getChildNodes();
            for (int j=0; j < rootNodeList.getLength(); j++) {
                setXmlData(rootNodeList.item(j));
            }
        }
        catch (javax.xml.parsers.ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new IOException("javax.xml.parsers.ParserConfigurationException");
        }
        catch (org.xml.sax.SAXException saxe) {
            saxe.printStackTrace();
            throw new IOException("org.xml.sax.SAXException");
        }
    }
    
    /**
     * "jp.co.areaweb.tools.common.YuuMailXml <property.xml> <sendMail.xml>"
     */
    public static void main(java.lang.String[] args) {
        String inputfile;
        String propertyFile;

        if (args.length < 2) {
            inputfile = "sendMail.xml";
            if (args.length < 1) {
                propertyFile = "property.xml";
            }
            else {
                propertyFile = args[0];
            }
        }
        else {
            inputfile = args[1];
            propertyFile = args[0];
        }

        try {
            YuuMailXml mail = new YuuMailXml(new SiteDataXml(propertyFile));
            mail.setXmlData(inputfile);
            mail.send();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}