/* Copyright 1992 NEC Corporation, Tokyo, Japan.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of NEC
 * Corporation not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  NEC Corporation makes no representations about the
 * suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
 * NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
 * OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE. 
 */

/*
 * @(#) 102.1 $Id: canna.h,v 1.2 2002/10/20 14:29:56 aida_s Exp $
 * $Revision: 1.2 $
 * $Author: aida_s $
 */

#ifndef _CANNA_H_
#define _CANNA_H_

#include "widedef.h"

#include <stdio.h>
#include "ccompat.h"

#define	WCHARSIZE	sizeof(wchar_t)

/* #include "sglobal.h" ϥ꡼ˤϥȤϤ */
#define necKanjiError jrKanjiError

/*#include "jrkanji.h"*/

typedef unsigned char BYTE;

/*
 * LIBDIR  -- ƥΥޥե޻Ѵơ֥뤬
 *            ֤ǥ쥯ȥꡣ
 */

#ifndef CANNALIBDIR
#define CANNALIBDIR "/usr/lib/canna"
#endif

#define XKanjiStatus          jrKanjiStatus
#define XKanjiStatusWithValue jrKanjiStatusWithValue

/* 
 * ʴѴΤ͡ʥޥåץơ֥ 
 * ޥåץơ֥ϽؿؤΥݥ󥿤ȤʤäƤ롣
 */

typedef struct {
  int (*func)();
  unsigned char *keytbl;
  int flags;			/* 򸫤 */
  int (**ftbl)();
} *KanjiMode, KanjiModeRec;

struct funccfunc {
  unsigned char funcid;
  int (*cfunc)();
};

/* flags ξ */
#define CANNA_KANJIMODE_TABLE_SHARED	01
#define CANNA_KANJIMODE_EMPTY_MODE	02

/* func 軰 */
#define KEY_CALL  0
#define KEY_CHECK 1
#define KEY_SET   2

extern BYTE default_kmap[];

#define CANNA_FULL_VERBOSE 2

/* menuitem -- ˥塼ɽιܤơ֥ */

typedef struct _menuitem {
  wchar_t *title;
  int (*func)();
  struct _menuitem *menu_next;
  int *prev_kouho;
  int minorMode;
} menuitem;

#define NEXT_MENU (int (*)())0 /* menuitem  func եɤ */

/*
 * glineinfo -- ɽΤǼƤι¤Ρ
 * 줾ΥФϰʲΰ̣ġ
 *
 * glkosu -- ιԤˤο
 * glhead -- ιԤƬ䤬kouhoinfoβܤ(0)
 * gllen  -- ιԤɽ뤿ʸĹ
 * gldata -- ιԤɽ뤿ʸؤΥݥ
 */

typedef struct {
  int glkosu;
  int glhead;
  int gllen;
  wchar_t *gldata;
} glineinfo;

/*
 * kouhoinfo -- ΤǼƤι¤
 * 줾ΥФϰʲΰ̣ġ
 *
 * khretsu -- θ䤬
 * khpoint -- θιԤΤʤǤΰ
 * khdata -- θʸؤΥݥ
 */

typedef struct {
  int khretsu;
  int khpoint;
  wchar_t *khdata;
} kouhoinfo;

#define ROMEBUFSIZE 	1024
#define	BANGOSIZE	2	/* γƸֹΥХȿ */
#define	REVSIZE		2	/* ֹΥСΥХȿ */
#define	BANGOMAX   	9	/* κ */
#define KIGOSIZE	1	/* ΥХȿ */
#define GL_KUHAKUSIZE	1	/* ֹζʸΥХȿ */
#define KG_KUHAKUSIZE	1	/* δ֤ζʸΥХȿ */
#define KIGOCOL		(KIGOSIZE + KG_KUHAKUSIZE)
					/* bangomax׻뤿ο */
#define	KIGOBANGOMAX   	16	/* κ */
#define HINSHISUU	14
#define HINSHIBUF	256
#define GOBISUU		9

#define	ON		1
#define	OFF		-1

#define	NG		-1

#define NO_CALLBACK	0
#define NCALLBACK	4

#define	JISHU_HIRA	0
#define JISHU_ZEN_KATA	1
#define JISHU_HAN_KATA	2
#define JISHU_ZEN_ALPHA	3
#define JISHU_HAN_ALPHA	4
#define MAX_JISHU	5

#define  SENTOU        1
#define  HENKANSUMI    2
#define  SUPKEY        4
#define  WARIKOMIMOJI  8
#define  SHIRIKIRE    16
#define  ATAMAKIRE    32

typedef char *mode_context;

struct callback {
  int (*func[NCALLBACK])();
  mode_context    env;
  struct callback *next;
};

/* identifier for each context structures */
#define CORE_CONTEXT       (char)0
#define YOMI_CONTEXT       (char)1
#define JISHU_CONTEXT      (char)2
#define HENKAN_CONTEXT     (char)3
#define ICHIRAN_CONTEXT    (char)4
#define FORICHIRAN_CONTEXT (char)5
#define MOUNT_CONTEXT      (char)6
#define TOUROKU_CONTEXT    (char)7
#define ADJUST_CONTEXT     (char)8
#define CHIKUJI_CONTEXT    (char)9

typedef struct _coreContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode; /* Υ⡼ */
  mode_context    next;
} coreContextRec, *coreContext;

typedef struct  _yomiContextRec {
  /* core Ʊ */
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  /* ޻Ѵط */
  struct RkwRxDic *romdic;	/* ޻Ѵ */
  wchar_t   romaji_buffer[ROMEBUFSIZE];
  /* ޻Хåե rStartp, rEndp ΣĤΥǥåˤäƴ
   * 롣rStartp ϥʤѴǤʤä޻κǽʸؤΥǥ
   * ǤꡢrEndp Ͽ˥޻ϤˡǼ٤ 
   * romaji_buffer ΥǥåǤ롣Ϥ޻ϡ
   * romaji_buffer + rEndp ˳Ǽ졢Υ޻򥫥ʤѴ
   * ϡromaji_buffer + rStartp  rEndp - rStartp ХȤʸ
   * оݤȤʤ롣 */
  int		  rEndp, rStartp, rCurs; /* ޻ХåեΥݥ */
  wchar_t         kana_buffer[ROMEBUFSIZE];
  BYTE            rAttr[ROMEBUFSIZE], kAttr[ROMEBUFSIZE];
  int		  kEndp; /* ʥХåեκǸ򲡤ݥ */
  int             kRStartp, kCurs;

  /* ¾Υץ */
  KanjiMode       myEmptyMode;		/* empty ⡼ɤϤɤ줫 */
  long		  generalFlags;		/* see below */
  char		  allowedChars;		/* see jrkanji.h */
  char		  henkanInhibition;	/* see below */
  int		  (*henkanCallback)();	/* ѴԤˤѿ˥ɥ쥹
             ꤵƤʤФΥɥ쥹δؿ̾δؿ
             Ƥ֡ꤵƤʤ̾δؿƤ֡
               ѴʤɤѴ줿üʽԤΤ
             б뤿դ
	       ѴХåϰȤƤɤѴؿƤФ줿Τ򼨤
	     ֹȼ*/
  int             cursup;		/* ʤɤλ˻Ȥ */
#define SUSPCHARBIAS 100
  int             n_susp_chars;

  /* ѿ */
  wchar_t	  *retbuf, *retbufp;
  int		  retbufsize;
} yomiContextRec, *yomiContext;

/* for generalFlags */
#define CANNA_YOMI_BREAK_ROMAN		0x1L
#define CANNA_YOMI_CHGMODE_INHIBITTED	0x2L
#define CANNA_YOMI_END_IF_KAKUTEI	0x4L
#define CANNA_YOMI_DELETE_DONT_QUIT	0x8L

#define CANNA_YOMI_KAKUTEI		0x10L
#define CANNA_YOMI_HENKAN		0x20L
#define CANNA_YOMI_ZENKAKU		0x40L
#define CANNA_YOMI_HANKAKU		0x80L
#define CANNA_YOMI_HIRAGANA		0x100L
#define CANNA_YOMI_KATAKANA		0x200L
#define CANNA_YOMI_ROMAJI		0x400L
#define CANNA_YOMI_ATTRFUNCS		0x7f0L

#define CANNA_YOMI_BASE_HANKAKU		0x800L

#define CANNA_YOMI_IGNORE_USERSYMBOLS	0x1000L

/* kind of allowed input keys */
#define CANNA_YOMI_INHIBIT_NONE		0
#define CANNA_YOMI_INHIBIT_HENKAN	1
#define CANNA_YOMI_INHIBIT_JISHU	2
#define CANNA_YOMI_INHIBIT_ASHEX	4
#define CANNA_YOMI_INHIBIT_ASBUSHU	8
#define CANNA_YOMI_INHIBIT_ALL		15

/* ΤΥե饰 */
#define NUMBERING 			1
#define CHARINSERT			2

#define CANNA_JISHU_UPPER		1
#define CANNA_JISHU_CAPITALIZE		2

typedef struct _henkanContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  /* ʴѴط */
  int            context;
  int            check;
  int		 kouhoCount;	/*  henkanNext Ϣ³Ʋ줿 */
  wchar_t        yomi_buffer[ROMEBUFSIZE];
  wchar_t        echo_buffer[ROMEBUFSIZE];
  wchar_t        **allkouho; /* RkGetKanjiListʸˤ
				ȤäƤȤ */
  int            yomilen;    /* ɤߤĹɤ߼Ȥ kana_buffer 
			         */
  int            curbun;     /* ʸ */
  int		 curIkouho;  /* ȸ */
  int            nbunsetsu;  /* ʸο */
#define MAXNBUNSETSU	256
  int            kugiri[MAXNBUNSETSU]; /* ʸʬԤʸ᤯
					  ξ */
  int		 *kanaKugiri, *romajiKugiri, *jishubun;
  yomiContext    ycx;
/* ifdef MEASURE_TIME */
  long		 proctime;   /* (ѴǷ¬) */
  long		 rktime;     /* (RKˤ) */
/* endif MEASURE_TIME */
} henkanContextRec, *henkanContext;

typedef struct _jishuContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  unsigned char	 inhibition;
  wchar_t        jishu_buffer[ROMEBUFSIZE];
  int            jishu_len, jishu_kEndp, jishu_rEndp;
  unsigned char  kc, jishu_case;
  yomiContext    ycx;
  henkanContext    hcx;
} jishuContextRec, *jishuContext;

typedef struct _ichiranContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  int            svIkouho;   /* ȸȤäƤ(ɽ) */
  int            *curIkouho; /* ȸ */
  int            nIkouho;    /* ο(ɽ) */
  int		 tooSmall;   /* ƸФʤե饰 */
  int            curIchar;   /* ̤ʸ󤢤ñϿñϤ
    							Ƭʸΰ */
  unsigned char  inhibit;
  unsigned char  flags;	     /* 򸫤Ƥ */
  wchar_t        **allkouho; /* RkGetKanjiListʸˤ
				ȤäƤȤ */
  wchar_t        *glinebufp; /* ΤԤɽ뤿ʸ
				ؤΥݥ */
  kouhoinfo      *kouhoifp;  /* طξǼƤ¤
				ؤΥݥ */
  glineinfo      *glineifp;  /* طξǼƤ¤
				ؤΥݥ */
} ichiranContextRec, *ichiranContext;

/* ե饰ΰ̣ */
#define ICHIRAN_ALLOW_CALLBACK 1 /* Хå򤷤Ƥɤ */


typedef struct _foirchiranContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  int            curIkouho;  /* ȸ */
  wchar_t        **allkouho; /* RkGetKanjiListʸˤ
				ȤäƤȤ */
  menuitem       *table;  /* ʸȴؿΥơ֥ */
  int            *prevcurp;  /* Υȸ */
  int            (*prevfunc)();  /* δؿ */
  int            (*curfunc)();  /* ȴؿ */
} forichiranContextRec, *forichiranContext;

typedef struct _mountContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  unsigned char        *mountOldStatus; /* ޥȤƤ뤫ʤ */
  unsigned char        *mountNewStatus; /* ޥȤƤ뤫ʤ */
  unsigned char        **mountList;   /* ޥȲǽʼΰ */
  int            curIkouho;     /* ȸ */
} mountContextRec, *mountContext;

typedef struct _tourokuContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  wchar_t        genbuf[ROMEBUFSIZE];
  wchar_t        qbuf[ROMEBUFSIZE];
  wchar_t        tango_buffer[ROMEBUFSIZE];
  int            tango_len;  /* ñϿñʸĹ */
  wchar_t        yomi_buffer[ROMEBUFSIZE];
  int            yomi_len;   /* ñϿɤߤʸĹ */
  int            curHinshi;  /* ʻ */
  wchar_t	 hcode[16];   /* ñϿʻ */
  int		 katsuyou;   /* ñϿưγѷ */
  wchar_t        **udic;     /* ñϿǤ뼭 (̾) */
  int            delContext; /* ñǣĤμޥȤ */
} tourokuContextRec, *tourokuContext;

typedef struct _adjustContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  yomiContext    ycx;
  henkanContext  hcx;

  wchar_t        genbuf[ROMEBUFSIZE];
  int            kanjilen, strlen, bunlen; /* ʬΡʸĹ */
} adjustContextRec, *adjustContext;

typedef struct _chikujiContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;
  mode_context    next;

  yomiContext    yc;
  henkanContext  hc;
  wchar_t        echo_buffer[ROMEBUFSIZE];
  int		 ye, ys;
  int		 status;
} chikujiContextRec, *chikujiContext;

#define	CHIKUJI_ON_BUNSETSU		0x0001
#define	CHIKUJI_YOMI_CHANGED		0x0002
#define	CHIKUJI_RENBUNSETSU		0x0004
#define	CHIKUJI_DOING_HENKAN		0x0008
#define	CHIKUJI_OVERWRAP		0x0010
#define	CHIKUJI_HENKAN_INHIBIT		0x0020
#define CHIKUJI_HENKAN_FAILED		0x0040
#define	CHIKUJI_NULL_STATUS		0x0000

struct moreTodo {
  char          todo; /* äȤΡ򼨤 */
  char          fnum; /* ؿֹ档ʤ鼡ʸǼ뤳Ȥ򤹤 */
  unsigned char ch;   /* ʸ */
};

/* ⡼̾Ǽǡη */

struct ModeNameRecs {
  int           alloc;
  wchar_t       *name;
};


/*
 * ޻Ѵơ֥ϣĤɤǤ礦ʣɬפʤΤ
 *  RomeStruct ΥФȤƤɬפ⤢ޤ礦...
 * λϤλǹͤޤ礦
 */
     
extern struct RkwRxDic *romajidic, *RkwOpenRoma();

/*
 * ̾Ƥѿ
 */

#define MAX_DICS 16

extern char *kanjidicname[];
extern int  nkanjidics;

extern char *userdicname[];
extern int  nuserdics;
extern char userdicstatus[];

extern char *bushudicname[];
extern int nbushudics;

extern char *localdicname[];
extern int nlocaldics;

/*
 * 顼ΥåƤѿ
 */

extern char *necKanjiError;

/*
 * ǥХʸɽ뤫ɤΥե饰
 */

extern iroha_debug;

/*
 * 16ʥϤԤɽ뤫ɤĴ٤
 */

#define hexGLine(plen) (d->ncolumns /2 >= plen + 4)

/*
 * 󥹤ȯ褦ʥ
 */

#define IrohaFunctionKey(key) \
  ((0x80 <= (int)(unsigned char)(key) &&  \
    (int)(unsigned char)(key) <= 0x8b) || \
   (0x90 <= (int)(unsigned char)(key) &&  \
    (int)(unsigned char)(key) <= 0x9b) || \
   (0xe0 <= (int)(unsigned char)(key) &&  \
    (int)(unsigned char)(key) <= 0xff) )

/* selectOne ǥХåȼɤɽޥ */

#define WITHOUT_LIST_CALLBACK 0
#define WITH_LIST_CALLBACK    1

/*
 * Rk ؿȥ졼뤿̾ν񤭴
 */

#ifdef DEBUG
#include "traceRK.h"
#endif /* DEBUG */

/*
 * ǥХåѤΥޥ
 */

#ifdef DEBUG
#define debug_message(fmt, x, y, z)	dbg_msg(fmt, x, y, z)
#else /* !DEBUG */
#define debug_message(fmt, x, y, z)
#endif /* !DEBUG */

/*
 * malloc ΥǥХ
 */

#ifdef DEBUG_ALLOC
extern int fail_malloc;
#define malloc(n) debug_malloc(n)
#endif /* DEBUG_MALLOC */

#ifndef	_UTIL_FUNCTIONS_DEF_

#define	_UTIL_FUNCTIONS_DEF_

extern makeGLineMessage();
extern makeGLineMessageFromStrings();
extern setWStrings();
extern WStrlen();
extern wchar_t *WStrcat();
extern wchar_t *WStrcpy();
extern wchar_t *WStrncpy();
extern WStrncmp();
extern MBstowcs();
extern wchar_t *WString();

#endif	/* _UTIL_FUNCTIONS_DEF_ */

/*
 * ⡼ɤ빽¤
 */

typedef struct {
  wchar_t         *display_name; /* ⡼ɽ̾ */
  unsigned char   *romaji_table; /* ޻Ѵơ֥(EUC) */
  struct RkwRxDic *romdic;	 /* ޻¤ */
  long            romdic_owner;  /* ޻ʬOpen */
  long            flags;	 /* flags for yomiContext->generalFlags */
  KanjiMode       emode;	 /* current_mode 빽¤ */
} newmode;

#define MAX_OTHER_MODES 16

/* ޻Ѵ­륭ʸѴơ֥ */

typedef struct {
  wchar_t	key;		/*  */
  int		groupid;	/* 롼id */
  int           ncand;          /* ο */
  wchar_t       **cand;         /*  */
  wchar_t	*fullword;	/*  (1@2@...n@@) */
} keySupplement;

#define MAX_KEY_SUP 64

#ifndef	DEBUG_CHIKUJI
#define	debugging(a)
#define debuggingf(a, b)
#define debuggingw(a, b, c)
#endif	/* DEBUG_CHIKUJI */

#define HEX_USUAL     0
#define HEX_IMMEDIATE 1

#define CANNA_HALF_VERBOSE 1

#endif /* !_CANNA_H_ */
