package MyCanvas.KaisetsuCanvas;


import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;                   //Java3d
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;                     //Point3f,Color3f
import javax.vecmath.Vector3f;

import MyMain.CameraPointingGame;
import MyMain.TextData;

import com.sun.j3d.utils.applet.MainFrame;  //MainFrame
import com.sun.j3d.utils.geometry.Text2D;        //Primitive
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.universe.SimpleUniverse;        //SimpleUniverse
public class KaisetsuCanvas{

    private SimpleUniverse simpleU;
    private BoundingSphere bounds = new BoundingSphere(new Point3d(), 10.0);
    public Canvas3D canvas;
    public PickCanvas cnvs=null;
    //private MyOwnCode   code=null;
    
    //I{^
    Transform3D endTfd = null;
    TransformGroup endTg = null;
    Shape3D endShape3D = null;
    //̖ʃ{^
    Transform3D nextTfd = null;
    TransformGroup nextTg = null;
    Shape3D nextShape3D = null;

	//\
	//Ԍo߃~bg
	public static Transform3D kaisetsu1TF3D ;
	public static TransformGroup kaisetsu1TFG;

	public static Transform3D kaisetsu2TF3D ;
	public static TransformGroup kaisetsu2TFG;
	
	public static Transform3D kaisetsu3TF3D ;
	public static TransformGroup kaisetsu3TFG;
	
	public static Transform3D kaisetsu4TF3D ;
	public static TransformGroup kaisetsu4TFG;
	
	//@
	public static Transform3D infoTF3D;
	public static TransformGroup infoTFG;
	
    BranchGroup branchG0;

	public float move1 = 0.0f;
	public float move2 = 0.0f;
	public float move3 = 0.0f;
	public static MainFrame frame;
	
	CameraPointingGame cameraPointingGame;

    public KaisetsuCanvas(CameraPointingGame cameraPointingGame){

    	this.cameraPointingGame = cameraPointingGame;

        canvas = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        canvas.setBounds(0,0,1024,768);
        cameraPointingGame.frame.add(canvas, BorderLayout.CENTER);

        simpleU = new SimpleUniverse(canvas);
        simpleU.getViewingPlatform().setNominalViewingTransform();

        simpleU.addBranchGraph(createSceneGraph());
    }
    
	public void prepareText(){
        
		kaisetsu1TF3D = new Transform3D();
		kaisetsu1TF3D.setTranslation(new Vector3f(-0.8f, 0.4f, 0.0f));
		kaisetsu1TFG = new TransformGroup(kaisetsu1TF3D);  
		createKaisetsuText(kaisetsu1TFG, TextData.KAISETSU_LINE1);
        branchG0.addChild(kaisetsu1TFG);
        
		kaisetsu2TF3D = new Transform3D();
		kaisetsu2TF3D.setTranslation(new Vector3f(-0.8f, 0.2f, 0.0f));
		kaisetsu2TFG = new TransformGroup(kaisetsu2TF3D);  
		createKaisetsuText(kaisetsu2TFG, TextData.KAISETSU_LINE2);
        branchG0.addChild(kaisetsu2TFG);
        
		kaisetsu3TF3D = new Transform3D();
		kaisetsu3TF3D.setTranslation(new Vector3f(-0.8f, 0.0f, 0.0f));
		kaisetsu3TFG = new TransformGroup(kaisetsu3TF3D);  
		createKaisetsuText(kaisetsu3TFG, TextData.KAISETSU_LINE3);
        branchG0.addChild(kaisetsu3TFG);
        
		kaisetsu4TF3D = new Transform3D();
		kaisetsu4TF3D.setTranslation(new Vector3f(-0.8f, -0.2f, 0.0f));
		kaisetsu4TFG = new TransformGroup(kaisetsu4TF3D);  
		createKaisetsuText(kaisetsu4TFG, TextData.KAISETSU_LINE4);
        branchG0.addChild(kaisetsu4TFG);
        
        
        infoTF3D = new Transform3D();
        infoTF3D.setTranslation(new Vector3f(-0.9f, -0.7f, 0.0f));
        infoTFG = new TransformGroup(infoTF3D);  
        createText(infoTFG, TextData.MENU_START_AND_EXIT);
        branchG0.addChild(infoTFG);
	}

    private void createKaisetsuText(TransformGroup tg, String str){
    	Text2D text2d = new Text2D(
    			str,
    			new Color3f(0.1f,0.1f,0.4f),
    			TextData.FONT,
    			14,
    			Font.BOLD);
    	

        Appearance app = text2d.getAppearance();
        app.setCapability(Appearance.ALLOW_TEXTURE_READ);
        app.setCapability(Appearance.ALLOW_TEXTURE_WRITE);
    	tg.addChild(text2d);
    }
    
    private void createText(TransformGroup tg, String str){
    	Text2D text2d = new Text2D(
    			str,
    			new Color3f(0.1f,0.1f,0.4f),
    			TextData.FONT,
    			18,
    			Font.BOLD);
    	

        Appearance app = text2d.getAppearance();
        app.setCapability(Appearance.ALLOW_TEXTURE_READ);
        app.setCapability(Appearance.ALLOW_TEXTURE_WRITE);
    	tg.addChild(text2d);
    }
    private BranchGroup createSceneGraph(){

        branchG0 = new BranchGroup();

        //wiF̐ݒiݒ肪ꍇ͍j
		//Toolkit toolkit = Toolkit.getDefaultToolkit();
		BufferedImage someImage = null;
		try {
			someImage = ImageIO.read(new File("res/gameback_bokashi.png"));
		} catch (IOException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
    	ImageComponent2D image=new ImageComponent2D(
    			ImageComponent2D.FORMAT_RGB,someImage);
    	Background background=new Background(image);
    	
        //Background background = new Background(new Color3f(0.8f, 0.9f, 1.0f));
        background.setApplicationBounds(bounds);
        branchG0.addChild(background);
        
        KaisetsuCanvasBehavior myBehavior3 = new KaisetsuCanvasBehavior(kaisetsu1TFG,cameraPointingGame);
        myBehavior3.setSchedulingBounds(bounds);
        branchG0.addChild(myBehavior3);


        //eLXg\
        prepareText();


        branchG0.compile();

        return branchG0;
    }

    public void destroy(){

        simpleU.cleanup();
    }


}

 