package MyCanvas.GameCanvas;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;


public class RotateAnimThread implements Runnable{

	Transform3D tfd = null;
	TransformGroup tg = null;
	CpLock cpLock = null;
	
    public boolean startThread(Transform3D tf3d, TransformGroup tfg, CpLock cpLock){
		
    	this.cpLock = cpLock;
    	
    	if (this.cpLock.getIsTurn() == true){
			return false;
		}
		
		//]Jn
    	this.cpLock.setIsTurn();
		
		tfd = tf3d;
    	tg = tfg;
        
    	Thread thread = new Thread(this);
    	thread.start();
    	
    	//]I
    	this.cpLock.resetIsTurn();
		
		return true;
    }
    
	public void run()
	{
		animTrans();
	}
	
	private void animTrans() {
		
		for (int r = 1; r < 4; r += 1) {
			for (int x = 1; x < 6; x += 1) {
				tfd.setRotation(new AxisAngle4f(0.8f, 0.0f, 0.0f,
						(float) (Math.PI / (0.1f * x))));
				tg.setTransform(tfd);

				try {
					Thread.sleep(100); // 100~bSleep
				} catch (InterruptedException e) {
				}
			}
		}
	}
}