/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.ShortIndexer;

public class ShortArrayIndexer
extends ShortIndexer {
    protected short[] array;

    public ShortArrayIndexer(short[] array, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public short[] array() {
        return this.array;
    }

    @Override
    public short get(int i) {
        return this.array[i];
    }

    @Override
    public ShortIndexer get(int i, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.array[i * this.strides[0] + n];
        }
        return this;
    }

    @Override
    public short get(int i, int j) {
        return this.array[i * this.strides[0] + j];
    }

    @Override
    public ShortIndexer get(int i, int j, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.array[i * this.strides[0] + j * this.strides[1] + n];
        }
        return this;
    }

    @Override
    public short get(int i, int j, int k) {
        return this.array[i * this.strides[0] + j * this.strides[1] + k];
    }

    @Override
    public short get(int ... indices) {
        return this.array[this.index(indices)];
    }

    @Override
    public ShortIndexer get(int[] indices, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.array[this.index(indices) + n];
        }
        return this;
    }

    @Override
    public ShortIndexer put(int i, short s) {
        this.array[i] = s;
        return this;
    }

    @Override
    public ShortIndexer put(int i, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + n] = s[offset + n];
        }
        return this;
    }

    @Override
    public ShortIndexer put(int i, int j, short s) {
        this.array[i * this.strides[0] + j] = s;
        return this;
    }

    @Override
    public ShortIndexer put(int i, int j, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + j * this.strides[1] + n] = s[offset + n];
        }
        return this;
    }

    @Override
    public ShortIndexer put(int i, int j, int k, short s) {
        this.array[i * this.strides[0] + j * this.strides[1] + k] = s;
        return this;
    }

    @Override
    public ShortIndexer put(int[] indices, short s) {
        this.array[this.index((int[])indices)] = s;
        return this;
    }

    @Override
    public ShortIndexer put(int[] indices, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[this.index((int[])indices) + n] = s[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

