/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.IntIndexer;

public class IntArrayIndexer
extends IntIndexer {
    protected int[] array;

    public IntArrayIndexer(int[] array, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public int[] array() {
        return this.array;
    }

    @Override
    public int get(int i) {
        return this.array[i];
    }

    @Override
    public IntIndexer get(int i, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.array[i * this.strides[0] + n];
        }
        return this;
    }

    @Override
    public int get(int i, int j) {
        return this.array[i * this.strides[0] + j];
    }

    @Override
    public IntIndexer get(int i, int j, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.array[i * this.strides[0] + j * this.strides[1] + n];
        }
        return this;
    }

    @Override
    public int get(int i, int j, int k) {
        return this.array[i * this.strides[0] + j * this.strides[1] + k];
    }

    @Override
    public int get(int ... indices) {
        return this.array[this.index(indices)];
    }

    @Override
    public IntIndexer get(int[] indices, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.array[this.index(indices) + n];
        }
        return this;
    }

    @Override
    public IntIndexer put(int i, int n) {
        this.array[i] = n;
        return this;
    }

    @Override
    public IntIndexer put(int i, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + n] = m[offset + n];
        }
        return this;
    }

    @Override
    public IntIndexer put(int i, int j, int n) {
        this.array[i * this.strides[0] + j] = n;
        return this;
    }

    @Override
    public IntIndexer put(int i, int j, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + j * this.strides[1] + n] = m[offset + n];
        }
        return this;
    }

    @Override
    public IntIndexer put(int i, int j, int k, int n) {
        this.array[i * this.strides[0] + j * this.strides[1] + k] = n;
        return this;
    }

    @Override
    public IntIndexer put(int[] indices, int n) {
        this.array[this.index((int[])indices)] = n;
        return this;
    }

    @Override
    public IntIndexer put(int[] indices, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[this.index((int[])indices) + n] = m[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

