/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.opencv_calib3d;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_features2d;
import org.bytedeco.javacpp.opencv_flann;
import org.bytedeco.javacpp.opencv_imgcodecs;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.BaseChildSettings;
import org.bytedeco.javacv.CanvasFrame;
import org.bytedeco.javacv.OpenCVFrameConverter;

public class ObjectFinder {
    Settings settings;
    static final Logger logger = Logger.getLogger(ObjectFinder.class.getName());
    opencv_core.KeyPointVector objectKeypoints = null;
    opencv_core.KeyPointVector imageKeypoints = null;
    opencv_core.Mat objectDescriptors = null;
    opencv_core.Mat imageDescriptors = null;
    opencv_core.Mat indicesMat;
    opencv_core.Mat distsMat;
    opencv_flann.Index flannIndex = null;
    opencv_flann.IndexParams indexParams = null;
    opencv_flann.SearchParams searchParams = null;
    opencv_core.Mat pt1 = null;
    opencv_core.Mat pt2 = null;
    opencv_core.Mat mask = null;
    opencv_core.Mat H = null;
    ArrayList<Integer> ptpairs = null;
    static final int[] bits = new int[256];

    public ObjectFinder(opencv_core.IplImage objectImage) {
        this.settings = new Settings();
        this.settings.objectImage = objectImage;
        this.setSettings(this.settings);
    }

    public ObjectFinder(Settings settings) {
        this.setSettings(settings);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this.objectKeypoints = new opencv_core.KeyPointVector();
        this.objectDescriptors = new opencv_core.Mat();
        settings.detector.detectAndCompute(opencv_core.cvarrToMat(settings.objectImage), new opencv_core.Mat(), this.objectKeypoints, this.objectDescriptors, false);
        int total = (int)this.objectKeypoints.size();
        if (settings.useFLANN) {
            this.indicesMat = new opencv_core.Mat(total, 2, opencv_core.CV_32SC1);
            this.distsMat = new opencv_core.Mat(total, 2, opencv_core.CV_32FC1);
            this.flannIndex = new opencv_flann.Index();
            this.indexParams = new opencv_flann.LshIndexParams(12, 20, 2);
            this.searchParams = new opencv_flann.SearchParams(64, 0.0f, true);
        }
        this.pt1 = new opencv_core.Mat(total, 1, opencv_core.CV_32FC2);
        this.pt2 = new opencv_core.Mat(total, 1, opencv_core.CV_32FC2);
        this.mask = new opencv_core.Mat(total, 1, opencv_core.CV_8UC1);
        this.H = new opencv_core.Mat(3, 3, opencv_core.CV_64FC1);
        this.ptpairs = new ArrayList(2 * this.objectDescriptors.rows());
        logger.info(total + " object descriptors");
    }

    public double[] find(opencv_core.IplImage image) {
        if (this.objectDescriptors.rows() < this.settings.getMatchesMin()) {
            return null;
        }
        this.imageKeypoints = new opencv_core.KeyPointVector();
        this.imageDescriptors = new opencv_core.Mat();
        this.settings.detector.detectAndCompute(opencv_core.cvarrToMat(image), new opencv_core.Mat(), this.imageKeypoints, this.imageDescriptors, false);
        if (this.imageDescriptors.rows() < this.settings.getMatchesMin()) {
            return null;
        }
        int total = (int)this.imageKeypoints.size();
        logger.info(total + " image descriptors");
        int w = this.settings.objectImage.width();
        int h = this.settings.objectImage.height();
        double[] srcCorners = new double[]{0.0, 0.0, w, 0.0, w, h, 0.0, h};
        double[] dstCorners = this.locatePlanarObject(this.objectKeypoints, this.objectDescriptors, this.imageKeypoints, this.imageDescriptors, srcCorners);
        return dstCorners;
    }

    int compareDescriptors(ByteBuffer d1, ByteBuffer d2, int best) {
        int totalCost = 0;
        assert (d1.limit() - d1.position() == d2.limit() - d2.position());
        while (d1.position() < d1.limit() && (totalCost += bits[(d1.get() ^ d2.get()) & 0xFF]) <= best) {
        }
        return totalCost;
    }

    int naiveNearestNeighbor(ByteBuffer vec, ByteBuffer modelDescriptors) {
        int neighbor = -1;
        int dist1 = Integer.MAX_VALUE;
        int dist2 = Integer.MAX_VALUE;
        int size = vec.limit() - vec.position();
        int i = 0;
        while (i * size < modelDescriptors.capacity()) {
            ByteBuffer mvec = (ByteBuffer)modelDescriptors.position(i * size).limit((i + 1) * size);
            int d = this.compareDescriptors((ByteBuffer)vec.reset(), mvec, dist2);
            if (d < dist1) {
                dist2 = dist1;
                dist1 = d;
                neighbor = i;
            } else if (d < dist2) {
                dist2 = d;
            }
            ++i;
        }
        if ((double)dist1 < this.settings.distanceThreshold * (double)dist2) {
            return neighbor;
        }
        return -1;
    }

    void findPairs(opencv_core.Mat objectDescriptors, opencv_core.Mat imageDescriptors) {
        int size = imageDescriptors.cols();
        ByteBuffer objectBuf = (ByteBuffer)objectDescriptors.createBuffer();
        ByteBuffer imageBuf = (ByteBuffer)imageDescriptors.createBuffer();
        int i = 0;
        while (i * size < objectBuf.capacity()) {
            ByteBuffer descriptor = (ByteBuffer)objectBuf.position(i * size).limit((i + 1) * size).mark();
            int nearestNeighbor = this.naiveNearestNeighbor(descriptor, imageBuf);
            if (nearestNeighbor >= 0) {
                this.ptpairs.add(i);
                this.ptpairs.add(nearestNeighbor);
            }
            ++i;
        }
    }

    void flannFindPairs(opencv_core.Mat objectDescriptors, opencv_core.Mat imageDescriptors) {
        int length = objectDescriptors.rows();
        this.flannIndex.build(imageDescriptors, this.indexParams, 9);
        this.flannIndex.knnSearch(objectDescriptors, this.indicesMat, this.distsMat, 2, this.searchParams);
        IntBuffer indicesBuf = (IntBuffer)this.indicesMat.createBuffer();
        IntBuffer distsBuf = (IntBuffer)this.distsMat.createBuffer();
        for (int i = 0; i < length; ++i) {
            if (!((double)distsBuf.get(2 * i) < this.settings.distanceThreshold * (double)distsBuf.get(2 * i + 1))) continue;
            this.ptpairs.add(i);
            this.ptpairs.add(indicesBuf.get(2 * i));
        }
    }

    double[] locatePlanarObject(opencv_core.KeyPointVector objectKeypoints, opencv_core.Mat objectDescriptors, opencv_core.KeyPointVector imageKeypoints, opencv_core.Mat imageDescriptors, double[] srcCorners) {
        this.ptpairs.clear();
        if (this.settings.useFLANN) {
            this.flannFindPairs(objectDescriptors, imageDescriptors);
        } else {
            this.findPairs(objectDescriptors, imageDescriptors);
        }
        int n = this.ptpairs.size() / 2;
        logger.info(n + " matching pairs found");
        if (n < this.settings.matchesMin) {
            return null;
        }
        this.pt1.resize(n);
        this.pt2.resize(n);
        this.mask.resize(n);
        FloatBuffer pt1Idx = (FloatBuffer)this.pt1.createBuffer();
        FloatBuffer pt2Idx = (FloatBuffer)this.pt2.createBuffer();
        for (int i = 0; i < n; ++i) {
            opencv_core.Point2f p1 = objectKeypoints.get(this.ptpairs.get(2 * i).intValue()).pt();
            pt1Idx.put(2 * i, p1.x());
            pt1Idx.put(2 * i + 1, p1.y());
            opencv_core.Point2f p2 = imageKeypoints.get(this.ptpairs.get(2 * i + 1).intValue()).pt();
            pt2Idx.put(2 * i, p2.x());
            pt2Idx.put(2 * i + 1, p2.y());
        }
        this.H = opencv_calib3d.findHomography(this.pt1, this.pt2, 8, this.settings.ransacReprojThreshold, this.mask, 2000, 0.995);
        if (this.H.empty() || opencv_core.countNonZero(this.mask) < this.settings.matchesMin) {
            return null;
        }
        double[] h = (double[])((Indexer)this.H.createIndexer(false)).array();
        double[] dstCorners = new double[srcCorners.length];
        for (int i = 0; i < srcCorners.length / 2; ++i) {
            double x = srcCorners[2 * i];
            double y = srcCorners[2 * i + 1];
            double Z = 1.0 / (h[6] * x + h[7] * y + h[8]);
            double X = (h[0] * x + h[1] * y + h[2]) * Z;
            double Y = (h[3] * x + h[4] * y + h[5]) * Z;
            dstCorners[2 * i] = X;
            dstCorners[2 * i + 1] = Y;
        }
        return dstCorners;
    }

    public static void main(String[] args) throws Exception {
        int i;
        String objectFilename = args.length == 2 ? args[0] : "/usr/local/share/OpenCV/samples/c/box.png";
        String sceneFilename = args.length == 2 ? args[1] : "/usr/local/share/OpenCV/samples/c/box_in_scene.png";
        opencv_core.IplImage object = opencv_imgcodecs.cvLoadImage(objectFilename, 0);
        opencv_core.IplImage image = opencv_imgcodecs.cvLoadImage(sceneFilename, 0);
        if (object == null || image == null) {
            System.err.println("Can not load " + objectFilename + " and/or " + sceneFilename);
            System.exit(-1);
        }
        opencv_core.IplImage objectColor = opencv_core.IplImage.create(object.width(), object.height(), 8, 3);
        opencv_imgproc.cvCvtColor(object, objectColor, 8);
        opencv_core.IplImage correspond = opencv_core.IplImage.create(image.width(), object.height() + image.height(), 8, 1);
        opencv_core.cvSetImageROI(correspond, opencv_core.cvRect(0, 0, object.width(), object.height()));
        opencv_core.cvCopy(object, correspond);
        opencv_core.cvSetImageROI(correspond, opencv_core.cvRect(0, object.height(), correspond.width(), correspond.height()));
        opencv_core.cvCopy(image, correspond);
        opencv_core.cvResetImageROI(correspond);
        Settings settings = new Settings();
        settings.objectImage = object;
        settings.useFLANN = true;
        settings.ransacReprojThreshold = 5.0;
        ObjectFinder finder = new ObjectFinder(settings);
        long start = System.currentTimeMillis();
        double[] dst_corners = finder.find(image);
        System.out.println("Finding time = " + (System.currentTimeMillis() - start) + " ms");
        if (dst_corners != null) {
            for (i = 0; i < 4; ++i) {
                int j = (i + 1) % 4;
                int x1 = (int)Math.round(dst_corners[2 * i]);
                int y1 = (int)Math.round(dst_corners[2 * i + 1]);
                int x2 = (int)Math.round(dst_corners[2 * j]);
                int y2 = (int)Math.round(dst_corners[2 * j + 1]);
                opencv_imgproc.line(opencv_core.cvarrToMat(correspond), new opencv_core.Point(x1, y1 + object.height()), new opencv_core.Point(x2, y2 + object.height()), opencv_core.Scalar.WHITE, 1, 8, 0);
            }
        }
        for (i = 0; i < finder.ptpairs.size(); i += 2) {
            opencv_core.Point2f pt1 = finder.objectKeypoints.get(finder.ptpairs.get(i).intValue()).pt();
            opencv_core.Point2f pt2 = finder.imageKeypoints.get(finder.ptpairs.get(i + 1).intValue()).pt();
            opencv_imgproc.line(opencv_core.cvarrToMat(correspond), new opencv_core.Point(Math.round(pt1.x()), Math.round(pt1.y())), new opencv_core.Point(Math.round(pt2.x()), Math.round(pt2.y() + (float)object.height())), opencv_core.Scalar.WHITE, 1, 8, 0);
        }
        CanvasFrame objectFrame = new CanvasFrame("Object");
        CanvasFrame correspondFrame = new CanvasFrame("Object Correspond");
        OpenCVFrameConverter.ToIplImage converter = new OpenCVFrameConverter.ToIplImage();
        correspondFrame.showImage(((OpenCVFrameConverter)converter).convert(correspond));
        int i2 = 0;
        while ((long)i2 < finder.objectKeypoints.size()) {
            opencv_core.KeyPoint r = finder.objectKeypoints.get(i2);
            opencv_core.Point center = new opencv_core.Point(Math.round(r.pt().x()), Math.round(r.pt().y()));
            int radius = Math.round(r.size() / 2.0f);
            opencv_imgproc.circle(opencv_core.cvarrToMat(objectColor), center, radius, opencv_core.Scalar.RED, 1, 8, 0);
            ++i2;
        }
        objectFrame.showImage(((OpenCVFrameConverter)converter).convert(objectColor));
        objectFrame.waitKey();
        objectFrame.dispose();
        correspondFrame.dispose();
    }

    static {
        for (int i = 0; i < bits.length; ++i) {
            for (int j = i; j != 0; j >>= 1) {
                int n = i;
                bits[n] = bits[n] + (j & 1);
            }
        }
    }

    public static class Settings
    extends BaseChildSettings {
        opencv_core.IplImage objectImage = null;
        opencv_features2d.AKAZE detector = opencv_features2d.AKAZE.create();
        double distanceThreshold = 0.75;
        int matchesMin = 4;
        double ransacReprojThreshold = 1.0;
        boolean useFLANN = false;

        public opencv_core.IplImage getObjectImage() {
            return this.objectImage;
        }

        public void setObjectImage(opencv_core.IplImage objectImage) {
            this.objectImage = objectImage;
        }

        public int getDescriptorType() {
            return this.detector.getDescriptorType();
        }

        public void setDescriptorType(int dtype) {
            this.detector.setDescriptorType(dtype);
        }

        public int getDescriptorSize() {
            return this.detector.getDescriptorSize();
        }

        public void setDescriptorSize(int dsize) {
            this.detector.setDescriptorSize(dsize);
        }

        public int getDescriptorChannels() {
            return this.detector.getDescriptorChannels();
        }

        public void setDescriptorChannels(int dch) {
            this.detector.setDescriptorChannels(dch);
        }

        public double getThreshold() {
            return this.detector.getThreshold();
        }

        public void setThreshold(double threshold) {
            this.detector.setThreshold(threshold);
        }

        public int getNOctaves() {
            return this.detector.getNOctaves();
        }

        public void setNOctaves(int nOctaves) {
            this.detector.setNOctaves(nOctaves);
        }

        public int getNOctaveLayers() {
            return this.detector.getNOctaveLayers();
        }

        public void setNOctaveLayers(int nOctaveLayers) {
            this.detector.setNOctaveLayers(nOctaveLayers);
        }

        public double getDistanceThreshold() {
            return this.distanceThreshold;
        }

        public void setDistanceThreshold(double distanceThreshold) {
            this.distanceThreshold = distanceThreshold;
        }

        public int getMatchesMin() {
            return this.matchesMin;
        }

        public void setMatchesMin(int matchesMin) {
            this.matchesMin = matchesMin;
        }

        public double getRansacReprojThreshold() {
            return this.ransacReprojThreshold;
        }

        public void setRansacReprojThreshold(double ransacReprojThreshold) {
            this.ransacReprojThreshold = ransacReprojThreshold;
        }

        public boolean isUseFLANN() {
            return this.useFLANN;
        }

        public void setUseFLANN(boolean useFLANN) {
            this.useFLANN = useFLANN;
        }
    }
}

