/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.bytedeco.javacpp.indexer.FloatIndexer;

public class FloatBufferIndexer
extends FloatIndexer {
    protected FloatBuffer buffer;

    public FloatBufferIndexer(FloatBuffer buffer, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public float get(int i) {
        return this.buffer.get(i);
    }

    @Override
    public FloatIndexer get(int i, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.buffer.get(i * this.strides[0] + n);
        }
        return this;
    }

    @Override
    public float get(int i, int j) {
        return this.buffer.get(i * this.strides[0] + j);
    }

    @Override
    public FloatIndexer get(int i, int j, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.buffer.get(i * this.strides[0] + j * this.strides[1] + n);
        }
        return this;
    }

    @Override
    public float get(int i, int j, int k) {
        return this.buffer.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public float get(int ... indices) {
        return this.buffer.get(this.index(indices));
    }

    @Override
    public FloatIndexer get(int[] indices, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.buffer.get(this.index(indices) + n);
        }
        return this;
    }

    @Override
    public FloatIndexer put(int i, float f) {
        this.buffer.put(i, f);
        return this;
    }

    @Override
    public FloatIndexer put(int i, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + n, f[offset + n]);
        }
        return this;
    }

    @Override
    public FloatIndexer put(int i, int j, float f) {
        this.buffer.put(i * this.strides[0] + j, f);
        return this;
    }

    @Override
    public FloatIndexer put(int i, int j, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + j * this.strides[1] + n, f[offset + n]);
        }
        return this;
    }

    @Override
    public FloatIndexer put(int i, int j, int k, float f) {
        this.buffer.put(i * this.strides[0] + j * this.strides[1] + k, f);
        return this;
    }

    @Override
    public FloatIndexer put(int[] indices, float f) {
        this.buffer.put(this.index(indices), f);
        return this;
    }

    @Override
    public FloatIndexer put(int[] indices, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(this.index(indices) + n, f[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

