/*
 * Decompiled with CFR 0.152.
 */
package Cameus;

import Cameus.KamesMouse;
import MyMain.CameraPointingGame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.opencv.core.Mat;
import org.opencv.core.MatOfRect;
import org.opencv.core.Rect;
import org.opencv.core.Size;
import org.opencv.highgui.VideoCapture;
import org.opencv.imgproc.Imgproc;
import org.opencv.objdetect.CascadeClassifier;

public class KameusThread
extends JPanel
implements Runnable {
    private static final long serialVersionUID = 1L;
    public static int CameraDeviceNumber;
    private BufferedImage mImg;
    Mat dst;
    Mat dst1;
    Mat dst2;
    MatOfRect objDetections;
    Size minSize;
    Size maxSize;
    Point mouseP;
    Point cameraP;
    CameraPointingGame cameraPointingGame;
    public static VideoCapture capture;

    public KameusThread(CameraPointingGame cameraPointingGame) {
        System.out.println("opencv_java300");
        this.cameraPointingGame = cameraPointingGame;
        this.dst = new Mat();
        this.dst1 = new Mat();
        this.dst2 = new Mat();
        this.objDetections = new MatOfRect();
        this.minSize = new Size(25.0, 25.0);
        this.maxSize = new Size(60.0, 60.0);
        this.mouseP = new Point();
        this.cameraP = new Point();
    }

    public void dobj(CascadeClassifier objDetector, Mat src, int width, int height, KamesMouse kames) {
        this.dst1 = src.submat(new Rect(320, 40, 640, 640));
        Imgproc.cvtColor((Mat)this.dst1, (Mat)this.dst2, (int)7);
        Imgproc.equalizeHist((Mat)this.dst2, (Mat)this.dst);
        objDetector.detectMultiScale(this.dst, this.objDetections, 1.11, 2, 0, this.minSize, this.maxSize);
        if (this.objDetections.toArray().length <= 0) {
            return;
        }
        int rectWidth = 0;
        Rect[] rectArray = this.objDetections.toArray();
        int n = rectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rect rect = rectArray[n2];
            if (rect.width - rect.height <= 10 && rect.width - rect.height >= -10) {
                this.mouseP.x = rect.x + rect.width / 2;
                this.mouseP.y = rect.y + rect.height / 2;
                rectWidth = rect.width;
                this.cameraP.x = 320;
                this.cameraP.y = 320;
                int x = this.cameraP.x - this.mouseP.x;
                int y = this.cameraP.y - this.mouseP.y;
                float smallNum = 32.0f / (float)rectWidth;
                x = Math.round((float)x * smallNum / 3.0f);
                y = Math.round((float)y * smallNum / 3.0f);
                kames.GetNowCursor();
                kames.MoveMouse(new Point(x, y));
                return;
            }
            ++n2;
        }
    }

    public void dobj640x480(CascadeClassifier objDetector, Mat src, int width, int height, KamesMouse kames) {
        this.dst1 = src;
        Imgproc.cvtColor((Mat)this.dst1, (Mat)this.dst2, (int)7);
        Imgproc.equalizeHist((Mat)this.dst2, (Mat)this.dst);
        objDetector.detectMultiScale(this.dst, this.objDetections, 1.11, 2, 0, this.minSize, this.maxSize);
        if (this.objDetections.toArray().length <= 0) {
            return;
        }
        int rectWidth = 0;
        Rect[] rectArray = this.objDetections.toArray();
        int n = rectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rect rect = rectArray[n2];
            if (rect.width - rect.height <= 10 && rect.width - rect.height >= -10) {
                this.mouseP.x = rect.x + rect.width / 2;
                this.mouseP.y = rect.y + rect.height / 2;
                rectWidth = rect.width;
                this.cameraP.x = 320;
                this.cameraP.y = 240;
                int x = this.cameraP.x - this.mouseP.x;
                int y = this.cameraP.y - this.mouseP.y;
                float smallNum = 32.0f / (float)rectWidth;
                x = Math.round((float)x * smallNum / 3.0f);
                y = Math.round((float)y * smallNum / 3.0f);
                kames.GetNowCursor();
                kames.MoveMouse(new Point(x, y));
                return;
            }
            ++n2;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.mImg != null) {
            g.drawImage(this.mImg, 0, 0, this.mImg.getWidth(), this.mImg.getHeight(), this);
        }
    }

    public void startThread() {
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void run() {
        try {
            try {
                KamesMouse kames = new KamesMouse(this.cameraPointingGame);
                CascadeClassifier objDetector = new CascadeClassifier("res/cascade.xml");
                Mat capImg = new Mat();
                capture = new VideoCapture(CameraDeviceNumber);
                capture.set(4, 720.0);
                capture.set(3, 1280.0);
                capture.read(capImg);
                if (capImg.width() == 1280 && capImg.height() == 720) {
                    System.out.println("Camera is 1280x720");
                    while (true) {
                        capture.read(capImg);
                        if (capImg == null) break;
                        this.dobj(objDetector, capImg, 1280, 720, kames);
                        Thread.sleep(10L);
                    }
                }
                capture.release();
            }
            catch (Exception e) {
                System.out.println("xxxx" + e);
                System.out.println("done");
            }
        }
        finally {
            System.out.println("done");
        }
    }
}

