using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;
//CaldBase.NET ŉwNX (A[JCo API 𒼐ڌĂяo֐Q)
using Archiver.Cald;

namespace UnDllerNet
{
    public partial class UnDller : Form
    {
        #region NXO[oϐ̒`
        CaldBase Cald = new CaldBase();
        private static ArrayList ApiNames;
        private static ArrayList DllNames;
        private static IntPtr hArcForOpenArchive;   //harc ێ
        private static string DllNameForOpenArchive;//harc JĂ DLL ێ
        private static bool isFindNextEnded;      //FindFirst / FindNext IǂB{I falseB
        private const string msgPleaseFindNextEnded = "(FindFirst/FindNext) ĂB";
        private const string msgPleaseCloseArchiveEnded = "(CloseArchive) sĂB";
        #endregion

        #region RXgN^ Private ȃ[eBeB֐
        public UnDller()
        {
            InitializeComponent();

            hArcForOpenArchive = IntPtr.Zero;
            DllNameForOpenArchive = "";
            isFindNextEnded = false;
        }

        private DateTime DosDateToDateTime(UInt16 iDate, UInt16 iTime)
        {
            int year =  iDate / 512 + 1980;
            int month = iDate % 512 / 32;
            int day = iDate % 512 % 32;
            int hour = iTime / 2048;
            int minute = iTime % 2048 / 32;
            int second = iTime % 2048 % 32 * 2;

            if (iDate == UInt16.MaxValue || month == 0 || day == 0)
            {
                year = 1980;
                month = 1;
                day = 1;
            }

            if (iTime == UInt16.MaxValue)
            {
                hour = minute = second = 0;
            }

            DateTime dt;
            try
            {
                dt = new DateTime(year, month, day, hour, minute, second);
            }
            catch
            {
                dt = new DateTime();
                MessageBox.Show("tvZG[: " + year.ToString("00") + "/" + month.ToString("00") + "/" + day.ToString("00") + " " + hour.ToString("00") + ":" + minute.ToString("00") +":" + second.ToString("00"));
            }
            return dt;
        }

        private void PutConsoleByIndividualInfo()
        {
            DateTime dt = DosDateToDateTime(Cald.SubInfo.wDate, Cald.SubInfo.wTime);
            //DateTime dt = new DateTime(year, month, day, hour, minute, second);

            tbConsole.Text += Environment.NewLine + "dwOriginalSize : " + Cald.SubInfo.dwOriginalSize;
            tbConsole.Text += Environment.NewLine + "dwCompressedSize : " + Cald.SubInfo.dwCompressedSize;
            tbConsole.Text += Environment.NewLine + "dwCRC : 0x" + Cald.SubInfo.dwCRC.ToString("x");
            tbConsole.Text += Environment.NewLine + "uFlag : " + Cald.SubInfo.uFlag;
            tbConsole.Text += Environment.NewLine + "uOSType : " + Cald.SubInfo.uOSType;
            tbConsole.Text += Environment.NewLine + "wRatio : " + Cald.SubInfo.wRatio;
            tbConsole.Text += Environment.NewLine + "wDate : 0x" + Cald.SubInfo.wDate.ToString("x");
            tbConsole.Text += Environment.NewLine + "wTime : 0x" + Cald.SubInfo.wTime.ToString("x");
            tbConsole.Text += Environment.NewLine + "(wDate + wTime) : " + dt.ToString();
            tbConsole.Text += Environment.NewLine + "szFileName : " + Cald.SubInfo.szFileName;
            tbConsole.Text += Environment.NewLine + "dummy1 : " + Cald.SubInfo.dummy1;
            tbConsole.Text += Environment.NewLine + "szAttribute : " + Cald.SubInfo.szAttribute;
            tbConsole.Text += Environment.NewLine + "szMode : " + Cald.SubInfo.szMode;
            tbConsole.Text += Environment.NewLine;
        }

        private void ApiFilter()
        {
            bool isDefaultApi = (apiDefaultToolStripMenuItem.Checked || apiAllToolStripMenuItem.Checked);
            bool isOpenArchiveApi = (apiOpenArchiveToolStripMenuItem.Checked || apiAllToolStripMenuItem.Checked);
            ApiNames = new ArrayList();
            if (isDefaultApi)
            {
                ApiNames.Add("GetVersion");
                ApiNames.Add("GetSubVersion");
                ApiNames.Add("GetRunning");
                ApiNames.Add("CheckArchive");
                ApiNames.Add("GetFileCount");
                ApiNames.Add("ConfigDialog");
                ApiNames.Add("Exec");
                ApiNames.Add("OpenArchive");
                ApiNames.Add("OpenArchive2");
                ApiNames.Add("SetCursorInterval");
                ApiNames.Add("GetCursorInterval");
                ApiNames.Add("GetCursorMode");
                ApiNames.Add("SetCursorMode");
                ApiNames.Add("GetBackGroundMode");
                ApiNames.Add("SetBackGroundMode");
                ApiNames.Add("QueryFunctionList");
                ApiNames.Add("SetPriority");
                ApiNames.Add("ExtractMem");
                ApiNames.Add("CompressMem");
            }
            if (isOpenArchiveApi)
            {
                //OpenArchive.All
                bool isOpenArcAll = (apiOpenArchiveAllToolStripMenuItem.Checked);
                //OpenArchive.Seek
                bool isOpenArcSeek = (apiOpenArchiveSeekToolStripMenuItem.Checked);
                //OpenArchive.Get
                bool isOpenArcGet = (apiOpenArchiveGetToolStripMenuItem.Checked);
                //OpenArchive.GetArc
                bool isOpenArcGetArc = (apiOpenArchiveGetArcToolStripMenuItem.Checked);

                if (isOpenArcAll || isOpenArcSeek)
                {
                    ApiNames.Add("CloseArchive");
                    ApiNames.Add("FindFirst");
                    ApiNames.Add("FindNext");
                }
                if (isOpenArcAll || isOpenArcGet)
                {
                    ApiNames.Add("GetFileName");
                    ApiNames.Add("GetAccessTime");
                    ApiNames.Add("GetCRC");
                    ApiNames.Add("GetCompressedSize");
                    ApiNames.Add("GetCreateTime");
                    ApiNames.Add("GetOriginalSize");
                    ApiNames.Add("GetWriteTime");
                    ApiNames.Add("GetDate");
                    ApiNames.Add("GetTime");
                    ApiNames.Add("GetRatio");
                    ApiNames.Add("GetMethod");
                    ApiNames.Add("GetAttribute");
                    ApiNames.Add("GetAccessTimeEx");
                    ApiNames.Add("GetCompressedSizeEx");
                    ApiNames.Add("GetCreateTimeEx");
                    ApiNames.Add("GetOriginalSizeEx");
                    ApiNames.Add("GetWriteTimeEx");
                    ApiNames.Add("GetOSType");
                    ApiNames.Add("IsSFXFile");
                }
                if (isOpenArcAll || isOpenArcGetArc)
                {
                    ApiNames.Add("GetArcFileName");
                    ApiNames.Add("GetArcCreateTimeEx");
                    ApiNames.Add("GetArcCompressedSize");
                    ApiNames.Add("GetArcFileSize");
                    ApiNames.Add("GetArcReadSize");
                    ApiNames.Add("GetArcOriginalSize");
                    ApiNames.Add("GetArcDate");
                    ApiNames.Add("GetArcTime");
                    ApiNames.Add("GetArcAccessTimeEx");
                    ApiNames.Add("GetArcCompressedSizeEx");
                    ApiNames.Add("GetArcFileSizeEx");
                    ApiNames.Add("GetArcOriginalSizeEx");
                    ApiNames.Add("GetArcRatio");
                    ApiNames.Add("GetArcReadSizeEx");
                    ApiNames.Add("GetArcWriteTimeEx");
                    ApiNames.Add("GetArcOSType");
                }
            }
            ApiNames.Sort();

            cbApiName.Items.Clear();
            foreach (string strapi in ApiNames)
            {
                cbApiName.Items.Add(strapi);
            }
            cbApiName.SelectedIndex = 0;
        }

        //API Filter  OpenArchive n舵[eBeB֐B
        // true  ON / false  OFFB
        private void apiOpenArchiveToolStripMenuItemCommon(bool isFilterForOpenArchive)
        {
            //OpenArchive ̎qj[͖őSItB
            apiOpenArchiveAllToolStripMenuItem.CheckState = CheckState.Unchecked;
            apiOpenArchiveSeekToolStripMenuItem.CheckState = CheckState.Unchecked;
            apiOpenArchiveGetToolStripMenuItem.CheckState = CheckState.Unchecked;
            apiOpenArchiveGetArcToolStripMenuItem.CheckState = CheckState.Unchecked;

            //OpenArchive n̎qI΂ꂽ
            if (isFilterForOpenArchive)
            {
                //API Filter  Default / All ̃`FbNItɂB
                apiDefaultToolStripMenuItem.CheckState = CheckState.Unchecked;
                apiAllToolStripMenuItem.CheckState = CheckState.Unchecked;

                //OpenArchive ̐ej[̃`FbN̓IɂB
                apiOpenArchiveToolStripMenuItem.CheckState = CheckState.Checked;
            }
            //OpenArchive ȊO`FbNIꂽ
            else
            {
                //OpenArchive ̐ej[̃`FbN̓ItɂB
                apiOpenArchiveToolStripMenuItem.CheckState = CheckState.Unchecked;
            }
        }

        //OpenArchive / OpenArchive2 Ăяoʊ֐
        //
        private void cbApiOpenArchiveCommon(bool isOpenArchive2Mode)
        {
            if (hArcForOpenArchive != IntPtr.Zero)
            {
                tbConsole.Text += DllNameForOpenArchive + msgPleaseCloseArchiveEnded;
            }
            else
            {
                isFindNextEnded = false;
                IntPtr hOpenArc;

                //ʏOpenArchive
                if (!isOpenArchive2Mode)
                {
                    hOpenArc = Cald.OpenArchive(this.Handle, cbCommand.Text, 0);
                }
                //OpenArchive2 IvVȂŌĂяoĂ݂
                else
                {
                    hOpenArc = Cald.OpenArchive2(this.Handle, cbCommand.Text, 0,"");
                }

                tbConsole.Text += hOpenArc + " (0x" + hOpenArc.ToString("x") + ")";
                if (hOpenArc != IntPtr.Zero)
                {
                    hArcForOpenArchive = hOpenArc;
                    DllNameForOpenArchive = cbDllName.Text;

                    if (!apiAllToolStripMenuItem.Checked)
                    {
                        apiDefaultToolStripMenuItem.CheckState = CheckState.Unchecked;

                        //OpenArchive ntB^ʊ֐B(ON)
                        apiOpenArchiveToolStripMenuItemCommon(true);
                        //OpenArchive.All `FbNIB
                        apiOpenArchiveAllToolStripMenuItem.CheckState = CheckState.Checked;
                        ApiFilter();
                    }
                }
            }

        }
        #endregion

        private void UnDller_Load(object sender, EventArgs e)
        {
            ApiFilter();

            //_CAÕTCYŒ艻            
            //this.FormBorderStyle = FormBorderStyle.FixedDialog;

            DllNames = new ArrayList();
            DllNames.Add("CALDBASE.DLL");
            //            cbDllName.Items.Add("CALDBASE.DLL");
            //            cbDllName.SelectedIndex = 0;
            //DLL̃R{{bNX`
            for (int idx = 1; ; idx++)
            {
                string strDllName;
                Cald.SetDllIndex(idx);
                strDllName = Cald.GetDllName();

                if (strDllName.Length > 0)
                {
                    //                    cbDllName.Items.Add(strDllName);
                    DllNames.Add(strDllName);
                }
                else
                {
                    break;
                }
            }

            DllNames.Sort();
            foreach (string dllname in DllNames)
            {
                cbDllName.Items.Add(dllname);
            }
            cbDllName.SelectedIndex = DllNames.IndexOf("CALDBASE.DLL");
        }

        #region {^̃NbN֘A
        private void btnExec_Click(object sender, EventArgs e)
        {
            Int64 ForSizeEx = new Int64();  //SizeEx API pϐ
            Int64 ForTimeEx = new Int64();  //TimeEx API pϐ

            StringBuilder Output = new StringBuilder(4096);
            tbConsole.Text += cbDllName.Text + "(" + cbApiName.Text + ") : ";

//          Cald.SetDllIndex(cbDllName.SelectedIndex);
            Cald.SetDllName(cbDllName.Text);

            switch (cbApiName.Text)
            {
                case "GetVersion":
                    int ver = Cald.GetVersion();
                    if (ver == 0)
                    {
                        tbConsole.Text += "DLL ̃o[W擾Ɏs܂B";
                    }
                    else
                    {
                        tbConsole.Text += ver.ToString("000");
                    }
                    break;
                case "GetSubVersion":
                    int subver = Cald.GetSubVersion();
                    tbConsole.Text += subver.ToString("000");
                    break;
                case "GetRunning":
                    tbConsole.Text += Cald.GetRunning().ToString();
                    break;
                case "CheckArchive":
                    tbConsole.Text += Cald.CheckArchive(cbCommand.Text,0).ToString();
                    break;
                case "GetCursorInterval":
                    tbConsole.Text += Cald.GetCursorInterval().ToString();
                    break;
                case "SetCursorInterval":
                    Int16 iSetCursorInterval;
                    try
                    {
                        iSetCursorInterval = Int16.Parse(cbCommand.Text);
                    }
                    catch
                    {
                        //ςȒlw肳Ă 80 ɂ
                        iSetCursorInterval = 80;
                    }
                    tbConsole.Text += Cald.SetCursorInterval(iSetCursorInterval).ToString();
                    break;
                case "QueryFunctionList":
                    int iQueryFunctionList;
                    try
                    {
                        iQueryFunctionList = int.Parse(cbCommand.Text);
                    }
                    catch
                    {
                        //ςȒlw肳Ă 0 ɂ
                        iQueryFunctionList = 0;
                    }
                    tbConsole.Text += Cald.QueryFunctionList(iQueryFunctionList).ToString();
                    break;
                case "SetPriority":
                    int iSetPriority;
                    try
                    {
                        iSetPriority = int.Parse(cbCommand.Text);
                    }
                    catch
                    {
                        //ςȒlw肳Ă 0 ɂ
                        iSetPriority = 0;
                    }
                    tbConsole.Text += Cald.SetPriority(iSetPriority).ToString();
                    break;
                case "GetBackGroundMode":
                    tbConsole.Text += Cald.GetBackGroundMode().ToString();
                    break;
                case "SetBackGroundMode":
                    tbConsole.Text += Cald.SetBackGroundMode(!Cald.GetBackGroundMode()).ToString();
                    break;
                case "GetCursorMode":
                    tbConsole.Text += Cald.GetCursorMode().ToString();
                    break;
                case "SetCursorMode":
                    tbConsole.Text += Cald.SetCursorMode(!Cald.GetCursorMode()).ToString();
                    break;

                case "GetFileCount":
                    tbConsole.Text += Cald.GetFileCount(cbCommand.Text).ToString();
                    break;
                case "ConfigDialog":
                    //ʏ͉𓀃[hŐݒʌĂяo
                    uint ConfigDialogSwitch = 1;
                    //Command  Pack ƋLqĂAk[hŐݒʌĂяo
                    if (cbCommand.Text.ToLower().Trim() == "pack") ConfigDialogSwitch = 2;
                    tbConsole.Text += "0x" + Cald.ConfigDialog(this.Handle, Output, ConfigDialogSwitch).ToString("x");
                    if(Output.Length > 0)
                    {
                        tbConsole.Text += " ("+Output+")";
                    }
                    break;
                case "Exec":
                    int iExecRet = Cald.Exec(this.Handle, cbCommand.Text, Output, (uint)Output.Capacity);
                    tbConsole.Text += "0x" + iExecRet.ToString("x");
                    tbConsole.Text += Environment.NewLine;
                    tbConsole.Text += Output;
                    //Exec IŁAo^̃R}hCłΗƂēo^
                    if (iExecRet == 0)
                    {
                        if(cbCommand.Items.IndexOf(cbCommand.Text.Trim()) == -1)
                        {
                            cbCommand.Items.Add(cbCommand.Text.Trim());
                        }

                    }
                    break;
                case "OpenArchive":
                    cbApiOpenArchiveCommon(false);
                    break;
                case "OpenArchive2":
                    cbApiOpenArchiveCommon(true);
                    break;
                case "CloseArchive":
                    if (hArcForOpenArchive != IntPtr.Zero && DllNameForOpenArchive != cbDllName.Text)
                    {
                        tbConsole.Text += DllNameForOpenArchive + "(CloseArchive) sĂB";
                    }
                    else
                    {
                        tbConsole.Text += "0x" + Cald.CloseArchive(hArcForOpenArchive).ToString("x");

                        hArcForOpenArchive = IntPtr.Zero;
                        DllNameForOpenArchive = "";
                        isFindNextEnded = false;

                        if (!apiAllToolStripMenuItem.Checked)
                        {
                            apiDefaultToolStripMenuItem.CheckState = CheckState.Checked;

                            apiOpenArchiveAllToolStripMenuItem.CheckState = CheckState.Unchecked;

                            //OpenArchive ntB^ʊ֐B(OFF)
                            apiOpenArchiveToolStripMenuItemCommon(false);

                            ApiFilter();
                        }
                    }
                    break;
                case "FindFirst":
//                  int iFindFirst = Cald.FindFirst(hArcForOpenArchive, cbCommand.Text, ref Cald.IndividualInfo);
                    int iFindFirst = Cald.FindFirst(hArcForOpenArchive, "*", ref Cald.SubInfo);
                    tbConsole.Text += "0x" + iFindFirst.ToString("x");
                    if (iFindFirst == 0)
                    {
                        PutConsoleByIndividualInfo();
                    }
                    else if (iFindFirst == -1)
                    {
                        isFindNextEnded = true;
                    }
                    break;
                case "FindNext":
                    int iFindNext = Cald.FindNext(hArcForOpenArchive, ref Cald.SubInfo);
                    tbConsole.Text += "0x"+iFindNext.ToString("x");
                    if (iFindNext == 0)
                    {
                        PutConsoleByIndividualInfo();
                    }
                    else if (iFindNext == -1)
                    {
                        isFindNextEnded = true;
                    }
                    break;
                case "GetFileName":
                    int iGetFileName = Cald.GetFileName(hArcForOpenArchive, Output, (uint)Output.Capacity);
                    tbConsole.Text += "0x" + iGetFileName.ToString("x");
                    if (iGetFileName == 0) tbConsole.Text += " (" + Output.ToString() + ")";
                    break;
                case "GetArcFileName":
                    int iGetArcFileName = Cald.GetArcFileName(hArcForOpenArchive, Output, (uint)Output.Capacity);
                    tbConsole.Text += "0x" + iGetArcFileName.ToString("x");
                    if (iGetArcFileName == 0) tbConsole.Text += " (" + Output.ToString() + ")";
                    break;
                case "GetAccessTime":
                    uint uiGetAccessTime = Cald.GetAccessTime(hArcForOpenArchive);
                    DateTime dtGetAccessTime = new DateTime(1970, 1, 1, 0, 0, 0).AddSeconds(uiGetAccessTime); //time_t  DateTime ϊ
                    tbConsole.Text += "0x" + uiGetAccessTime.ToString("x") + " (" + dtGetAccessTime.ToLocalTime() + ")";
                    break;
                case "GetArcCompressedSize":
                    if (isFindNextEnded)
                    {
                        uint uiGetArcCompressedSize = Cald.GetArcCompressedSize(hArcForOpenArchive);
                        tbConsole.Text += "0x"+uiGetArcCompressedSize.ToString("x") + " ("+uiGetArcCompressedSize + ")";
                    }
                    else
                    {
                        tbConsole.Text += DllNameForOpenArchive + msgPleaseFindNextEnded;
                    }
                    break;
                case "GetArcFileSize":
                    uint uiGetArcFileSize = Cald.GetArcFileSize(hArcForOpenArchive);
                    tbConsole.Text += "0x" + uiGetArcFileSize.ToString("x") +" (" + uiGetArcFileSize + ")";
                    break;
                case "GetArcReadSize":
                    uint uiGetArcReadSize = Cald.GetArcReadSize(hArcForOpenArchive);
                    tbConsole.Text += "0x" + uiGetArcReadSize.ToString("x") + " (" + uiGetArcReadSize + ")";
                    break;
                case "GetArcOriginalSize":
                    if (isFindNextEnded)
                    {
                        uint uiGetArcOriginalSize = Cald.GetArcOriginalSize(hArcForOpenArchive);
                        tbConsole.Text += "0x" + uiGetArcOriginalSize.ToString("x") + "("+uiGetArcOriginalSize + ")";
                    }
                    else
                    {
                        tbConsole.Text += DllNameForOpenArchive + msgPleaseFindNextEnded;
                    }
                    break;
                case "GetArcRatio":
                    if (isFindNextEnded)
                    {
                        int iGetArcRatio = Cald.GetArcRatio(hArcForOpenArchive);
                        tbConsole.Text += "0x" + iGetArcRatio.ToString("x") + " (" + iGetArcRatio.ToString() + ")";
                    }
                    else
                    {
                        tbConsole.Text += DllNameForOpenArchive + msgPleaseFindNextEnded;
                    }
                    break;
                case "GetCRC":
                    int iGetCRC = Cald.GetCRC(hArcForOpenArchive);
                    tbConsole.Text += "0x" + iGetCRC.ToString("x");
                    break;
                case "GetCompressedSize":
                    uint uiGetCompressedSize = Cald.GetCompressedSize(hArcForOpenArchive);
                    tbConsole.Text += "0x" + uiGetCompressedSize.ToString("x") + " ("+uiGetCompressedSize + ")";
                    break;
                case "GetCreateTime":
                    uint uiGetCreateTime = Cald.GetCreateTime(hArcForOpenArchive);
                    DateTime dtGetCreateTime = new DateTime(1970, 1, 1, 0, 0, 0).AddSeconds(uiGetCreateTime); //time_t  DateTime ϊ
                    tbConsole.Text += "0x" + uiGetCreateTime.ToString("x") + " (" + dtGetCreateTime.ToLocalTime() + ")";
                    break;
                case "GetOriginalSize":
                    uint uiGetOriginalSize = Cald.GetOriginalSize(hArcForOpenArchive);
                    tbConsole.Text += "0x" + uiGetOriginalSize.ToString("x") + " (" + uiGetOriginalSize + ")";
                    break;
                case "GetWriteTime":
                    uint uiGetWriteTime = Cald.GetWriteTime(hArcForOpenArchive);
                    DateTime dtGetWriteTime = new DateTime(1970, 1, 1, 0, 0, 0).AddSeconds(uiGetWriteTime); //time_t  DateTime ϊ
                    tbConsole.Text += "0x" + uiGetWriteTime.ToString("x") + " (" + dtGetWriteTime.ToLocalTime() + ")";
                    break;
                case "GetArcDate":
                    int iGetArcDate = Cald.GetArcDate(hArcForOpenArchive);
                    DateTime dtGetArcDate = DosDateToDateTime((UInt16)iGetArcDate, 0);
                    tbConsole.Text += "0x" + iGetArcDate.ToString("x") + " (" + dtGetArcDate.Date.ToShortDateString() + ")";
                    break;
                case "GetArcTime":
                    int iGetArcTime = Cald.GetArcTime(hArcForOpenArchive);
                    DateTime dtGetArcTime = DosDateToDateTime(0, (UInt16)iGetArcTime);
                    tbConsole.Text += "0x" + iGetArcTime.ToString("x") + " (" + dtGetArcTime.TimeOfDay.ToString() + ")";
                    break;
                case "GetDate":
                    int iGetDate = Cald.GetDate(hArcForOpenArchive);
                    DateTime dtGetDate = DosDateToDateTime((UInt16)iGetDate, 0);
                    tbConsole.Text += "0x" + iGetDate.ToString("x") + " (" + dtGetDate.Date.ToShortDateString() + ")";
                    break;
                case "GetTime":
                    int iGetTime = Cald.GetTime(hArcForOpenArchive);
                    DateTime dtGetTime = DosDateToDateTime(0, (UInt16)iGetTime);
                    tbConsole.Text += "0x" + iGetTime.ToString("x") + " (" + dtGetTime.TimeOfDay.ToString() + ")";
                    break;
                case "GetRatio":
                    int iGetRatio = Cald.GetRatio(hArcForOpenArchive);
                    tbConsole.Text += "0x" + iGetRatio.ToString("x") + " (" + iGetRatio.ToString() + ")";
                    break;
                case "GetAttribute":
                    int iGetAttribute = Cald.GetAttribute(hArcForOpenArchive);
                    tbConsole.Text += "0x" + iGetAttribute.ToString("x");
                    break;
                case "GetArcOSType":
                    int iGetArcOSType = Cald.GetArcOSType(hArcForOpenArchive);
                    tbConsole.Text += "0x" + iGetArcOSType.ToString("x") + " (" + iGetArcOSType.ToString() +")";
                    break;
                case "GetOSType":
                    int iGetOSType = Cald.GetOSType(hArcForOpenArchive);
                    tbConsole.Text += "0x" + iGetOSType.ToString("x") + " (" + iGetOSType.ToString() +")";
                    break;
                case "IsSFXFile":
                    int iIsSFXFile = Cald.IsSFXFile(hArcForOpenArchive);
                    tbConsole.Text += "0x" + iIsSFXFile.ToString("x") + " (" + iIsSFXFile.ToString() +")";
                    break;
                case "GetMethod":
                    tbConsole.Text += "0x" + Cald.GetMethod(hArcForOpenArchive, Output, (uint)Output.Capacity).ToString("x");
                    if (Output.Length > 0)
                    {
                        tbConsole.Text += " (" + Output + ")";
                    }
                    break;
                case "GetAccessTimeEx":
                    tbConsole.Text += Cald.GetAccessTimeEx(hArcForOpenArchive, ref ForTimeEx).ToString();
                    DateTime dtGetAccessTimeEx = DateTime.FromFileTime(ForTimeEx);
                    tbConsole.Text += " (" + dtGetAccessTimeEx.ToLocalTime() + ")";
                    break;
                case "GetArcAccessTimeEx":
                    tbConsole.Text += Cald.GetArcAccessTimeEx(hArcForOpenArchive, ref ForTimeEx).ToString();
                    DateTime dtGetArcAccessTimeEx = DateTime.FromFileTime(ForTimeEx);
                    tbConsole.Text += " (" + dtGetArcAccessTimeEx.ToLocalTime() + ")";
                    break;
                case "GetArcCreateTimeEx":
                    tbConsole.Text += Cald.GetArcCreateTimeEx(hArcForOpenArchive, ref ForTimeEx).ToString();
                    DateTime dtGetArcCreateTimeEx = DateTime.FromFileTime(ForTimeEx);
                    tbConsole.Text += " (" + dtGetArcCreateTimeEx.ToLocalTime() + ")";
                    break;
                case "GetArcWriteTimeEx":
                    tbConsole.Text += Cald.GetArcWriteTimeEx(hArcForOpenArchive, ref ForTimeEx).ToString();
                    DateTime dtGetArcWriteTimeEx = DateTime.FromFileTime(ForTimeEx);
                    tbConsole.Text += " (" + dtGetArcWriteTimeEx.ToLocalTime() + ")";
                    break;
                case "GetCreateTimeEx":
                    tbConsole.Text += Cald.GetCreateTimeEx(hArcForOpenArchive, ref ForTimeEx).ToString();
                    DateTime dtGetCreateTimeEx = DateTime.FromFileTime(ForTimeEx);
                    tbConsole.Text += " (" + dtGetCreateTimeEx.ToLocalTime() + ")";
                    break;
                case "GetWriteTimeEx":
                    tbConsole.Text += Cald.GetWriteTimeEx(hArcForOpenArchive, ref ForTimeEx).ToString();
                    DateTime dtGetWriteTimeEx = DateTime.FromFileTime(ForTimeEx);
                    tbConsole.Text += " (" + dtGetWriteTimeEx.ToLocalTime() + ")";
                    break;
                case "GetArcCompressedSizeEx":
                    tbConsole.Text += Cald.GetArcCompressedSizeEx(hArcForOpenArchive, ref ForSizeEx).ToString();
                    tbConsole.Text += " : "+ForSizeEx.ToString()+"(0x" + ForSizeEx.ToString("x") + ")";
                    break;
                case "GetArcFileSizeEx":
                    tbConsole.Text += Cald.GetArcFileSizeEx(hArcForOpenArchive, ref ForSizeEx).ToString();
                    tbConsole.Text += " : " + ForSizeEx.ToString() + "(0x" + ForSizeEx.ToString("x") + ")";
                    break;
                case "GetArcOriginalSizeEx":
                    tbConsole.Text += Cald.GetArcOriginalSizeEx(hArcForOpenArchive, ref ForSizeEx).ToString();
                    tbConsole.Text += " : " + ForSizeEx.ToString() + "(0x" + ForSizeEx.ToString("x") + ")";
                    break;
                case "GetArcReadSizeEx":
                    tbConsole.Text += Cald.GetArcReadSizeEx(hArcForOpenArchive, ref ForSizeEx).ToString();
                    tbConsole.Text += " : " + ForSizeEx.ToString() + "(0x" + ForSizeEx.ToString("x") + ")";
                    break;
                case "GetCompressedSizeEx":
                    tbConsole.Text += Cald.GetCompressedSizeEx(hArcForOpenArchive, ref ForSizeEx).ToString();
                    tbConsole.Text += " : " + ForSizeEx.ToString() + "(0x" + ForSizeEx.ToString("x") + ")";
                    break;
                case "GetOriginalSizeEx":
                    tbConsole.Text += Cald.GetOriginalSizeEx(hArcForOpenArchive, ref ForSizeEx).ToString();
                    tbConsole.Text += " : " + ForSizeEx.ToString() + "(0x" + ForSizeEx.ToString("x") + ")";
                    break;
                case "ExtractMem":
                    StringBuilder strExtractMem = new StringBuilder(32*1024);
                    UInt32 TimeExtractMem = 0;
                    UInt16 AttrExtractMem = 0;
                    UInt32 WriteSizeExtractMem = 0;
                    tbConsole.Text += "0x" + Cald.ExtractMem(this.Handle, cbCommand.Text, strExtractMem, (UInt32)strExtractMem.Capacity, ref TimeExtractMem, ref AttrExtractMem, ref WriteSizeExtractMem).ToString("x");
                    DateTime DateTimeExtractMem = new DateTime(1970, 1, 1, 0, 0, 0).AddSeconds(TimeExtractMem);
                    tbConsole.Text += Environment.NewLine + "lpTime :" + DateTimeExtractMem.ToLocalTime();
                    tbConsole.Text += Environment.NewLine + "lpwAttr : 0x" + AttrExtractMem.ToString("x");
                    tbConsole.Text += Environment.NewLine + "lpwWriteSize : 0x" + WriteSizeExtractMem.ToString("x") + " (" + WriteSizeExtractMem.ToString() + ")";
                    tbConsole.Text += Environment.NewLine + "-----" + Environment.NewLine + strExtractMem;
                    break;
                case "CompressMem":
                    UInt32 WriteSizeCompressMem = 0;
                    tbConsole.Text += "0x" + Cald.CompressMem(this.Handle, cbCommand.Text, tbConsole.Text,(UInt32)tbConsole.Text.Length, 0, 0, ref WriteSizeCompressMem).ToString("x");
                    tbConsole.Text += Environment.NewLine + "lpwWriteSize : 0x" + WriteSizeCompressMem.ToString("x") + " (" + WriteSizeCompressMem.ToString() + ")";
                    break;
                default:
                    tbConsole.Text += "Can't run...";
                    break;
            }

            if (!Cald.IsApiCalled())
            {
                if(Cald.GetVersion() ==0)
                    tbConsole.Text += " [DLL o]";
                else
                    tbConsole.Text += " [㗝s]";
            }
            tbConsole.Text += Environment.NewLine;

            //R\[𖖔Ɉړ܂B
            tbConsole.SelectionStart = tbConsole.Text.Length;
            tbConsole.ScrollToCaret();

            if (cbApiName.Text == "Exec")
            {
                //Exec (R}hsn) ̏ꍇ́AAsł悤ɃR}hpeLXg{bNXɐ߂B
                cbCommand.Focus();
            }
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            cbCommand.Text = "";
            tbConsole.Text = "";
        }
        #endregion

        #region hbOAhhbv֘A
        private void cbCommand_DragDrop(object sender, DragEventArgs e)
        {
            string[] files = (string[])e.Data.GetData(DataFormats.FileDrop);
            foreach (string filename in files)
            {
                if (cbCommand.Text.Length > 0)
                    cbCommand.Text += " ";
                
                cbCommand.Text += "\"" + filename + "\"";
            }
        }

        private void cbCommand_DragEnter(object sender, DragEventArgs e)
        {
            //t@C̃hbv^
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                e.Effect = DragDropEffects.Copy;
            }
            else
            {
                e.Effect = DragDropEffects.None;
            }

        }
        #endregion

        #region j[̃NbN֘A
        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void apiDefaultToolStripMenuItem_Click(object sender, EventArgs e)
        {
            apiDefaultToolStripMenuItem.CheckState = CheckState.Checked;
            apiAllToolStripMenuItem.CheckState = CheckState.Unchecked;

            //OpenArchive ntB^ʊ֐B(OFF)
            apiOpenArchiveToolStripMenuItemCommon(false);

            ApiFilter();
        }

        private void apiAllToolStripMenuItem_Click(object sender, EventArgs e)
        {
            apiDefaultToolStripMenuItem.CheckState = CheckState.Unchecked;
            apiAllToolStripMenuItem.CheckState = CheckState.Checked;

            //OpenArchive ntB^ʊ֐B(OFF)
            apiOpenArchiveToolStripMenuItemCommon(false);

            //OpenArchive.All  ON ɂ (tB^ItőSAPIĂяo)
            apiOpenArchiveAllToolStripMenuItem.CheckState = CheckState.Checked; 

            ApiFilter();
        }

        private void apiOpenArchiveAllToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //OpenArchive ntB^ʊ֐B(ON)
            apiOpenArchiveToolStripMenuItemCommon(true);

            //OpenArchive.All  ON ɂ
            apiOpenArchiveAllToolStripMenuItem.CheckState = CheckState.Checked; 

            ApiFilter();
        }

        private void apiOpenArchiveGetArcToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //OpenArchive ntB^ʊ֐B(ON)
            apiOpenArchiveToolStripMenuItemCommon(true);

            //OpenArchive.GetArc  ON ɂ
            apiOpenArchiveGetArcToolStripMenuItem.CheckState = CheckState.Checked;

            ApiFilter();
        }

        private void apiOpenArchiveGetToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //OpenArchive ntB^ʊ֐B(ON)
            apiOpenArchiveToolStripMenuItemCommon(true);

            //OpenArchive.Get  ON ɂ
            apiOpenArchiveGetToolStripMenuItem.CheckState = CheckState.Checked;

            ApiFilter();
        }

        private void apiOpenArchiveSeekToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //OpenArchive ntB^ʊ֐B(ON)
            apiOpenArchiveToolStripMenuItemCommon(true);

            //OpenArchive.Get  ON ɂ
            apiOpenArchiveSeekToolStripMenuItem.CheckState = CheckState.Checked;

            ApiFilter();
        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult drRet = openArchiveFileDialog.ShowDialog();
            if (drRet == DialogResult.OK)
            {
                cbCommand.Text = "\"" + openArchiveFileDialog.FileName + "\"";
            }
        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //ݎgp DLL ޔ
            string CurrentDll = Cald.GetDllName();

            //DLL wꎞACaldBase.dll {̂̃o[W߂
            Cald.SetDllIndex(0);
            string CaldBaseDllVer = String.Format("Ver.{0}.{1:00}", Cald.GetVersion() / 100, Cald.GetVersion() % 100);
            if (Cald.GetSubVersion() != 0) CaldBaseDllVer += String.Format(".{0}.{1:}", Cald.GetSubVersion() / 100, Cald.GetSubVersion() % 100);

            if (Cald.GetVersion() == 0)
            {
                CaldBaseDllVer = " [DLL not found!!]";
            }

            string VersionInfo = this.Text + Environment.NewLine +
                                    "Copyright (C)2006 ardry, Project CaldBase.NET. All rights reserved." + Environment.NewLine + Environment.NewLine +
                                    "This software is running at Microsoft .NET Framework Ver." + Environment.Version.ToString() + Environment.NewLine + 
                                    "Powered by CaldBase.NET (CaldBase.dll) "+ CaldBaseDllVer + Environment.NewLine + Environment.NewLine +
                                    "E-Mail : ardry@users.sorceforge.jp" + Environment.NewLine +
                                    "Web URL : http://caldbase.sourceforge.jp/";
            MessageBox.Show(VersionInfo,this.Text,MessageBoxButtons.OK,MessageBoxIcon.Information);

            //ޔĂ DLL ɖ߂B
            Cald.SetDllName(CurrentDll);
        }
        #endregion

        private void cbCommand_KeyDown(object sender, KeyEventArgs e)
        {
            //Enter L[ɂ Exec {^̃NbNCxg𔭐B
            if (e.KeyCode == Keys.Enter)
            {
                btnExec_Click(sender, e);
            }
        }

    }
}