using System;
using System.Text;
//DLLImportp
using System.Runtime.InteropServices;

namespace Archiver.Cald
{
    public class CaldBase
    {
        //DLL`
        private const string DllName = "CaldBase.dll";
        #region UNLHA32.DLL R̒`
        //by UNLHA32.H
        public const int FNAME_MAX32 = 512;

        //by UNLHA32.H
        [StructLayout(LayoutKind.Sequential)]
        public struct INDIVIDUALINFO
        {
            public UInt32 dwOriginalSize;
            public UInt32 dwCompressedSize;
            public UInt32 dwCRC;
            public UInt32 uFlag;
            public UInt32 uOSType;
            public UInt16 wRatio;
            public UInt16 wDate;
            public UInt16 wTime;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = FNAME_MAX32 + 1)]
            public string szFileName;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 3)]
            public string dummy1;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 8)]
            public string szAttribute;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 8)]
            public string szMode;
        }
        public INDIVIDUALINFO SubInfo;
        #endregion
        #region A[JCo API `
        //UNLHA32.DLL (LHA.DLL ݊)
        [DllImport(DllName, CharSet=CharSet.Ansi)]
        private extern static UInt16 CaldGetVersion();

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static UInt16 CaldGetSubVersion();

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static UInt16 CaldGetCursorInterval();

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetRunning();

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetBackGroundMode();

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetCursorMode();

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldQueryFunctionList(int _iFunction);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldSetPriority(int _nPriority);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldSetCursorMode(bool _CursorMode);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldSetBackGroundMode(bool _bBackGroundMode);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldSetCursorInterval(Int16 _Interval);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int Cald(IntPtr hwnd, string szCmdLine, StringBuilder szOutput, UInt32 dwSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldConfigDialog(IntPtr hwnd, StringBuilder szOptionBuffer, UInt32 iMode);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetMethod(IntPtr _harc, StringBuilder lpBuffer, UInt32 nSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldCheckArchive(string szFileName, int iMode);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetFileCount(string szArcFile);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static IntPtr CaldOpenArchive(IntPtr _hwnd, string szFileName, UInt32 dwMode);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static IntPtr CaldOpenArchive2(IntPtr _hwnd, string szFileName, UInt32 dwMode, string szOption);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldCloseArchive(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldFindFirst(IntPtr _harc, string szWildName, ref INDIVIDUALINFO lpSubInfo);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldFindNext(IntPtr _harc, ref INDIVIDUALINFO lpSubInfo);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetFileName(IntPtr _harc, StringBuilder lpBuffer, UInt32 _nSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetArcFileName(IntPtr _harc, StringBuilder lpBuffer, UInt32 _nSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetAccessTime(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetArcCompressedSize(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetArcFileSize(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetArcOriginalSize(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetCRC(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetCompressedSize(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetCreateTime(IntPtr _harc);
        
        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetOriginalSize(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetWriteTime(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetArcRatio(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetArcReadSize(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetArcDate(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetArcTime(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetDate(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetTime(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetRatio(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetAttribute(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetArcOSType(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetOSType(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldIsSFXFile(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetArcAccessTimeEx(IntPtr _harc, ref Int64 _lpftLastAccessTime);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetArcCreateTimeEx(IntPtr _harc, ref Int64 _lpftCreationTime);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetArcWriteTimeEx(IntPtr _harc, ref Int64 _lpftLastWriteTime);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetAccessTimeEx(IntPtr _harc, ref Int64 _lpftLastAccessTime);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetCreateTimeEx(IntPtr _harc, ref Int64 _lpftCreationTime);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetWriteTimeEx(IntPtr _harc, ref Int64 _lpftLastWriteTime);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetArcCompressedSizeEx(IntPtr _harc, ref Int64 _lpllSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetArcFileSizeEx(IntPtr _harc, ref Int64 _lpllSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetArcOriginalSizeEx(IntPtr _harc, ref Int64 _lpllSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetArcReadSizeEx(IntPtr _harc, ref Int64 _lpllSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetCompressedSizeEx(IntPtr _harc, ref Int64 _lpllSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetOriginalSizeEx(IntPtr _harc, ref Int64 _lpllSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldExtractMem(IntPtr _hwnd, string _szCmdLine, StringBuilder _szBuffer, 
            UInt32 _dwSize, ref UInt32 _lpTime, ref UInt16 _lpwAttr, ref UInt32 lpdwWriteSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldCompressMem(IntPtr _hwnd, string _szCmdLine, string _szBuffer,
            UInt32 _dwSize, UInt32 _lpTime, UInt16 _lpwAttr, ref UInt32 lpdwWriteSize);
        #endregion
        #region CaldBase.dll ƎAPI `
        //CaldBase Ǝ API
        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static void CaldGetDllName(StringBuilder szDllName, UInt16 dwSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldSetDllName(string szDllName);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldSetDllIndex(UInt16 idx);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static void CaldGetExtractCommand(StringBuilder szExtractCommand, UInt32 dwSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldIsApiCalled();
        #endregion

        //RXgN^
        public CaldBase()
        {
            SubInfo = new INDIVIDUALINFO();
        }

        #region UNLHA32.DLL ݊ API (OpenArchive svn) ̎
        public bool CheckArchive(string FileName, int Mode)
        {
            //[ " L菜B
            FileName = FileName.Trim('\"');
            try
            {
                //0:false / 1,2,3,... : true (BGA32.DLL AꕔCM[BOOLlԂDLL̂)
                return (CaldCheckArchive(FileName, Mode) != 0);
            }
            catch
            {
                return false;
            }
        }
        public int ConfigDialog(IntPtr hwnd, StringBuilder szOptionBuffer, UInt32 iMode)
        {
            try
            {

                int iRet = CaldConfigDialog(hwnd, szOptionBuffer, iMode);

                //TAR32.DLL ̈ꕔ DLL  Output ɓĂ镶̉sR[h
                //CrLf ł͂Ȃ̂ŁACrLf ɒuB
                const string TempCrLf = "<br />";
                szOptionBuffer.Replace(Environment.NewLine, TempCrLf);
                szOptionBuffer.Replace("\r", TempCrLf);
                szOptionBuffer.Replace("\n", TempCrLf);
                szOptionBuffer.Replace(TempCrLf, Environment.NewLine);

                return iRet;
            }
            catch
            {
                return -1;
            }
        }
        public int Exec(IntPtr _hwnd, string CommandLine, StringBuilder Output, uint _dwSize)
        {
            try
            {

                int iRet = Cald(_hwnd, CommandLine, Output, _dwSize/*(uint)Output.Capacity*/);

                //TAR32.DLL ̈ꕔ DLL  Output ɓĂ镶̉sR[h
                //CrLf ł͂Ȃ̂ŁACrLf ɒuB
                const string TempCrLf = "<br />";
                Output.Replace(Environment.NewLine, TempCrLf);
                Output.Replace("\r", TempCrLf);
                Output.Replace("\n", TempCrLf);
                Output.Replace(TempCrLf, Environment.NewLine);

                return iRet;
            }
            catch
            {
                return 0;
            }
        }
        public bool GetCursorMode()
        {
            try
            {
                return CaldGetCursorMode();
            }
            catch
            {
                return false;
            }
        }
        public int GetFileCount(string FileName)
        {
            //[ " L菜B
            FileName = FileName.Trim('\"');
            try
            {
                return CaldGetFileCount(FileName);
            }
            catch
            {
                return -1;
            }
        }
        public bool GetBackGroundMode()
        {
            try
            {
                return CaldGetBackGroundMode();
            }
            catch
            {
                return false;
            }
        }
        public int GetCursorInterval()
        {
            try
            {
                return CaldGetCursorInterval();
            }
            catch
            {
                return 0;
            }

        }
        public bool GetRunning()
        {
            try
            {
                return CaldGetRunning();
            }
            catch
            {
                return false;
            }
        }
        public int GetSubVersion()
        {
            try
            {
                return CaldGetSubVersion();
            }
            catch
            {
                return 0;
            }

        }
        public int GetVersion()
        {
            try
            {
                return CaldGetVersion();
            }
            catch
            {
                return 0;
            }

        }
        public bool QueryFunctionList(int Function)
        {
            try
            {
                return CaldQueryFunctionList(Function);
            }
            catch
            {
                return false;
            }
        }
        public bool SetBackGroundMode(bool BackGroundMode)
        {
            try
            {
                return CaldSetBackGroundMode(BackGroundMode);
            }
            catch
            {
                return false;
            }
        }
        public bool SetCursorMode(bool CursorMode)
        {
            try
            {
                return CaldSetCursorMode(CursorMode);
            }
            catch
            {
                return false;
            }
        }
        public bool SetCursorInterval(Int16 Interval)
        {
            try
            {
                return CaldSetCursorInterval(Interval);
            }
            catch
            {
                return false;
            }
        }
        public bool SetPriority(int Priority)
        {
            try
            {
                return CaldSetPriority(Priority);
            }
            catch
            {
                return false;
            }
        }

        public int ExtractMem(IntPtr hwnd, string CommandLine, StringBuilder Buffer,
            UInt32 Size, ref UInt32 Time, ref UInt16 Attr, ref UInt32 WriteSize)
        {
            try
            {
                return CaldExtractMem(hwnd, CommandLine, Buffer, Size, ref Time, ref Attr, ref WriteSize);
            }
            catch
            {
                return -1;
            }
        }

        public int CompressMem(IntPtr hwnd, string CommandLine, string Buffer,
            UInt32 Size, UInt32 Time, UInt16 Attr, ref UInt32 WriteSize)
        {
            try
            {
                return CaldCompressMem(hwnd, CommandLine, Buffer, Size, Time, Attr, ref WriteSize);
            }
            catch
            {
                return -1;
            }
        }
        /*
        private extern static int CaldExtractMem(IntPtr _harc, string _szCmdLine, StringBuilder _szBuffer, Int32 _dwSize, ref Int32 _lpTime, ref UInt16 _lpwAttr, ref Int32 lpdwWriteSize);
        private extern static int CaldCompressMem(IntPtr _harc, string _szCmdLine, string _szBuffer, Int32 _dwSize, Int32 _lpTime, UInt16 _lpwAttr, ref Int32 lpdwWriteSize);
         */


        #endregion
        #region UNLHA32.DLL ݊ API (OpenArchive Kvn) ̎
        public IntPtr OpenArchive(IntPtr hwnd, string FileName, uint Mode)
        {
            //[ " L菜B
            FileName = FileName.Trim('\"');
            try
            {
                return CaldOpenArchive(hwnd, FileName, Mode);
            }
            catch
            {
                return IntPtr.Zero;
            }
        }
        public IntPtr OpenArchive2(IntPtr hwnd, string FileName, uint Mode, string Option)
        {
            //[ " L菜B
            FileName = FileName.Trim('\"');
            try
            {
                return CaldOpenArchive2(hwnd, FileName, Mode, Option);
            }
            catch
            {
                return IntPtr.Zero;
            }
        }
        public int CloseArchive(IntPtr harc)
        {
            try
            {
                return CaldCloseArchive(harc);
            }
            catch
            {
                return 0;
            }
        }
        public int FindFirst(IntPtr harc, string wildname, ref INDIVIDUALINFO subinfo)
        {
            try
            {
                return CaldFindFirst(harc, wildname, ref subinfo);
            }
            catch
            {
                return -1;
            }
        }
        public int FindNext(IntPtr harc, ref INDIVIDUALINFO subinfo)
        {
            try
            {
                return CaldFindNext(harc, ref subinfo);
            }
            catch
            {
                return -1;
            }
        }
        public uint GetAccessTime(IntPtr harc)
        {
            try
            {
                return CaldGetAccessTime(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        public uint GetArcCompressedSize(IntPtr harc)
        {
            try
            {
                return CaldGetArcCompressedSize(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        public int GetArcDate(IntPtr harc)
        {
            try
            {
                return CaldGetArcDate(harc);
            }
            catch
            {
                return -1;
            }
        }
        public int GetArcFileName(IntPtr harc, StringBuilder lpBuffer, uint nSize)
        {
            try
            {
                return CaldGetArcFileName(harc, lpBuffer, nSize);
            }
            catch
            {
                return -1;
            }
        }
        public uint GetArcFileSize(IntPtr harc)
        {
            try
            {
                return CaldGetArcFileSize(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        public uint GetArcOriginalSize(IntPtr harc)
        {
            try
            {
                return CaldGetArcOriginalSize(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        public int GetArcOSType(IntPtr harc)
        {
            try
            {
                return CaldGetArcOSType(harc);
            }
            catch
            {
                return -1;
            }
        }
        public int GetArcRatio(IntPtr harc)
        {
            try
            {
                return CaldGetArcRatio(harc);
            }
            catch
            {
                return -1;
            }
        }
        public uint GetArcReadSize(IntPtr harc)
        {
            try
            {
                return CaldGetArcReadSize(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        public int GetArcTime(IntPtr harc)
        {
            try
            {
                return CaldGetArcTime(harc);
            }
            catch
            {
                return -1;
            }
        }
        public int GetAttribute(IntPtr harc)
        {
            try
            {
                return CaldGetAttribute(harc);
            }
            catch
            {
                return -1;
            }
        }
        public uint GetCompressedSize(IntPtr harc)
        {
            try
            {
                return CaldGetCompressedSize(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        public int GetCRC(IntPtr harc)
        {
            try
            {
                return CaldGetCRC(harc);
            }
            catch
            {
                return -1;
            }
        }
        public uint GetCreateTime(IntPtr harc)
        {
            try
            {
                return CaldGetCreateTime(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        public int GetDate(IntPtr harc)
        {
            try
            {
                return CaldGetDate(harc);
            }
            catch
            {
                return -1;
            }
        }
        public int GetFileName(IntPtr harc, StringBuilder lpBuffer, uint nSize)
        {
            try
            {
                return CaldGetFileName(harc, lpBuffer, nSize);
            }
            catch
            {
                return -1;
            }
        }
        public int GetMethod(IntPtr harc, StringBuilder lpBuffer, UInt32 nSize)
        {
            //
            try
            {
                return CaldGetMethod(harc, lpBuffer, nSize);
            }
            catch
            {
                return 0x8021;
            }
        }
        public uint GetOriginalSize(IntPtr harc)
        {
            try
            {
                return CaldGetOriginalSize(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        public int GetRatio(IntPtr harc)
        {
            try
            {
                return CaldGetRatio(harc);
            }
            catch
            {
                return -1;
            }
        }
        public int GetTime(IntPtr harc)
        {
            try
            {
                return CaldGetTime(harc);
            }
            catch
            {
                return -1;
            }
        }
        public uint GetWriteTime(IntPtr harc)
        {
            try
            {
                return CaldGetWriteTime(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        public bool GetAccessTimeEx(IntPtr harc, ref Int64 TimeEx)
        {
            try
            {
                return CaldGetAccessTimeEx(harc, ref TimeEx);
            }
            catch
            {
                return false;
            }
        }
        public bool GetArcAccessTimeEx(IntPtr harc, ref Int64 TimeEx)
        {
            try
            {
                return CaldGetAccessTimeEx(harc, ref TimeEx);
            }
            catch
            {
                return false;
            }
        }
        public bool GetArcCreateTimeEx(IntPtr harc, ref Int64 TimeEx)
        {
            try
            {
                return CaldGetArcCreateTimeEx(harc, ref TimeEx);
            }
            catch
            {
                return false;
            }
        }
        public bool GetArcWriteTimeEx(IntPtr harc, ref Int64 TimeEx)
        {
            try
            {
                return CaldGetArcWriteTimeEx(harc, ref TimeEx);
            }
            catch
            {
                return false;
            }
        }
        public bool GetCreateTimeEx(IntPtr harc, ref Int64 TimeEx)
        {
            try
            {
                return CaldGetCreateTimeEx(harc, ref TimeEx);
            }
            catch
            {
                return false;
            }
        }
        public bool GetWriteTimeEx(IntPtr harc, ref Int64 TimeEx)
        {
            try
            {
                return CaldGetWriteTimeEx(harc, ref TimeEx);
            }
            catch
            {
                return false;
            }
        }
        public bool GetArcCompressedSizeEx(IntPtr harc, ref Int64 Size)
        {
            try
            {
                return CaldGetArcCompressedSizeEx(harc, ref Size);
            }
            catch
            {
                return false;
            }
        }
        public bool GetArcFileSizeEx(IntPtr harc, ref Int64 Size)
        {
            try
            {
                return CaldGetArcFileSizeEx(harc, ref Size);
            }
            catch
            {
                return false;
            }
        }
        public bool GetArcOriginalSizeEx(IntPtr harc, ref Int64 Size)
        {
            try
            {
                return CaldGetArcOriginalSizeEx(harc, ref Size);
            }
            catch
            {
                return false;
            }
        }
        public bool GetArcReadSizeEx(IntPtr harc, ref Int64 Size)
        {
            try
            {
                return CaldGetArcReadSizeEx(harc, ref Size);
            }
            catch
            {
                return false;
            }
        }
        public bool GetCompressedSizeEx(IntPtr harc, ref Int64 Size)
        {
            try
            {
                return CaldGetCompressedSizeEx(harc, ref Size);
            }
            catch
            {
                return false;
            }
        }
        public bool GetOriginalSizeEx(IntPtr harc, ref Int64 Size)
        {
            try
            {
                return CaldGetOriginalSizeEx(harc, ref Size);
            }
            catch
            {
                return false;
            }
        }
        public int GetOSType(IntPtr harc)
        {
            try
            {
                return CaldGetOSType(harc);
            }
            catch
            {
                return -1;
            }
        }
        public int IsSFXFile(IntPtr harc)
        {
            try
            {
                return CaldIsSFXFile(harc);
            }
            catch
            {
                return -1;
            }
        }
        #endregion
        #region CaldBase.dll Ǝ API ̎
        public void GetExtractCommand(StringBuilder ExtractCommand)
        {
            try
            {
                CaldGetExtractCommand(ExtractCommand, (uint)ExtractCommand.Capacity);
            }
            catch
            {
            }
        }
        public string GetDllName()
        {
            try
            {
                StringBuilder strDllName = new StringBuilder();
                CaldGetDllName(strDllName, 256);
                return strDllName.ToString();
            }
            catch
            {
                return "";
            }
        }
        public int SetDllName(string DllName)
        {
            try
            {
                return CaldSetDllName(DllName);
            }
            catch
            {
                return 0;
            }
        }
        public bool SetDllIndex(int idx)
        {
            try
            {
                return CaldSetDllIndex((UInt16)idx);
            }
            catch
            {
                return false;
            }
        }

        public bool IsApiCalled()
        {
            try
            {
                return CaldIsApiCalled();
            }
            catch
            {
                return false;
            }
        }
        #endregion
    }
}
