/*
 * 쐬: 2005/06/07
 */
package jp.sourceforge.cafebabe.util;

import java.io.PrintStream;

/**
 * ̏o̓Xg[ɏo͂܂B
 * @author jin_k
 */
public class MultiplePrintStream extends PrintStream {

	/** o͑Ώ */
	private PrintStream _out2;

	/**
	 * RXgN^
	 * @param p C̏o̓Xg[
	 * @param out2 ̑̏o̓Xg[
	 */
	public MultiplePrintStream(PrintStream p, PrintStream out2) {
		super(p);
		_out2 = out2;
	}

	/* ( Javadoc)
	 * @see java.io.OutputStream#write(byte[], int, int)
	 */
	public void write(byte[] buf, int off, int len) {
		super.write(buf, off, len);
		if (null != _out2) {
			_out2.write(buf, off, len);
		}
	}

	/* ( Javadoc)
	 * @see java.io.OutputStream#write(int)
	 */
	public void write(int b) {
		super.write(b);
		if (null != _out2) {
			_out2.write(b);
		}
	}

	/* ( Javadoc)
	 * @see java.io.OutputStream#close()
	 */
	public void close() {
		super.close();
		if (null != _out2) {
			_out2.close();
		}
	}

	/* ( Javadoc)
	 * @see java.io.OutputStream#flush()
	 */
	public void flush() {
		super.flush();
		if (null != _out2) {
			_out2.flush();
		}
	}

}
