/*
 * 쐬: 2005/05/10
 */
package jp.sourceforge.cafebabe.system;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import jp.sourceforge.cafebabe.framework.Command;
import jp.sourceforge.cafebabe.framework.CommandException;
import jp.sourceforge.cafebabe.framework.CommandFatalException;
import jp.sourceforge.cafebabe.framework.CommandManager;
import jp.sourceforge.cafebabe.framework.CommandSet;
import jp.sourceforge.cafebabe.framework.CommandWrapper;
import jp.sourceforge.cafebabe.framework.InputManager;
import jp.sourceforge.cafebabe.framework.OutputManager;
import jp.sourceforge.cafebabe.impl.RootCommandSet;

/**
 * VXe}l[WłB <BR>
 * ϐyъe}l[WǗ܂B
 * @author jin_k
 */
public class SystemManager implements OutputManager {
	/**
	 * NvpeB̃L[`łB
	 * @author jin_k
	 */
	public static interface BootDefine {
		/** AX^XNɃ}b`Ȃ`܂B */
		public static final String NOT_MATCH_ASTERISK = "cafebabe.forward.notmatchasterisk";
	}

	/** [g̃R}hZbgӖ܂B */
	public static final String ROOT_SET = "root";

	/** IӖ܂B */
	public static final String EXIT = "exit";

	/** AvP[VłB */
	private final String _appName;

	/** R\[͂ꂽR}hi[܂B */
	private CommandQueue _commandQueue;

	/** R}h}l[WłB */
	private CommandManager _commandManager;

	/** ̓}l[WłB */
	private InputManager _inputManager;

	/** o̓}l[WłB */
	private OutputManager _outputManager;

	/** [g̃R}hZbgłB */
	private RootCommandSet _root;

	/** ϐłB */
	private final Map _env;

	/** ebpłBB */
	private CommandWrapper _commandWrapper;

	/** Vbg_EIĂ邩ǂ܂B */
	private boolean _isShotdowned;

	/**
	 * RXgN^B
	 * @param appName AvP[V
	 */
	SystemManager(String appName) {
		_appName = appName;
		_env = new HashMap();
	}

	/**
	 * [g̃R}hZbgo^܂B
	 * @param root [g̃R}hZbg
	 */
	void setRootCommandSet(RootCommandSet root) {
		_root = root;
	}

	/**
	 * [g̃R}hZbg擾܂B
	 * @return [g̃R}hZbg
	 */
	public RootCommandSet getRootCommandSet() {
		return _root;
	}

	/**
	 * O[oR}hZbg擾܂B
	 * @return O[õR}hZbg
	 */
	public CommandSet getGlobal() {
		return (CommandSet) _root.getCommand(RootCommandSet.GLOBAL);
	}

	/**
	 * @return _commandQueue ߂܂B
	 */
	public CommandQueue getCommandQueue() {
		return _commandQueue;
	}

	/**
	 * @param queue _commandQueue ݒB
	 */
	void setCommandQueue(CommandQueue queue) {
		_commandQueue = queue;
	}

	/**
	 * R}h}l[Wݒ肵܂B
	 * @param cm R}h}l[W
	 */
	void setCommandManager(CommandManager cm) {
		_commandManager = cm;
	}

	/**
	 * R}h}l[W擾܂B
	 * @return R}h}l[W
	 */
	public CommandManager getCommandManager() {
		return _commandManager;
	}

	/**
	 * ̓}l[W擾܂B
	 * @return ̓}l[W
	 */
	public InputManager getInputManager() {
		return _inputManager;
	}

	/**
	 * ̓}l[Wݒ肵܂B
	 * @param manager ̓}l[W
	 */
	void setInputManager(InputManager manager) {
		_inputManager = manager;
	}

	/**
	 * ϐݒ肵܂B
	 * @param key L[
	 * @param value l
	 */
	public void setEnv(String key, Serializable value) {
		_env.put(key, value);
	}

	/**
	 * ϐ擾܂B
	 * @param key L[
	 * @return L[ɕRtꂽl
	 */
	public Object getEnv(String key) {
		return _env.get(key);
	}

	/**
	 * ϐ̃L[̃ZbgԂ܂B
	 * @return ϐ̃L[̃Zbg
	 */
	public Set getEnvKeySet() {
		return _env.keySet();
	}

	/**
	 * ͓e擾܂B
	 * @return [U͂̓e
	 */
	public String getInput() {
		return getInput(_appName);
	}

	/**
	 * ͓e擾܂B
	 * @param msg [U͂𑣂ۂɕ\郁bZ[W
	 * @return [U
	 */
	public String getInput(String msg) {
		return getInput(msg, false);
	}

	/**
	 * ͓e擾܂B
	 * @param ignoreEmptyString 󕶎𖳎邩ǂ
	 * @return [U
	 */
	public String getInput(boolean ignoreEmptyString) {
		return getInput(_appName, ignoreEmptyString);
	}

	/**
	 * ͓e擾܂B
	 * @param msg [U͂𑣂ۂɕ\郁bZ[W
	 * @param ignoreEmptyString 󕶎𖳎邩ǂ
	 * @return [U
	 */
	public String getInput(String msg, boolean ignoreEmptyString) {
		return _commandManager.getInput(msg, ignoreEmptyString);
	}

	/**
	 * o̓}l[Wݒ肵܂B
	 * @param outputManager o̓}l[W
	 */
	void setOutputManager(OutputManager outputManager) {
		_outputManager = outputManager;
	}

	/**
	 * [U͓e擾܂B
	 * R}h-`Ƀp[XA}NWJs܂B
	 * @return [U͂̓e
	 */
	public String[] getCommand() {
		return getCommand(_appName);
	}

	/**
	 * [U͓e擾܂B
	 * R}h-`Ƀp[XA}NWJs܂B
	 * @param msg [U͂𑣂ۂɕ\郁bZ[W
	 * @return [U
	 */
	public String[] getCommand(String msg) {
		return getCommand(msg, false);
	}

	/**
	 * [U͓e擾܂B
	 * R}h-`Ƀp[XA}NWJs܂B
	 * @param ignoreEmptyString 󕶎𖳎邩ǂ
	 * @return [U
	 */
	public String[] getCommand(boolean ignoreEmptyString) {
		return getCommand(_appName, ignoreEmptyString);
	}

	/**
	 * [U͓e擾܂B
	 * R}h-`Ƀp[XA}NWJs܂B
	 * @param msg [U͂𑣂ۂɕ\郁bZ[W
	 * @param ignoreEmptyString 󕶎𖳎邩ǂ
	 * @return [U
	 */
	public String[] getCommand(String msg, boolean ignoreEmptyString) {
		return _commandManager.getCommand(msg, ignoreEmptyString);
	}

	/**
	 * o̓}l[W擾܂B
	 * @return o̓}l[W
	 */
	public OutputManager getOutputManager() {
		return _outputManager;
	}

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.OutputManager#print(java.lang.String)
	 */
	public void print(String msg) {
		_outputManager.print(msg);
	}

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.OutputManager#print(int, int, java.lang.String)
	 */
	public void print(int line, int column, String msg) {
		_outputManager.print(line, column, msg);
	}

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.OutputManager#println(java.lang.String)
	 */
	public void println(String msg) {
		_outputManager.println(msg);
	}

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.OutputManager#println(int, int, java.lang.String)
	 */
	public void println(int line, int column, String msg) {
		_outputManager.println(line, column, msg);
	}

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.OutputManager#errPrint(java.lang.String)
	 */
	public void errPrint(String msg) {
		_outputManager.print(msg);
	}

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.OutputManager#errPrintln(java.lang.String)
	 */
	public void errPrintln(String msg) {
		_outputManager.println(msg);
	}

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.OutputManager#clear()
	 */
	public void clear() {
		_outputManager.clear();
	}

	/**
	 * R}h̐ebp`܂B
	 * @param parent R}hpX
	 */
	public void setWrapper(CommandWrapper parent) {
		_commandWrapper = parent;
	}

	/**
	 * R}h̐ebp폜܂B
	 */
	public void removeWrapper() {
		_commandWrapper = null;
	}

	/**
	 * ĂяõR}hZbg擾܂B
	 * @return ĂяõR}hZbg
	 */
	public CommandWrapper getWrapper() {
		return _commandWrapper;
	}

	/**
	 * Jn܂B
	 * @throws CommandFatalException vIȗOꍇ
	 * @throws CommandException Oꍇ
	 */
	protected void start() throws CommandFatalException, CommandException {
		String ret = null;
		do {
			_root.execute(this, new String[] { ROOT_SET });
		} while (null != ret && !ret.equals(SystemManager.EXIT)
				&& !ret.equals(Command.FATAL));

	}

	/**
	 * IɌĂ΂܂B <BR>
	 * Ӑ}IɌĂ΂ꍇyуVbg_EtbNŌĂ΂ꍇ܂B
	 */
	public void shutdown() {
		if (!_isShotdowned) {
			_isShotdowned = true;
		}
	}

}