package jp.sourceforge.cafebabe.system;

/*
 * 쐬: 2004/12/09
 */
import java.util.LinkedList;

/**
 * R}hi[L[łB
 * @author jin_k
 */
public class CommandQueue {
	/** VXe}l[WłB */
	private final SystemManager _manager;

	/** R}hL[{̂łB */
	private final LinkedList _queue;

	/** [U͂ꍇɃubN邩ǂłB */
	private boolean _block;

	/**
	 * constructor
	 * @param manager VXe}l[W
	 */
	public CommandQueue(SystemManager manager) {
		this(manager, true);
	}

	/**
	 * constructor
	 * @param manager VXe}l[W
	 * @param block [U͂ꍇɃubN邩ǂ
	 */
	public CommandQueue(SystemManager manager, boolean block) {
		_manager = manager;
		_queue = new LinkedList();
		_block = block;
	}

	/**
	 * L[ɗvfǉ܂B
	 * @param command R}h
	 */
	public void enqueue(String command) {
		synchronized (this._queue) {
			this._queue.addLast(command);
			this._queue.notify();
		} //end syn _queue
	}

	/**
	 * L[vf擾܂B
	 * @param msg [U͂𑣂ۂɕ\郁bZ[W
	 * @param ignoreEmptyString 󕶎𖳎邩ǂ
	 * @return R}h
	 */
	public String dequeue(String msg, boolean ignoreEmptyString) {
		synchronized (this._queue) {
			while (true) {
				if (0 < this._queue.size()) {
					String ret = (String) this._queue.removeFirst();
					if (ignoreEmptyString && ret.equals("")) {
						continue;
					} else {
						return ret;
					}
				} else if (_block) {
					try {
						if (null != msg) {
							_manager.println("");
							_manager.print(msg);
							_manager.print("> ");
						} else {
							//doNothing
						}
						this._queue.wait();
					} catch (InterruptedException ie) {
						//ignore
					}
				} else {
					//ubNȂꍇnull
					return null;
				}
			} //end while
		} //end syn _queue
	}
}