/*
 * 쐬: 2005/05/25
 */
package jp.sourceforge.cafebabe.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import jp.sourceforge.cafebabe.framework.CommandManager;
import jp.sourceforge.cafebabe.impl.STDInputManager;
import jp.sourceforge.cafebabe.impl.STDOutputManager;
import jp.sourceforge.cafebabe.util.IOUtil;

/**
 * ConsoleApplicationFrameworkExample "Babe" ̃CNXłB
 * @author jin_k
 */
public class CAFEBabe extends Thread {
	/** AvP[VłB */
	private static final String APP_NAME = "cafebabe";

	/** [g̃fBNg\܂B */
	public static final String DIR_ROOT = "cafebabe.directory.root";

	/** gfBNgłB */
	public static final String EXT_DIR = "/lib/ext/";

	/** conffBNgłB */
	public static final String CONF_DIR = "/conf";

	/** OfBNgłB */
	public static final String DIR_LOGS = "cafebabe.directory.logs";

	/** }Nt@CłB */
	private static final String MACRO_FILE = "conf/macro.properties";

	/** AvP[ṼGCAXłB */
	public static final String ALIAS_APPS = "alias.apps.";

	/** NAvP[VłB */
	private final String _appName;

	/** VXe}l[WłB */
	private SystemManager _sm;

	/**
	 * RXgN^BNX[_w肷Kv܂B
	 * @param cl NX[_łB
	 * @param appName AvP[V
	 */
	public CAFEBabe(ClassLoader cl, String appName) {
		_appName = appName;
		setContextClassLoader(cl);
	}

	/**
	 * ܂B
	 * @throws Exception o͗OAXMLp[XO
	 */
	public void init() throws Exception {
		_sm = new SystemManager(_appName);
		_sm.setCommandQueue(new CommandQueue(_sm));
		_sm.setCommandManager(new CommandManager(_sm.getCommandQueue()));
		_sm.setInputManager(new STDInputManager(_sm.getCommandQueue()));
		_sm.setOutputManager(new STDOutputManager());

		//\z
		//ŏɃftHgp
		_sm.setRootCommandSet(BabeBuilder.createBabe(_sm, APP_NAME));
		if (!_appName.equals(APP_NAME)) {
			//NAvP[Vɉݒǉ
			BabeBuilder.createBabe(_sm, _appName, _sm.getRootCommandSet());
		}

		//}Nt@C̓ǂݍ
		InputStream in = null;
		BufferedReader br = null;
		try {
			in = getContextClassLoader().getResourceAsStream(MACRO_FILE);
			if (null != in) {
				br = new BufferedReader(new InputStreamReader(in));
				String buff = null;
				CommandManager cm = _sm.getCommandManager();
				while (null != (buff = br.readLine())) {
					int eqPos = buff.indexOf('=');
					if (-1 != eqPos) {
						String[] macro = { buff.substring(0, eqPos),
								buff.substring(eqPos + 1) };
						cm.addMacro(macro[0].trim(), macro[1].trim());
					} else {
						//illegal def. ignore
					}
				} //end while
			} else {
				//skip
			}
		} catch (IOException ioe) {
			//ignore
		} finally {
			IOUtil.close(in);
			IOUtil.close(br);
		}
		//Vbg_EtbN
		final SystemManager sm = _sm;
		Runtime.getRuntime().addShutdownHook(new Thread() {
			public void run() {
				sm.shutdown();
			}
		});
	}

	public void run() {
		try {
			_sm.println("\n\n##");
			_sm.println("## Welcome to \"CAFE Babe\"");
			_sm.println("##");
			_sm.println("");
			_sm.start();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			_sm.println("\n##");
			_sm.println("## Shutdown CAFE Babe... bye");
			_sm.println("##");
		}
	}
}
