/*
 * 쐬: 2005/06/08
 */
package jp.sourceforge.cafebabe.impl;

import jp.sourceforge.cafebabe.framework.OutputManager;

/**
 * @author jin_k
 */
public class STDOutputManager implements OutputManager {

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.OutputManager#print(java.lang.String)
	 */
	public void print(String msg) {
		System.out.print(msg);
	}

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.OutputManager#print(int, int, java.lang.String)
	 */
	public void print(int line, int column, String msg) {
		System.out.print(msg);
	}

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.OutputManager#println(java.lang.String)
	 */
	public void println(String msg) {
		System.out.println(msg);
	}

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.OutputManager#println(int, int, java.lang.String)
	 */
	public void println(int line, int column, String msg) {
		System.out.println(msg);
	}

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.OutputManager#errPrint(java.lang.String)
	 */
	public void errPrint(String msg) {
		System.err.print(msg);
	}

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.OutputManager#errPrintln(java.lang.String)
	 */
	public void errPrintln(String msg) {
		System.err.println(msg);
	}

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.OutputManager#clear()
	 */
	public void clear() {
		throw new UnsupportedOperationException(
				"method \"clear\" is not implement.");
	}

}
