/*
 * 쐬: 2004/12/09
 */
package jp.sourceforge.cafebabe.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import jp.sourceforge.cafebabe.framework.InputManager;
import jp.sourceforge.cafebabe.system.CommandQueue;

/**
 * R\[̓͂擾܂B
 * @author jin_k
 */
public final class STDInputManager extends InputManager implements Runnable {
	/**
	 * constructor
	 * @param queue ̓L[
	 */
	public STDInputManager(CommandQueue queue) {
		super(queue);
		Thread t = new Thread(this);
		t.setDaemon(true);
		t.start();
	}

	/**
	 * run
	 * @see Runnable
	 */
	public void run() {
		try {
			BufferedReader reader = new BufferedReader(new InputStreamReader(
					System.in));
			String buff = null;
			while (null != (buff = reader.readLine())) {
				addCommand(buff.trim());
			} //end while
		} catch (IOException ioe) {
			ioe.printStackTrace();
		} finally {
			addCommand("exit");
		}
	}
}