/*
 * 쐬: 2005/06/01
 */
package jp.sourceforge.cafebabe.framework;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import jp.sourceforge.cafebabe.system.SystemManager;

/**
 * R}h̃bp[łB <BR>
 * VXeł́ÃC^tF[Xɑ삵܂B
 * @author jin_k
 */
public abstract class CommandWrapper implements Command {
	/** DEBUG */
	private static final boolean DEBUG = false;

	/** ChJ[hłB */
	protected static final String ASTERISK = "*";

	/** AX^XNɃ}b`Ȃ */
	private static final String[] NOT_MATCH_ASTERISK = System.getProperty(
			SystemManager.BootDefine.NOT_MATCH_ASTERISK).split(",");

	/** ߂Jڃ}bvłB */
	private final Map _forwards;

	/** R}hłB */
	private String _name;

	/** eR}hZbgłB */
	private CommandSet _parent;

	/** VXe}l[WłB */
	private SystemManager _manager;

	/**
	 * RXgN^
	 */
	public CommandWrapper() {
		_forwards = new HashMap();
	}

	/**
	 * R}hݒ肵܂B
	 * @param name R}h
	 */
	public void setName(String name) {
		_name = name;
	}

	/**
	 * R}h擾܂B <BR>
	 * @return R}h
	 */
	public String getName() {
		return _name;
	}

	/**
	 * ̃R}hi[ĂR}hZbgݒ肵܂B
	 * @param parent eR}hZbg
	 */
	public void setParent(CommandSet parent) {
		_parent = parent;
	}

	/**
	 * ̃R}hi[ĂR}hZbg擾܂B
	 * @return eR}hZbg
	 */
	public CommandSet getParent() {
		return _parent;
	}

	/**
	 * VXe}l[Wݒ肵܂B
	 * @param manager VXe}l[W
	 */
	public void setSystemManager(SystemManager manager) {
		_manager = manager;
	}

	/**
	 * VXe}l[W擾܂B
	 * @return VXe}l[W
	 */
	public SystemManager getSystemManager() {
		return _manager;
	}

	/**
	 * ߂Jڂ`܂B
	 * @param key L[
	 * @param value l
	 */
	public void setForward(String key, String value) {
		if (DEBUG)
				getSystemManager().errPrintln(
						"# set forward(" + getName() + ") : " + key + " = "
								+ value);
		_forwards.put(key, value);
	}

	/**
	 * ߂Jڂ擾܂B
	 * @param key L[
	 * @return l
	 */
	public String getForward(String key) {
		return (String) _forwards.get(key);
	}

	/**
	 * forward݂邩mF܂B
	 * @param name forward
	 * @return ݂邩
	 */
	public boolean containsForward(String name) {
		return _forwards.containsKey(name);
	}

	/**
	 * o^Ăforward̖ÖꗗԂ܂B
	 * @return forward̈ꗗ
	 */
	public Set forwardKeySet() {
		return _forwards.keySet();
	}

	/*
	 *  ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.Command#execute(jp.sourceforge.cafebabe.system.SystemManager, java.lang.String[])
	 */
	public String execute(SystemManager manager, String[] args)
			throws CommandFatalException, CommandException {
		try {
			manager.setWrapper(this);
			return convertForward(manager.getGlobal(), executeImpl(manager,
					args));
		} finally {
			manager.removeWrapper();
		}
	}

	/**
	 * execute܂B
	 * @param manager VXe}l[W
	 * @param args 
	 * @return 
	 * @throws CommandFatalException vIO
	 * @throws CommandException O
	 */
	public abstract String executeImpl(SystemManager manager, String[] args)
			throws CommandFatalException, CommandException;

	/**
	 * ߂lforwardփRo[g܂B <BR>
	 * D揇ʂ͈ȉ̒ʂB <code>
	 * 		 1) [J̈v
	 * 		 2) O[öv
	 * 		 3) [J* (O)
	 * 		 4) O[o* (O)
	 * 		 5) ǂȂ烌X|X̂܂
	 * </code>
	 * @param global O[oR}hZbg
	 * @param ret X|X
	 * @return u
	 */
	private String convertForward(CommandSet global, String ret) {
		if (DEBUG) getSystemManager().errPrintln("return : " + ret);
		//̑Jڐ
		if (null == ret) {
			//null̏ꍇ͗L킳I
			return null;
		} else if (containsForward(ret)) {
			if (DEBUG)
					getSystemManager().errPrintln(
							"forward : " + getForward(ret));
			//[Jv
			return getForward(ret);
		} else if (null != global && global.containsForward(ret)) {
			if (DEBUG)
					getSystemManager().errPrintln(
							"forward : " + global.getForward(ret));
			//O[ov
			return global.getForward(ret);
		} else if (matchAster(ret) && containsForward(ASTERISK)) {
			if (DEBUG)
					getSystemManager().errPrintln(
							"forward : " + getForward(ASTERISK));
			//[J*
			return getForward(ASTERISK);
		} else if (null != global && matchAster(ret)
				&& global.containsForward(ASTERISK)) {
			if (DEBUG)
					getSystemManager().errPrintln(
							"forward : " + global.getForward(ASTERISK));
			//O[o*
			return global.getForward(ASTERISK);
		} else {
			if (DEBUG) getSystemManager().errPrintln("forward : not match");
			//ChJ[h炻̂܂ܒʂB
			return ret;
		}
	}

	/**
	 * w肳ꂽ"*"Ƃ̈vĂ邩ׂ܂B
	 * @param str ׂ镶
	 * @return Ă邩
	 */
	protected boolean matchAster(String str) {
		for (int i = 0; i < NOT_MATCH_ASTERISK.length; ++i) {
			if (str.equals(NOT_MATCH_ASTERISK[i])) {
				return false;
			}
		}
		return true;
	}
}