/*
 * 쐬: 2005/01/21
 */
package jp.sourceforge.cafebabe.framework;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import jp.sourceforge.cafebabe.system.SystemManager;

/**
 * R}h̊_`܂B
 * @author jin_k
 */
public abstract class CommandSet extends CommandWrapper {
	/** g\܂B */
	public static final String THIS = "this";

	/** [U͂ɂĕ򂷂邱Ƃ\܂B */
	public static final String INPUT = "input";

	/** w肳ꂽR}ho^ĂȂƂ܂B */
	public static final String COMMAND_NOT_FOUND = "commandnotfound";

	/** R}h}bvłB */
	private final Map _commands;

	/**
	 * RXgN^
	 */
	protected CommandSet() {
		_commands = new HashMap();
	}

	/**
	 * R}hݒ肵܂B
	 * @param command R}h
	 */
	public final void setCommand(CommandWrapper command) {
		_commands.put(command.getName(), command);
	}

	/**
	 * R}h擾܂B
	 * @param name
	 * @return R}h
	 */
	public final CommandWrapper getCommand(String name) {
		return (CommandWrapper) _commands.get(name);
	}

	/**
	 * R}hݒ肳Ă邩mF܂B
	 * @param name mFR}h
	 * @return R}hݒ肳Ă邩
	 */
	public boolean containsCommand(String name) {
		return _commands.containsKey(name);
	}

	/**
	 * o^ĂR}h̖ÖꗗԂ܂B
	 * @return R}ḧꗗ
	 */
	public Set commandKeySet() {
		return _commands.keySet();
	}

	/**
	 * wR}hN܂B
	 * @param manager VXe}l[W
	 * @param args 
	 * @return 
	 * @throws CommandFatalException vIȗOꍇ
	 * @throws CommandException Oꍇ
	 */
	public final String executeImpl(SystemManager manager, String[] args)
			throws CommandFatalException, CommandException {
		//Ăяo̖߂l
		String ret = null;
		//̌ĂяoŎgp
		String[] next = args;

		//ŏłR}h̊Ԃ̓[v
		do {
			if (next[0].equals(getName()) || next[0].equals(THIS)) {
				//g̃vZXo^Ă邩ǂ
				if (containsCommand(THIS)) {
					//o^ĂĂяo
					next[0] = THIS;
				} else if (containsCommand(getName())) {
					//o^ĂĂяo
					next[0] = getName();
				} else {
					//[U͂󂯓
					next = manager.getCommand();
				}
			} else {
				//̂܂܎s
			}

			//Ăяo
			ret = call(manager, next);

			if (null == ret) {
				//null̏ꍇɂ̓VXeVbg_E
				return null;
			} else if (next[0].equals(INPUT)) {
				next = manager.getCommand();
			} else if (ret.equals(COMMAND_NOT_FOUND)) {
				//Ȃ
				return next[0];
			} else {
				//݂R}hԂĂԂ̓[v
				next = new String[] { ret };
			}
		} while (true);
	}

	/**
	 * R}hZbg̃R}hs܂B
	 * @param manager VXe}l[W
	 * @param args 
	 * @return 
	 * @throws CommandFatalException vIȗOꍇ
	 * @throws CommandException Oꍇ
	 */
	public abstract String call(SystemManager manager, String[] args)
			throws CommandFatalException, CommandException;

	/*
	 *  ( Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer ret = new StringBuffer();
		ret.append(getName()).append(" {\n");
		for (Iterator it = _commands.keySet().iterator(); it.hasNext();) {
			Object key = it.next();
			ret.append("\t").append(key).append(" = ").append(
					_commands.get(key)).append("\n");
		}
		ret.append("}");
		return ret.toString();
	}

}