/*
 * 쐬: 2005/06/12
 */
package jp.sourceforge.cafebabe.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import jp.sourceforge.cafebabe.system.CommandQueue;

/**
 * @author jin_k
 */
public class CommandManager {
	/** R}hL[łB */
	private final CommandQueue _queue;

	/**  */
	private final LinkedList _subQueue;

	/** }NłB */
	private final Map _macro;

	/**
	 * RXgN^
	 * @param queue ̓L[
	 */
	public CommandManager(CommandQueue queue) {
		_queue = queue;
		_subQueue = new LinkedList();
		_macro = new HashMap();
	}

	/**
	 * [U͂̂܂܎擾܂B
	 * @param msg [U͂𑣂ꍇɕ\郁bZ[W
	 * @param ignoreEmptyString 󕶎𖳎邩ǂ
	 * @return R}hƈ̔z
	 */
	public String getInput(String msg, boolean ignoreEmptyString) {
		return _queue.dequeue(msg, ignoreEmptyString);
	}

	/**
	 * R}hz擾܂B
	 * p[Xyу}NWJs܂B
	 * @param msg [U͂𑣂ꍇɕ\郁bZ[W
	 * @param ignoreEmptyString 󕶎𖳎邩ǂ
	 * @return R}hƈ̔z
	 */
	public String[] getCommand(String msg, boolean ignoreEmptyString) {
		if (0 < _subQueue.size()) {
			return (String[]) _subQueue.removeFirst();
		} else {
			parse(_queue.dequeue(msg, ignoreEmptyString));
			return getCommand(msg, ignoreEmptyString);
		}
	}

	/**
	 * p[X܂B
	 * @param command R}h
	 */
	private void parse(String command) {
		String[] commandArray = split(command, ';');
		for (int i = 0; i < commandArray.length; ++i) {
			String[] coms = split(commandArray[i], ' ');
			if (coms[0].startsWith("@")) {
				String com = parseMacro(getMacro(coms[i].trim()), coms);
				if (null != com) {
					parse(com);
					return;
				} else {
					//do addLast
				}
			}
			_subQueue.addLast(coms);
		} //end for
	}

	/**
	 * p[X܂B
	 * @param command R}h
	 * @param delimiter f~^
	 * @return p[X
	 */
	public String[] split(String command, char delimiter) {
		String delimStri = "" + delimiter;
		int begin = 0;
		boolean inQuote = false;
		boolean isEscape = false;
		List ret = new ArrayList();
		char[] commands = command.trim().toCharArray();

		for (int i = 0; i <= command.length(); ++i) {
			char c = 0;
			if (i < command.length()) {
				c = commands[i];
			} else {
				//[Iɖ[ɂ
				c = delimiter;
				inQuote = false;
			}
			switch (c) {
				case '\\':
					if (isEscape) {
						//'\'̍ăGXP[vȂ̂Ŗ
						isEscape = false;
					} else {
						isEscape = true;
					}
					break;
				case '"':
					if (isEscape) {
						//GXP[vꂽeȂ̂Ŗ
					} else if (inQuote) {
						//͂܂ꂽ͈̖͂[ł
						inQuote = false;
					} else {
						//͈͂̊Jnł
						inQuote = true;
					}
					isEscape = false;
					break;
				default:
					if (inQuote) {
						//NI[gĂ̂Ŗ
					} else if (delimiter == c) {
						//؂̑O܂ł𕶎
						String str = new String(commands, begin, i - begin);
						if (0 < str.length() && !str.equals(delimStri)) {
							ret.add(str);
						} else {
							//skip
						}
						//Jnʒu炷
						begin = i + 1;
					} else {
						//vȂf~^
						break;
					}
					isEscape = false;
					break;
			}
		} //end for
		return (String[]) ret.toArray(new String[ret.size()]);
	}

	/**
	 * }No^܂B
	 * @param name }N
	 * @param macro }N
	 */
	public void addMacro(String name, String macro) {
		_macro.put(name, macro);
	}

	/**
	 * }N擾܂B
	 * @param name }N
	 * @return }N
	 */
	public String getMacro(String name) {
		return (String) _macro.get(name);
	}

	/**
	 * }Np[XAu܂B
	 * @param macro }N`
	 * @param args 
	 * @return u
	 */
	public String parseMacro(String macro, String[] args) {
		String ret = macro;
		for (int i = 0; i <= 9; ++i) {
			String repla = (i < args.length) ? args[i] : "";
			ret = ret.replaceAll("\\$\\{" + i + "\\}", repla);
		}
		return ret;
	}
}
