/*
 * 쐬: 2005/06/12
 */
package jp.sourceforge.cafebabe.builtin;

import jp.sourceforge.cafebabe.system.SystemManager;

/**
 * @author jin_k
 */
public class SetMacro extends SetEnv {

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.Command#execute(jp.sourceforge.cafebabe.system.SystemManager, java.lang.String[])
	 */
	public String execute(SystemManager manager, String[] args) {
		try {
			String[] keyValue = parseKeyValue(args);
			if (keyValue[0].startsWith("@")) {
				manager.getCommandManager().addMacro(keyValue[0], keyValue[1]);
			} else {
				throw new IllegalArgumentException();
			}
		} catch (IllegalArgumentException iae) {
			//G[\邪I͐I
			manager.println("");
			manager.println("# USAGE : " + args[0]
					+ " (@macroName=value|@macroName value)");
		}
		return SUCCESS;
	}
}
