/*
 * 쐬: 2005/06/12
 */
package jp.sourceforge.cafebabe.builtin;

import java.util.Iterator;
import java.util.Set;

import jp.sourceforge.cafebabe.framework.Command;
import jp.sourceforge.cafebabe.system.SystemManager;

/**
 * @author jin_k
 */
public class SetEnv implements Command {
	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.Command#execute(jp.sourceforge.cafebabe.system.SystemManager, java.lang.String[])
	 */
	public String execute(SystemManager manager, String[] args) {
		String[] keyValue = parseKeyValue(args);
		if (null == keyValue) {
			Set keys = manager.getEnvKeySet();
			for (Iterator it = keys.iterator(); it.hasNext();) {
				String key = (String) it.next();
				manager.println(key + "=" + manager.getEnv(key));
			}
		} else if (keyValue.length < 2) {
			//USAGE\ĐI
			manager.println("");
			manager.println("# USAGE : " + args[0]
					+ " (envName=value|envName value)");
		} else {
			manager.setEnv(keyValue[0], keyValue[1]);
		}
		return SUCCESS;
	}

	/**
	 * key=value\z܂B
	 * @param args 
	 * @return \zkey=valuez
	 */
	protected String[] parseKeyValue(String[] args) {
		if (args.length < 2) {
			return null;
		} else if (2 == args.length) {
			//envName=valuȅꍇ
			int pos = args[1].indexOf("=");
			if (-1 != pos) {
				String key = args[1].substring(0, pos);
				//envName= Ή
				String value = (pos + 1 < args[1].length()) ? eraseQuote(args[1]
						.substring(pos + 1, args[1].length()))
						: "";
				return new String[] { key, value };
			} else {
				return new String[0];
			}
		} else if (3 == args.length) {
			//envname value ̏ꍇ
			return new String[] { args[1], eraseQuote(args[2]) };
		} else {
			return new String[0];
		}
	}

	/**
	 * [̃NH[g폜܂B
	 * @param str Ώۂ̕
	 * @return [̃NH[g폜
	 */
	private String eraseQuote(String str) {
		if (str.startsWith("\"") && str.endsWith("\"")) {
			return str.substring(1, str.length() - 1);
		}
		return str;
	}
}
