/*
 * 쐬: 2005/06/08
 */
package jp.sourceforge.cafebabe.builtin;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URLClassLoader;

import jp.sourceforge.cafebabe.framework.Command;
import jp.sourceforge.cafebabe.system.CAFEBabe;
import jp.sourceforge.cafebabe.system.SystemManager;
import jp.sourceforge.cafebabe.util.IOUtil;

/**
 * javas܂B
 * @author jin_k
 */
public class Java implements Command {

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.Command#execute(jp.sourceforge.cafebabe.system.SystemManager, java.lang.String[])
	 */
	public String execute(SystemManager manager, String[] args) {
		try {
			ClassLoader cl = URLClassLoader.newInstance(IOUtil
					.getClassPathURLs(new File[] {
							new File(System.getProperty(CAFEBabe.DIR_ROOT),
									CAFEBabe.CONF_DIR),
							new File(System.getProperty(CAFEBabe.DIR_ROOT),
									CAFEBabe.EXT_DIR) }));
			if (args.length < 2) {
				manager
						.println("illegal argument.\nUSAGE : java <mainClassFQCN> <args>");
				return ERROR;
			} else {
				Class c = cl.loadClass(args[1]);
				Method main = c.getMethod("main",
						new Class[] { String[].class });
				String[] mainArgs = new String[args.length - 2];
				System.arraycopy(args, 2, mainArgs, 0, mainArgs.length);
				main.invoke(null, new Object[] { mainArgs });
			}
			return SUCCESS;
		} catch (Exception e) {
			manager.println("java failed.\n" + e.getClass() + " : "
					+ e.getMessage());
			return ERROR;
		}
	}
}
