/*
 * 쐬: 2005/04/05
 */

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

import jp.sourceforge.cafebabe.system.CAFEBabe;
import jp.sourceforge.cafebabe.util.IOUtil;
import jp.sourceforge.cafebabe.util.MultiplePrintStream;
import jp.sourceforge.cafebabe.util.NullStream;

/**
 * R}hCN܂B
 * @author jin_k
 */
public class Startup {
	/** NvpeBłB */
	private static final String BOOT_PROP = "conf/boot.properties";

	/** AvP[ViftHgj̃L[łB */
	private static final String DEFAULT_APP_KEY = "default";

	/** ftHg̃AvP[VłB */
	private static final String DEFAULT_APP = "cafebabe";

	/** logsfBNgłB */
	private static final String LOGS_DIR = "/logs";

	/** Wo̓OłB */
	private static final String LOG_FILE_STDOUT = LOGS_DIR + "/stdout.";

	/** WG[OłB */
	private static final String LOG_FILE_STDERR = LOGS_DIR + "/stderr.";

	/** }[WOłB */
	private static final String LOG_FILE_MERGE = LOGS_DIR + "/merge.";

	/** OgqłB */
	private static final String LOG_EXT = ".log";

	/** Wo̓O擾܂B */
	private static final String LOG_STDOUT = "cafebabe.log.stdout";

	/** WG[O擾܂B */
	private static final String LOG_STDERR = "cafebabe.log.stderr";

	/** Wo/WG[}[WO擾܂B */
	private static final String LOG_MERGE = "cafebabe.log.merge";

	/**
	 * R}hCN܂B <BR>
	 *  0 : [gfBNg <BR>
	 * 1 : N郂W[xmlt@CpX
	 * @param args 
	 */
	public static void main(String[] args) {
		try {
			if (args.length < 1) {
				throw new IllegalArgumentException();
			}
			//root directory
			String rootDir = args[0];

			//VXevpeBݒ
			System.setProperty(CAFEBabe.DIR_ROOT, rootDir);
			System.setProperty(CAFEBabe.DIR_LOGS, rootDir + LOGS_DIR);

			Properties prop = System.getProperties();
			BufferedInputStream bis = null;
			try {
				File boot = new File(rootDir, BOOT_PROP);
				if (boot.exists()) {
					bis = new BufferedInputStream(new FileInputStream(boot));
					prop.load(bis);
				}
			} finally {
				IOUtil.close(bis);
			}

			//Oݒ
			PrintStream merge = null;
			PrintStream stdout = null;
			PrintStream stderr = null;

			String time = new SimpleDateFormat("yyyy-MM-dd").format(new Date());

			if (Boolean.getBoolean(LOG_MERGE)) {
				merge = new PrintStream(new FileOutputStream(rootDir
						+ LOG_FILE_MERGE + time + LOG_EXT, true));
			}
			if (Boolean.getBoolean(LOG_STDOUT)) {
				stdout = new MultiplePrintStream(System.out,
						new MultiplePrintStream(new PrintStream(
								new FileOutputStream(rootDir + LOG_FILE_STDOUT
										+ time + LOG_EXT, true)), merge));
			} else if (null != merge) {
				stdout = new MultiplePrintStream(System.out, merge);
			} else {
				stdout = System.out;
			}
			if (Boolean.getBoolean(LOG_STDERR)) {
				stderr = new MultiplePrintStream(new PrintStream(
						new FileOutputStream(rootDir + LOG_FILE_STDERR + time
								+ LOG_EXT, true)), merge);
			} else if (null != merge) {
				stderr = merge;
			} else {
				stderr = new NullStream();
			}
			System.setOut(stdout);
			System.setErr(stderr);

			//AvP[Vݒ
			String appName = null;
			if (1 < args.length) {
				appName = args[1];
			} else if (null != System.getProperty(DEFAULT_APP_KEY)) {
				appName = System.getProperty(DEFAULT_APP_KEY);
			} else {
				appName = DEFAULT_APP;
			}

			//NXpXݒ/NX[_쐬
			ClassLoader cl = URLClassLoader.newInstance(IOUtil
					.getClassPathURLs(new File[] {
							new File(rootDir, CAFEBabe.CONF_DIR),
							new File(rootDir, CAFEBabe.EXT_DIR) }));

			//NX[_ɓo^
			Thread.currentThread().setContextClassLoader(cl);

			//CNX쐬
			CAFEBabe cafebabe = new CAFEBabe(cl, appName);
			cafebabe.init();
			cafebabe.start();
		} catch (IllegalArgumentException iae) {
			iae.printStackTrace();
		} catch (Throwable t) {
			//error
			t.printStackTrace();
		}
	}
}
