/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cafebabe.system;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.cafebabe.framework.CommandException;
import jp.sourceforge.cafebabe.framework.CommandFatalException;
import jp.sourceforge.cafebabe.framework.CommandManager;
import jp.sourceforge.cafebabe.framework.CommandSet;
import jp.sourceforge.cafebabe.framework.CommandWrapper;
import jp.sourceforge.cafebabe.framework.InputManager;
import jp.sourceforge.cafebabe.framework.OutputManager;
import jp.sourceforge.cafebabe.impl.RootCommandSet;
import jp.sourceforge.cafebabe.system.CommandQueue;

public class SystemManager
implements OutputManager {
    public static final String ROOT_SET = "root";
    public static final String EXIT = "exit";
    private final String _appName;
    private CommandQueue _commandQueue;
    private CommandManager _commandManager;
    private InputManager _inputManager;
    private OutputManager _outputManager;
    private RootCommandSet _root;
    private final Map _env;
    private CommandWrapper _commandWrapper;
    private boolean _isShotdowned;

    SystemManager(String appName) {
        this._appName = appName;
        this._env = new HashMap();
    }

    void setRootCommandSet(RootCommandSet root) {
        this._root = root;
    }

    public RootCommandSet getRootCommandSet() {
        return this._root;
    }

    public CommandSet getGlobal() {
        return (CommandSet)this._root.getCommand("global");
    }

    public CommandQueue getCommandQueue() {
        return this._commandQueue;
    }

    void setCommandQueue(CommandQueue queue) {
        this._commandQueue = queue;
    }

    void setCommandManager(CommandManager cm) {
        this._commandManager = cm;
    }

    public CommandManager getCommandManager() {
        return this._commandManager;
    }

    public InputManager getInputManager() {
        return this._inputManager;
    }

    void setInputManager(InputManager manager) {
        this._inputManager = manager;
    }

    public void setEnv(String key, Serializable value) {
        this._env.put(key, value);
    }

    public Object getEnv(String key) {
        return this._env.get(key);
    }

    public Set getEnvKeySet() {
        return this._env.keySet();
    }

    public String getInput() {
        return this.getInput(this._appName);
    }

    public String getInput(String msg) {
        return this.getInput(msg, false);
    }

    public String getInput(boolean ignoreEmptyString) {
        return this.getInput(this._appName, ignoreEmptyString);
    }

    public String getInput(String msg, boolean ignoreEmptyString) {
        return this._commandManager.getInput(msg, ignoreEmptyString);
    }

    void setOutputManager(OutputManager outputManager) {
        this._outputManager = outputManager;
    }

    public String[] getCommand() {
        return this.getCommand(this._appName);
    }

    public String[] getCommand(String msg) {
        return this.getCommand(msg, false);
    }

    public String[] getCommand(boolean ignoreEmptyString) {
        return this.getCommand(this._appName, ignoreEmptyString);
    }

    public String[] getCommand(String msg, boolean ignoreEmptyString) {
        return this._commandManager.getCommand(msg, ignoreEmptyString);
    }

    public OutputManager getOutputManager() {
        return this._outputManager;
    }

    public void print(String msg) {
        this._outputManager.print(msg);
    }

    public void print(int line, int column, String msg) {
        this._outputManager.print(line, column, msg);
    }

    public void println(String msg) {
        this._outputManager.println(msg);
    }

    public void println(int line, int column, String msg) {
        this._outputManager.println(line, column, msg);
    }

    public void errPrint(String msg) {
        this._outputManager.print(msg);
    }

    public void errPrintln(String msg) {
        this._outputManager.println(msg);
    }

    public void clear() {
        this._outputManager.clear();
    }

    public void setWrapper(CommandWrapper parent) {
        this._commandWrapper = parent;
    }

    public void removeWrapper() {
        this._commandWrapper = null;
    }

    public CommandWrapper getWrapper() {
        return this._commandWrapper;
    }

    protected void start() throws CommandFatalException, CommandException {
        String ret = null;
        do {
            this._root.execute(this, new String[]{ROOT_SET});
        } while (ret != null && !ret.equals(EXIT) && !ret.equals("fatal"));
    }

    public void shutdown() {
        if (!this._isShotdowned) {
            this._isShotdowned = true;
        }
    }

    public static interface BootDefine {
        public static final String NOT_MATCH_ASTERISK = "cafebabe.forward.notmatchasterisk";
    }
}

