/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cafebabe.system;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sourceforge.cafebabe.framework.CommandSet;
import jp.sourceforge.cafebabe.framework.CommandWrapper;
import jp.sourceforge.cafebabe.impl.CommandSetImpl;
import jp.sourceforge.cafebabe.impl.LazyInitializedCommand;
import jp.sourceforge.cafebabe.impl.RootCommandSet;
import jp.sourceforge.cafebabe.system.SystemManager;
import jp.sourceforge.cafebabe.util.IOUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class BabeBuilder
extends DefaultHandler {
    private static final String XML_EXT = ".xml";
    private final SystemManager _manager;
    private final Stack _elementsStack;
    private CommandSet _currentCommandSet;
    private CommandWrapper _currentCommand;
    private String _name;

    private BabeBuilder(SystemManager manager, RootCommandSet root) {
        this._manager = manager;
        this._currentCommandSet = root;
        this._currentCommand = root;
        this._elementsStack = new Stack();
    }

    private RootCommandSet getCreatedSet() {
        if (this._currentCommandSet instanceof RootCommandSet) {
            return (RootCommandSet)this._currentCommandSet;
        }
        throw new RuntimeException();
    }

    public static final RootCommandSet createBabe(SystemManager manager, String appName) throws Exception {
        return BabeBuilder.createBabe(manager, appName, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final RootCommandSet createBabe(SystemManager manager, String appName, RootCommandSet root) throws Exception {
        BabeBuilder clBuilder = new BabeBuilder(manager, root);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        String xmlName = System.getProperty("alias.apps." + appName);
        if (xmlName == null) {
            xmlName = String.valueOf(appName) + XML_EXT;
        }
        BufferedInputStream bis = null;
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlName);
            if (is == null) throw new FileNotFoundException("XML file [" + xmlName + "] not found.");
            bis = new BufferedInputStream(is);
            parser.parse((InputStream)bis, (DefaultHandler)clBuilder);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            IOUtil.close(is);
            IOUtil.close(bis);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        IOUtil.close(is);
        IOUtil.close(bis);
        return clBuilder.getCreatedSet();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName == null || qName.equals("")) {
            throw new SAXException("qName == null or \"\"");
        }
        if (qName.equals("root")) {
            this._name = "root";
            if (this._currentCommandSet == null) {
                this._currentCommandSet = new RootCommandSet(this._name);
                this._currentCommandSet.setSystemManager(this._manager);
                this._currentCommand = this._currentCommandSet;
            }
        } else if (qName.equals("env")) {
            this.startEnvSet(qName, attributes);
        } else if (qName.equals("forward")) {
            this.startForwardSet(attributes);
        } else if (!qName.equals("envset") && !qName.equals("forwardset")) {
            if (qName.equals("commandset")) {
                this.startCommandSet(attributes);
            } else if (qName.equals("command")) {
                this.startCommand(attributes);
            } else {
                throw new SAXException("qName[" + qName + "] is not defined.");
            }
        }
    }

    private void startEnvSet(String qName, Attributes attributes) throws SAXException {
        if (!qName.equals("env")) {
            throw new SAXException("qName[" + qName + "] is not defined.");
        }
        this._manager.setEnv(attributes.getValue("name"), (Serializable)((Object)attributes.getValue("value")));
    }

    private void startForwardSet(Attributes attributes) {
        this._currentCommand.setForward(attributes.getValue("name"), attributes.getValue("value"));
    }

    private void startCommandSet(Attributes attributes) {
        this._elementsStack.push(this._currentCommandSet);
        CommandSet parent = this._currentCommandSet;
        this._name = attributes.getValue("name");
        if (parent.containsCommand(this._name) && parent.getCommand(this._name) instanceof CommandSet) {
            this._currentCommandSet = (CommandSet)parent.getCommand(this._name);
            this._currentCommand = this._currentCommandSet;
        } else {
            this._currentCommandSet = new CommandSetImpl(this._name);
            this._currentCommandSet.setSystemManager(this._manager);
            this._currentCommandSet.setParent(parent);
            parent.setCommand(this._currentCommandSet);
            this._currentCommand = this._currentCommandSet;
        }
    }

    private void startCommand(Attributes attributes) {
        this._currentCommand = new LazyInitializedCommand(attributes.getValue("name"), attributes.getValue("class"));
        this._currentCommand.setSystemManager(this._manager);
        this._currentCommand.setParent(this._currentCommandSet);
        this._currentCommandSet.setCommand(this._currentCommand);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName == null || qName.equals("")) {
            throw new SAXException("qName == null or \"\"");
        }
        if (!(qName.equals("root") || qName.equals("envset") || qName.equals("forwardset"))) {
            if (qName.equals("commandset")) {
                this._currentCommandSet = (CommandSet)this._elementsStack.pop();
                this._name = this._currentCommandSet.getName();
            } else if (qName.equals("command")) {
                this._currentCommand = this._currentCommandSet;
            } else if (!qName.equals("env") && !qName.equals("forward")) {
                throw new SAXException("qName[" + qName + "] is not defined.");
            }
        }
    }

    private static interface XMLDefine {
        public static final String ROOT = "root";
        public static final String NAME = "name";
        public static final String VALUE = "value";
        public static final String ENV_SET = "envset";
        public static final String ENV = "env";
        public static final String COMMAND_SET = "commandset";
        public static final String COMMAND = "command";
        public static final String CLASS = "class";
        public static final String FORWARD_SET = "forwardset";
        public static final String FORWARD = "forward";
    }
}

