/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cafebabe.framework;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.cafebabe.framework.Command;
import jp.sourceforge.cafebabe.framework.CommandException;
import jp.sourceforge.cafebabe.framework.CommandFatalException;
import jp.sourceforge.cafebabe.framework.CommandSet;
import jp.sourceforge.cafebabe.system.SystemManager;

public abstract class CommandWrapper
implements Command {
    private static final boolean DEBUG = false;
    protected static final String ASTERISK = "*";
    private static final String[] NOT_MATCH_ASTERISK = System.getProperty("cafebabe.forward.notmatchasterisk").split(",");
    private final Map _forwards = new HashMap();
    private String _name;
    private CommandSet _parent;
    private SystemManager _manager;

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setParent(CommandSet parent) {
        this._parent = parent;
    }

    public CommandSet getParent() {
        return this._parent;
    }

    public void setSystemManager(SystemManager manager) {
        this._manager = manager;
    }

    public SystemManager getSystemManager() {
        return this._manager;
    }

    public void setForward(String key, String value) {
        this._forwards.put(key, value);
    }

    public String getForward(String key) {
        return (String)this._forwards.get(key);
    }

    public boolean containsForward(String name) {
        return this._forwards.containsKey(name);
    }

    public Set forwardKeySet() {
        return this._forwards.keySet();
    }

    public String execute(SystemManager manager, String[] args) throws CommandFatalException, CommandException {
        try {
            manager.setWrapper(this);
            String string = this.convertForward(manager.getGlobal(), this.executeImpl(manager, args));
            Object var3_4 = null;
            manager.removeWrapper();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            manager.removeWrapper();
            throw throwable;
        }
    }

    public abstract String executeImpl(SystemManager var1, String[] var2) throws CommandFatalException, CommandException;

    private String convertForward(CommandSet global, String ret) {
        if (ret == null) {
            return null;
        }
        if (this.containsForward(ret)) {
            return this.getForward(ret);
        }
        if (global != null && global.containsForward(ret)) {
            return global.getForward(ret);
        }
        if (this.matchAster(ret) && this.containsForward(ASTERISK)) {
            return this.getForward(ASTERISK);
        }
        if (global != null && this.matchAster(ret) && global.containsForward(ASTERISK)) {
            return global.getForward(ASTERISK);
        }
        return ret;
    }

    protected boolean matchAster(String str) {
        int i = 0;
        while (i < NOT_MATCH_ASTERISK.length) {
            if (str.equals(NOT_MATCH_ASTERISK[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

