/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cafebabe.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jp.sourceforge.cafebabe.system.CommandQueue;

public class CommandManager {
    private final CommandQueue _queue;
    private final LinkedList _subQueue;
    private final Map _macro;

    public CommandManager(CommandQueue queue) {
        this._queue = queue;
        this._subQueue = new LinkedList();
        this._macro = new HashMap();
    }

    public String getInput(String msg, boolean ignoreEmptyString) {
        return this._queue.dequeue(msg, ignoreEmptyString);
    }

    public String[] getCommand(String msg, boolean ignoreEmptyString) {
        if (this._subQueue.size() > 0) {
            return (String[])this._subQueue.removeFirst();
        }
        this.parse(this._queue.dequeue(msg, ignoreEmptyString));
        return this.getCommand(msg, ignoreEmptyString);
    }

    private void parse(String command) {
        String[] commandArray = this.split(command, ';');
        int i = 0;
        while (i < commandArray.length) {
            String macro;
            String[] coms = this.split(commandArray[i], ' ');
            if (coms[0].startsWith("@") && (macro = this.getMacro(coms[i].trim())) != null) {
                macro = this.parseMacro(macro, coms);
                this.parse(macro);
                return;
            }
            this._subQueue.addLast(coms);
            ++i;
        }
    }

    public String[] split(String command, char delimiter) {
        String delimStri = "" + delimiter;
        int begin = 0;
        boolean inQuote = false;
        boolean isEscape = false;
        ArrayList<String> ret = new ArrayList<String>();
        char[] commands = command.trim().toCharArray();
        int i = 0;
        while (i <= commands.length) {
            char c = '\u0000';
            if (i < commands.length) {
                c = commands[i];
            } else {
                c = delimiter;
                inQuote = false;
            }
            switch (c) {
                case '\\': {
                    if (isEscape) {
                        isEscape = false;
                        break;
                    }
                    isEscape = true;
                    break;
                }
                case '\"': {
                    if (!isEscape) {
                        inQuote = !inQuote;
                    }
                    isEscape = false;
                    break;
                }
                default: {
                    if (!inQuote) {
                        if (delimiter != c) break;
                        String str = new String(commands, begin, i - begin);
                        if (str.length() > 0 && !str.equals(delimStri)) {
                            ret.add(str);
                        }
                        begin = i + 1;
                    }
                    isEscape = false;
                }
            }
            ++i;
        }
        return ret.toArray(new String[ret.size()]);
    }

    public void addMacro(String name, String macro) {
        this._macro.put(name, macro);
    }

    public String getMacro(String name) {
        return (String)this._macro.get(name);
    }

    public String parseMacro(String macro, String[] args) {
        String ret = macro;
        int i = 0;
        while (i <= 9) {
            String repla = i < args.length ? args[i] : "";
            ret = ret.replaceAll("\\$\\{" + i + "\\}", repla);
            ++i;
        }
        return ret;
    }
}

