/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cafebabe.builtin;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import jp.sourceforge.cafebabe.framework.Command;
import jp.sourceforge.cafebabe.system.SystemManager;

public class SetEnv
implements Command {
    public String execute(SystemManager manager, String[] args) {
        String[] keyValue = this.parseKeyValue(args);
        if (keyValue == null) {
            Set keys = manager.getEnvKeySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                manager.println(String.valueOf(key) + "=" + manager.getEnv(key));
            }
        } else if (keyValue.length < 2) {
            manager.println("");
            manager.println("# USAGE : " + args[0] + " (envName=value|envName value)");
        } else {
            manager.setEnv(keyValue[0], (Serializable)((Object)keyValue[1]));
        }
        return "success";
    }

    protected String[] parseKeyValue(String[] args) {
        if (args.length < 2) {
            return null;
        }
        if (2 == args.length) {
            int pos = args[1].indexOf("=");
            if (-1 != pos) {
                String key = args[1].substring(0, pos);
                String value = pos + 1 < args[1].length() ? this.eraseQuote(args[1].substring(pos + 1, args[1].length())) : "";
                return new String[]{key, value};
            }
            return new String[0];
        }
        if (3 == args.length) {
            return new String[]{args[1], this.eraseQuote(args[2])};
        }
        return new String[0];
    }

    private String eraseQuote(String str) {
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }
}

