/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import jp.sourceforge.cafebabe.system.CAFEBabe;
import jp.sourceforge.cafebabe.util.IOUtil;
import jp.sourceforge.cafebabe.util.MultiplePrintStream;
import jp.sourceforge.cafebabe.util.NullStream;

public class Startup {
    private static final String BOOT_PROP = "conf/boot.properties";
    private static final String DEFAULT_APP_KEY = "default";
    private static final String DEFAULT_APP = "cafebabe";
    private static final String LOGS_DIR = "/logs";
    private static final String LOG_FILE_STDOUT = "/logs/stdout.";
    private static final String LOG_FILE_STDERR = "/logs/stderr.";
    private static final String LOG_FILE_MERGE = "/logs/merge.";
    private static final String LOG_EXT = ".log";
    private static final String LOG_STDOUT = "cafebabe.log.stdout";
    private static final String LOG_STDERR = "cafebabe.log.stderr";
    private static final String LOG_MERGE = "cafebabe.log.merge";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException();
            }
            String rootDir = args[0];
            System.setProperty("cafebabe.directory.root", rootDir);
            System.setProperty("cafebabe.directory.logs", String.valueOf(rootDir) + LOGS_DIR);
            Properties prop = System.getProperties();
            BufferedInputStream bis = null;
            try {
                File boot = new File(rootDir, BOOT_PROP);
                if (boot.exists()) {
                    bis = new BufferedInputStream(new FileInputStream(boot));
                    prop.load(bis);
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                IOUtil.close(bis);
                throw throwable;
            }
            {
                Object var5_10 = null;
            }
            IOUtil.close(bis);
            PrintStream merge = null;
            PrintStream stdout = null;
            PrintStream stderr = null;
            String time = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            if (Boolean.getBoolean(LOG_MERGE)) {
                merge = new PrintStream(new FileOutputStream(String.valueOf(rootDir) + LOG_FILE_MERGE + time + LOG_EXT, true));
            }
            stdout = Boolean.getBoolean(LOG_STDOUT) ? new MultiplePrintStream(System.out, new MultiplePrintStream(new PrintStream(new FileOutputStream(String.valueOf(rootDir) + LOG_FILE_STDOUT + time + LOG_EXT, true)), merge)) : (merge != null ? new MultiplePrintStream(System.out, merge) : System.out);
            stderr = Boolean.getBoolean(LOG_STDERR) ? new MultiplePrintStream(new PrintStream(new FileOutputStream(String.valueOf(rootDir) + LOG_FILE_STDERR + time + LOG_EXT, true)), merge) : (merge != null ? merge : new NullStream());
            System.setOut(stdout);
            System.setErr(stderr);
            String appName = null;
            appName = 1 < args.length ? args[1] : (System.getProperty(DEFAULT_APP_KEY) != null ? System.getProperty(DEFAULT_APP_KEY) : DEFAULT_APP);
            URLClassLoader cl = URLClassLoader.newInstance(IOUtil.getClassPathURLs(new File[]{new File(rootDir), new File(rootDir, "/conf"), new File(rootDir, "/lib/ext/")}));
            Thread.currentThread().setContextClassLoader(cl);
            CAFEBabe cafebabe = new CAFEBabe(cl, appName);
            cafebabe.init();
            cafebabe.start();
            return;
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            return;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

