/*
 * Decompiled with CFR 0.152.
 */
package com.apple.cocoa.foundation;

import com.apple.cocoa.foundation.NSRange;

public class NSMutableRange
extends NSRange {
    private int _backingRange = 0;
    private boolean _freeRange = true;
    static /* synthetic */ Class class$com$apple$cocoa$foundation$NSMutableRange;

    public NSMutableRange() {
        this(0, 0);
    }

    public NSMutableRange(NSRange nSRange) {
        this(nSRange.location(), nSRange.length());
    }

    public NSMutableRange(int n, int n2) {
        if (0 <= n2 && 0 <= n) {
            this._backingRange = this.privateCreateBackingRange();
            this.setLocation(n);
            this.setLength(n2);
            return;
        }
        throw new IllegalArgumentException("cannot create NSMutableRange with negative location (" + n + ") or length (" + n2 + ")");
    }

    private NSMutableRange(int n) {
        this._backingRange = n;
        this._freeRange = false;
    }

    protected void finalize() {
        if (this._freeRange && this._backingRange != 0) {
            this.privateDestroyBackingRange(this._backingRange);
        }
    }

    public int location() {
        return this.privateLocation(this._backingRange);
    }

    public int length() {
        return this.privateLength(this._backingRange);
    }

    public void setLocation(int n) {
        if (0 <= n) {
            this.privateSetLocation(this._backingRange, n);
            return;
        }
        throw new IllegalArgumentException("NSMutableRange cannot set negative location (" + n + ")");
    }

    public void setLength(int n) {
        if (0 <= n) {
            this.privateSetLength(this._backingRange, n);
            return;
        }
        throw new IllegalArgumentException("NSMutableRange cannot set negative length (" + n + ")");
    }

    public void unionRange(NSRange nSRange) {
        int n;
        int n2 = this.location();
        int n3 = n2 + this.length();
        int n4 = nSRange.location();
        int n5 = n4 + (n = nSRange.length());
        int n6 = n5 < n3 ? n3 : n5;
        int n7 = n2 < n4 ? n2 : n4;
        this.setLocation(n7);
        this.setLength(n6 - n7);
    }

    public void intersectRange(NSRange nSRange) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.location();
        int n6 = n5 + this.length();
        int n7 = n4 = n6 < (n3 = (n2 = nSRange.location()) + (n = nSRange.length())) ? n6 : n3;
        if (n2 <= n5 && n5 < n3) {
            this.setLocation(n5);
            this.setLength(n4 - n5);
        } else if (n5 <= n2 && n2 < n6) {
            this.setLocation(n2);
            this.setLength(n4 - n2);
        } else {
            this.setLocation(0);
            this.setLength(0);
        }
    }

    public Object clone() {
        return new NSMutableRange(this);
    }

    private native int privateCreateBackingRange();

    private native void privateDestroyBackingRange(int var1);

    private native int privateLocation(int var1);

    private native int privateLength(int var1);

    private native void privateSetLocation(int var1, int var2);

    private native void privateSetLength(int var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ClassLoader classLoader = (class$com$apple$cocoa$foundation$NSMutableRange == null ? (class$com$apple$cocoa$foundation$NSMutableRange = NSMutableRange.class$("com.apple.cocoa.foundation.NSMutableRange")) : class$com$apple$cocoa$foundation$NSMutableRange).getClassLoader();
        try {
            if (classLoader == null) {
                Class.forName("com.apple.cocoa.foundation.NSRunLoop");
            } else {
                classLoader.loadClass("com.apple.cocoa.foundation.NSRunLoop");
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to load FoundationJava.");
            exception.printStackTrace(System.err);
        }
    }
}

