/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.nio;

import de.kapsi.net.daap.DaapAuthenticator;
import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapFilter;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapSession;
import de.kapsi.net.daap.DaapStreamException;
import de.kapsi.net.daap.DaapStreamSource;
import de.kapsi.net.daap.DaapThreadFactory;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.SimpleConfig;
import de.kapsi.net.daap.nio.DaapConnectionNIO;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DaapServerNIO
implements DaapServer {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$nio$DaapServerNIO == null ? (class$de$kapsi$net$daap$nio$DaapServerNIO = DaapServerNIO.class$("de.kapsi.net.daap.nio.DaapServerNIO")) : class$de$kapsi$net$daap$nio$DaapServerNIO));
    private static final long TIMEOUT = 50L;
    private ServerSocketChannel ssc = null;
    private Selector selector = null;
    private Library library;
    private HashSet streams;
    private HashSet connections;
    private HashSet sessionIds;
    private DaapConfig config;
    private DaapFilter filter;
    private DaapStreamSource streamSource;
    private DaapAuthenticator authenticator;
    private boolean running = false;
    private boolean disconnectAll = false;
    private boolean update = false;
    static /* synthetic */ Class class$de$kapsi$net$daap$nio$DaapServerNIO;

    public DaapServerNIO(Library library) {
        this(library, new SimpleConfig());
    }

    public DaapServerNIO(Library library, int port) {
        this(library, new SimpleConfig(port));
    }

    public DaapServerNIO(Library library, DaapConfig config) {
        this.library = library;
        this.config = config;
    }

    public Library getLibrary() {
        return this.library;
    }

    public void setConfig(DaapConfig config) {
        this.config = config;
    }

    public DaapConfig getConfig() {
        return this.config;
    }

    public void setAuthenticator(DaapAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public DaapAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setStreamSource(DaapStreamSource streamSource) {
        this.streamSource = streamSource;
    }

    public DaapStreamSource getStreamSource() {
        return this.streamSource;
    }

    public void setFilter(DaapFilter filter) {
        this.filter = filter;
    }

    public DaapFilter getFilter() {
        return this.filter;
    }

    public void setThreadFactory(DaapThreadFactory factory) {
        throw new UnsupportedOperationException();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void bind() throws IOException {
        InetSocketAddress bindAddr = this.config.getInetSocketAddress();
        int backlog = this.config.getBacklog();
        try {
            this.ssc = ServerSocketChannel.open();
            ServerSocket socket = this.ssc.socket();
            socket.setReuseAddress(false);
            try {
                socket.bind(bindAddr, backlog);
            }
            catch (SocketException err) {
                throw new BindException(err.getMessage());
            }
            this.ssc.configureBlocking(false);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("DaapServerNIO bound to " + bindAddr));
            }
            this.streams = new HashSet();
            this.connections = new HashSet();
            this.sessionIds = new HashSet();
        }
        catch (IOException err) {
            this.close();
            throw err;
        }
    }

    public void update() {
        this.update = true;
    }

    synchronized boolean isSessionIdValid(int sessionId) {
        return this.isSessionIdValid(new Integer(sessionId));
    }

    public synchronized boolean isSessionIdValid(Integer sessionId) {
        return this.sessionIds != null ? this.sessionIds.contains(sessionId) : false;
    }

    public DaapConnection getConnection(Integer sessionId) {
        if (this.connections == null) {
            return null;
        }
        Iterator it = this.connections.iterator();
        while (it.hasNext()) {
            Integer sid;
            DaapConnection connection = (DaapConnection)it.next();
            DaapSession session = connection.getSession(false);
            if (session == null || !(sid = session.getSessionId()).equals(sessionId)) continue;
            return connection;
        }
        return null;
    }

    public Integer createSessionId() {
        if (this.sessionIds == null) {
            return null;
        }
        Integer sid = DaapUtil.createSessionId(this.sessionIds);
        this.sessionIds.add(sid);
        return sid;
    }

    public synchronized int getNumberOfConnections() {
        return this.connections != null ? this.connections.size() : 0;
    }

    public synchronized int getNumberOfStreams() {
        return this.streams != null ? this.streams.size() : 0;
    }

    public void stop() {
        this.running = false;
    }

    private synchronized void close() {
        this.running = false;
        this.update = false;
        this.disconnectAll = false;
        if (this.selector != null) {
            Iterator<SelectionKey> it = this.selector.keys().iterator();
            while (it.hasNext()) {
                SelectionKey sk = it.next();
                this.cancel(sk);
            }
            try {
                this.selector.close();
            }
            catch (IOException err) {
                LOG.error((Object)"Selector.close()", (Throwable)err);
            }
            this.selector = null;
        }
        if (this.ssc != null) {
            try {
                this.ssc.close();
            }
            catch (IOException err) {
                LOG.error((Object)"ServerSocketChannel.close()", (Throwable)err);
            }
            this.ssc = null;
        }
        if (this.sessionIds != null) {
            this.sessionIds.clear();
            this.sessionIds = null;
        }
        if (this.streams != null) {
            this.streams.clear();
            this.streams = null;
        }
        if (this.connections != null) {
            this.connections.clear();
            this.connections = null;
        }
    }

    public void disconnectAll() {
        this.disconnectAll = true;
    }

    private void cancel(SelectionKey sk) {
        sk.cancel();
        SelectableChannel channel = sk.channel();
        try {
            channel.close();
        }
        catch (IOException err) {
            LOG.error((Object)"Channel.close()", (Throwable)err);
        }
        DaapConnection connection = (DaapConnection)sk.attachment();
        if (connection != null) {
            DaapSession session = connection.getSession(false);
            if (session != null) {
                this.sessionIds.remove(session.getSessionId());
            }
            connection.close();
            if (connection.isDaapConnection()) {
                this.connections.remove(connection);
            } else if (connection.isAudioStream()) {
                this.streams.remove(connection);
            }
        }
    }

    void registerConnection(DaapConnection connection) throws IOException {
        if (connection.isAudioStream()) {
            if (this.streams.size() < this.config.getMaxConnections()) {
                this.streams.add(connection);
                return;
            }
        } else if (connection.isDaapConnection() && this.connections.size() < this.config.getMaxConnections()) {
            this.connections.add(connection);
            return;
        }
        throw new IOException("Too many connections");
    }

    private boolean accept(InetAddress addr) {
        if (this.filter != null && !this.filter.accept(addr)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("DaapFilter refused connection from " + addr));
            }
            return false;
        }
        return true;
    }

    private void processAccept(SelectionKey sk) throws IOException {
        if (!sk.isValid()) {
            return;
        }
        ServerSocketChannel ssc = (ServerSocketChannel)sk.channel();
        SocketChannel channel = ssc.accept();
        if (channel == null) {
            return;
        }
        if (channel.isOpen() && this.accept(channel.socket().getInetAddress())) {
            channel.configureBlocking(false);
            DaapConnectionNIO connection = new DaapConnectionNIO(this, channel);
            SelectionKey key = channel.register(this.selector, 1, connection);
        } else {
            try {
                channel.close();
            }
            catch (IOException err) {
                LOG.error((Object)"SocketChannel.close()", (Throwable)err);
            }
        }
    }

    private void processRead(SelectionKey sk) throws IOException {
        if (!sk.isValid()) {
            return;
        }
        DaapConnectionNIO connection = (DaapConnectionNIO)sk.attachment();
        SocketChannel channel = (SocketChannel)sk.channel();
        boolean keepAlive = false;
        keepAlive = connection.read();
        if (keepAlive) {
            sk.interestOps(connection.interrestOps());
        } else {
            this.cancel(sk);
        }
    }

    private void processWrite(SelectionKey sk) throws IOException {
        if (!sk.isValid()) {
            return;
        }
        DaapConnectionNIO connection = (DaapConnectionNIO)sk.attachment();
        SocketChannel channel = (SocketChannel)sk.channel();
        boolean keepAlive = false;
        try {
            keepAlive = connection.write();
        }
        catch (DaapStreamException err) {
            keepAlive = false;
        }
        if (keepAlive) {
            sk.interestOps(connection.interrestOps());
        } else {
            this.cancel(sk);
        }
    }

    private void processDisconnect() {
        Iterator<SelectionKey> it = this.selector.keys().iterator();
        while (it.hasNext()) {
            SelectionKey sk = it.next();
            SelectableChannel channel = sk.channel();
            if (!(channel instanceof SocketChannel)) continue;
            this.cancel(sk);
        }
    }

    private void processUpdate() {
        Set<SelectionKey> keys = this.selector.keys();
        Iterator<SelectionKey> it = keys.iterator();
        while (it.hasNext()) {
            DaapConnection connection;
            SelectionKey sk = it.next();
            SelectableChannel channel = sk.channel();
            if (!(channel instanceof SocketChannel) || !(connection = (DaapConnection)sk.attachment()).isDaapConnection()) continue;
            try {
                connection.update();
                if (!sk.isValid()) continue;
                try {
                    sk.interestOps(5);
                }
                catch (CancelledKeyException err) {
                    this.cancel(sk);
                    LOG.error((Object)"SelectionKey.interestOps()", (Throwable)err);
                }
            }
            catch (ClosedChannelException err) {
                this.cancel(sk);
                LOG.error((Object)"DaapConnection.update()", (Throwable)err);
            }
            catch (IOException err) {
                this.cancel(sk);
                LOG.error((Object)"DaapConnection.update()", (Throwable)err);
            }
        }
    }

    private void process() throws IOException {
        int n = -1;
        this.running = true;
        this.update = false;
        this.disconnectAll = false;
        while (this.running) {
            try {
                n = this.selector.select(50L);
            }
            catch (NullPointerException err) {
                continue;
            }
            catch (CancelledKeyException err) {
                continue;
            }
            if (!this.running) break;
            if (this.disconnectAll) {
                this.processDisconnect();
                this.disconnectAll = false;
                continue;
            }
            if (this.update) {
                this.processUpdate();
                this.update = false;
            }
            if (n == 0) continue;
            Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
            while (it.hasNext() && this.running) {
                SelectionKey sk = it.next();
                it.remove();
                try {
                    if (sk.isAcceptable()) {
                        this.processAccept(sk);
                        continue;
                    }
                    if (sk.isReadable()) {
                        try {
                            this.processRead(sk);
                        }
                        catch (IOException err) {
                            this.cancel(sk);
                            LOG.error((Object)"An exception occured in processRead()", (Throwable)err);
                        }
                        continue;
                    }
                    if (!sk.isWritable()) continue;
                    try {
                        this.processWrite(sk);
                    }
                    catch (IOException err) {
                        this.cancel(sk);
                        LOG.error((Object)"An exception occured in processWrite()", (Throwable)err);
                    }
                }
                catch (CancelledKeyException err) {}
            }
        }
    }

    public void run() {
        try {
            if (this.running) {
                LOG.error((Object)"DaapServerNIO is already running.");
                return;
            }
            this.selector = Selector.open();
            SelectionKey sk = this.ssc.register(this.selector, 16);
            this.process();
        }
        catch (IOException err) {
            LOG.error((Object)err);
            throw new RuntimeException(err);
        }
        finally {
            this.close();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Name: ").append(this.config.getServerName()).append("\n");
        buffer.append("Address: ").append(this.config.getInetSocketAddress()).append("\n");
        buffer.append("Backlog: ").append(this.config.getBacklog()).append("\n");
        buffer.append("Max connections: ").append(this.config.getMaxConnections()).append("\n");
        buffer.append("IsRunning: ").append(this.isRunning()).append("\n");
        if (this.isRunning()) {
            buffer.append("Connections: ").append(this.getNumberOfConnections()).append("\n");
            buffer.append("Streams: ").append(this.getNumberOfStreams()).append("\n");
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

