/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.nio;

import de.kapsi.net.daap.DaapAudioResponse;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapStreamException;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.nio.DaapConnectionNIO;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;

public class DaapAudioResponseNIO
extends DaapAudioResponse {
    private ByteBuffer headerBuffer;
    private FileChannel chIn;
    private SocketChannel channel;

    public DaapAudioResponseNIO(DaapRequest request, Song song, FileInputStream in, int pos, int end) throws IOException {
        super(request, song, in, pos, end);
        this.headerBuffer = ByteBuffer.wrap(this.header);
        this.chIn = in.getChannel();
        DaapConnectionNIO connection = (DaapConnectionNIO)request.getConnection();
        this.channel = connection.getChannel();
    }

    public boolean hasRemainig() {
        if (this.headerBuffer.hasRemaining()) {
            return true;
        }
        return this.pos < this.end;
    }

    public boolean write() throws IOException {
        if (this.headerBuffer.hasRemaining()) {
            try {
                this.channel.write(this.headerBuffer);
                if (this.headerBuffer.hasRemaining()) {
                    return false;
                }
            }
            catch (IOException err) {
                this.close();
                throw err;
            }
        }
        try {
            return this.stream();
        }
        catch (IOException err) {
            throw new DaapStreamException(err);
        }
    }

    private boolean stream() throws IOException {
        if (this.pos < this.end) {
            if (!this.channel.isOpen()) {
                this.close();
                return true;
            }
            try {
                this.pos = (int)((long)this.pos + this.chIn.transferTo(this.pos, 512L, this.channel));
                if (this.pos >= this.end) {
                    this.close();
                    return true;
                }
                return false;
            }
            catch (IOException err) {
                this.close();
                throw err;
            }
        }
        return true;
    }

    private void close() throws IOException {
        this.pos = this.end;
        this.in.close();
        this.chIn.close();
    }
}

