/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.util;

import org.tritonus.TDebug;

public class TCircularBuffer {
    private boolean m_bBlockingRead;
    private boolean m_bBlockingWrite;
    private byte[] m_abData;
    private int m_nSize;
    private int m_nReadPos;
    private int m_nWritePos;
    private Trigger m_trigger;
    private boolean m_bOpen;

    public TCircularBuffer(int n, boolean bl, boolean bl2, Trigger trigger) {
        this.m_bBlockingRead = bl;
        this.m_bBlockingWrite = bl2;
        this.m_nSize = n;
        this.m_abData = new byte[this.m_nSize];
        this.m_nReadPos = 0;
        this.m_nWritePos = 0;
        this.m_trigger = trigger;
        this.m_bOpen = true;
    }

    public void close() {
        this.m_bOpen = false;
    }

    public int availableRead() {
        return this.m_nWritePos - this.m_nReadPos;
    }

    public int availableWrite() {
        return this.m_nSize - this.availableRead();
    }

    private int getReadPos() {
        return this.m_nReadPos % this.m_nSize;
    }

    private int getWritePos() {
        return this.m_nWritePos % this.m_nSize;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] var1_1, int var2_2, int var3_3) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out("TCircularBuffer.read(): called.");
        }
        if (!this.m_bOpen) {
            return -1;
        }
        var4_4 = this;
        synchronized (var4_4) {
            if (!this.m_bBlockingRead) {
                if (this.m_trigger != null && this.availableRead() < var3_3) {
                    if (TDebug.TraceCircularBuffer) {
                        TDebug.out("TCircularBuffer.read(): executing trigger.");
                    }
                    this.m_trigger.execute();
                }
                var3_3 = Math.min(this.availableRead(), var3_3);
            }
            var5_5 = var3_3;
            ** GOTO lbl33
            {
                try {
                    this.wait();
                }
                catch (InterruptedException var6_6) {
                    // empty catch block
                }
                do {
                    if (this.availableRead() == 0) continue block5;
                    var6_7 = Math.min(this.availableRead(), var5_5);
                    while (var6_7 > 0) {
                        var7_8 = Math.min(var6_7, this.m_nSize - this.getReadPos());
                        System.arraycopy(this.m_abData, this.getReadPos(), var1_1, var2_2, var7_8);
                        this.m_nReadPos += var7_8;
                        var2_2 += var7_8;
                        var6_7 -= var7_8;
                        var5_5 -= var7_8;
                    }
                    this.notifyAll();
lbl33:
                    // 2 sources

                } while (var5_5 > 0);
            }
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("TCircularBuffer.read(): completed.");
            }
            var6_7 = var3_3;
            return var6_7;
        }
    }

    public int write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    /*
     * Unable to fully structure code
     */
    public int write(byte[] var1_1, int var2_2, int var3_3) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out("TCircularBuffer.write(): called; nLength: " + var3_3);
        }
        var4_4 = this;
        synchronized (var4_4) {
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("TCircularBuffer.write(): entered synchronized block.");
            }
            if (!this.m_bBlockingWrite) {
                var3_3 = Math.min(this.availableWrite(), var3_3);
            }
            var5_5 = var3_3;
            ** GOTO lbl29
            {
                try {
                    this.wait();
                }
                catch (InterruptedException var6_6) {
                    // empty catch block
                }
                do {
                    if (this.availableWrite() == 0) continue block5;
                    var6_7 = Math.min(this.availableWrite(), var5_5);
                    while (var6_7 > 0) {
                        var7_8 = Math.min(var6_7, this.m_nSize - this.getWritePos());
                        System.arraycopy(var1_1, var2_2, this.m_abData, this.getWritePos(), var7_8);
                        this.m_nWritePos += var7_8;
                        var2_2 += var7_8;
                        var6_7 -= var7_8;
                        var5_5 -= var7_8;
                    }
                    this.notifyAll();
lbl29:
                    // 2 sources

                } while (var5_5 > 0);
            }
            var6_7 = var3_3;
            return var6_7;
        }
    }

    public static interface Trigger {
        public void execute();
    }
}

