/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import apple.laf.AquaImageFactory;
import apple.laf.AquaTabbedPaneUI;
import com.limegroup.gnutella.gui.ProgTabUIFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import javax.swing.UIManager;
import sun.java2d.SunGraphics2D;

public class AquaTab
extends AquaTabbedPaneUI {
    private static final int TRANSLUCENCY = Integer.MIN_VALUE;
    private static final int LIME_GREEN = 1545508;
    private static final int TOP_OFFSET = 3;
    private static final int BOTTOM_OFFSET = 1;

    protected void paintContents(Graphics g, int tabPlacement, int selTab, Rectangle tabRect, Rectangle iconRect, Rectangle tabRect2, boolean isSelected) {
        if (selTab < this.tabPane.getTabCount()) {
            int w = tabRect.width;
            int h = tabRect.height;
            BufferedImage img = new BufferedImage(w, h, 2);
            Graphics2D g2 = img.createGraphics();
            if (g2 instanceof SunGraphics2D) {
                boolean HONIZONTAL = true;
                boolean selected = false;
                boolean hidden = false;
                boolean active = true;
                boolean leftCap = selTab == 0;
                boolean rightCap = selTab == this.tabPane.getTabCount() - 1;
                boolean focused = false;
                AquaImageFactory.drawTab((SunGraphics2D)((SunGraphics2D)g2), (int)0, (int)0, (int)w, (int)h, (int)1, (boolean)selected, (boolean)hidden, (boolean)false, (boolean)active, (boolean)leftCap, (boolean)rightCap, (boolean)focused, (boolean)false);
            }
            g2.dispose();
            img.flush();
            DataBuffer src = img.getAlphaRaster().getDataBuffer();
            long currentTime = System.currentTimeMillis();
            ProgTabUIFactory.Progressor prog = (ProgTabUIFactory.Progressor)this.tabPane.getComponentAt(selTab);
            double percent = prog.calculatePercentage(currentTime);
            if (percent > 1.0) {
                percent = 1.0;
            }
            BufferedImage progress = new BufferedImage(w, h, 2);
            DataBuffer dst = progress.getAlphaRaster().getDataBuffer();
            int p = (int)((double)w * percent);
            for (int y = 3; y < h - 1; ++y) {
                for (int x = 0; x < p; ++x) {
                    int index = y * w + x;
                    int value = src.getElem(index);
                    dst.setElem(index, value & Integer.MIN_VALUE | AquaTab.getColor());
                }
            }
            progress.flush();
            g.drawImage(progress, tabRect.x, tabRect.y, null);
        }
        super.paintContents(g, tabPlacement, selTab, tabRect, iconRect, tabRect2, isSelected);
    }

    private static int getColor() {
        Color selectionBackground = UIManager.getDefaults().getColor("TextField.selectionBackground");
        if (selectionBackground == null) {
            return 1545508;
        }
        selectionBackground = selectionBackground.darker();
        return selectionBackground.getRed() << 16 | selectionBackground.getGreen() << 8 | selectionBackground.getBlue();
    }
}

