/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.protocols;

import org.logi.crypto.Crypto;
import org.logi.crypto.CryptoCorruptError;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.keys.Key;
import org.logi.crypto.keys.KeyException;
import org.logi.crypto.keys.SignatureKey;
import org.logi.crypto.modes.DecryptECB;
import org.logi.crypto.protocols.CryptoProtocolException;
import org.logi.crypto.protocols.EncryptedKeyEx;
import org.logi.crypto.protocols.NoninterKeyExServer;
import org.logi.crypto.random.Seedable;
import org.logi.crypto.sign.Signature;

public class EncryptedKeyExServer
extends EncryptedKeyEx
implements NoninterKeyExServer {
    protected Seedable seedMe;

    public byte[] message(byte[] byArray) throws CryptoProtocolException {
        if (byArray == null) {
            throw new CryptoProtocolException("null message received");
        }
        try {
            byte[] byArray2;
            int n = (int)Crypto.makeLong(byArray, 0, 4);
            DecryptECB decryptECB = new DecryptECB(this.key);
            int n2 = (int)Crypto.makeLong(byArray, 4, 4);
            byte[] byArray3 = decryptECB.decrypt(byArray, 8, n - 8);
            if (this.seedMe != null) {
                this.seedMe.setSeed(byArray3, 0, byArray3.length);
            }
            if (n2 == byArray3.length) {
                byArray2 = byArray3;
            } else {
                byArray2 = new byte[n2];
                System.arraycopy(byArray3, 0, byArray2, 0, n2);
            }
            if (this.signKey != null) {
                if (n == byArray.length) {
                    throw new CryptoProtocolException("No signature included with key.");
                }
                byte[] byArray4 = new byte[byArray.length - n];
                System.arraycopy(byArray, n, byArray4, 0, byArray4.length);
                Signature signature = new Signature(byArray4, null, null);
                try {
                    if (!this.signKey.verify(signature, Fingerprint.create(byArray2, "SHA1"))) {
                        throw new CryptoProtocolException("Key signature invalid.");
                    }
                }
                catch (KeyException keyException) {
                    throw new CryptoProtocolException(keyException.getMessage());
                }
                catch (InvalidCDSException invalidCDSException) {
                    throw new CryptoCorruptError(invalidCDSException.getMessage());
                }
            }
            try {
                this.sessionKey = (Key)Crypto.fromString(new String(byArray2));
                this.keyDecided = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new CryptoProtocolException("Did not receive a valid CDS for a CipherKey object.");
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CryptoProtocolException("Malformed message.");
        }
    }

    public EncryptedKeyExServer(CipherKey cipherKey) {
        super(cipherKey, null, null);
    }

    public EncryptedKeyExServer(CipherKey cipherKey, SignatureKey signatureKey) {
        super(cipherKey, signatureKey, null);
    }

    public EncryptedKeyExServer(CipherKey cipherKey, SignatureKey signatureKey, Seedable seedable) {
        super(cipherKey, signatureKey, null);
        this.seedMe = seedable;
    }
}

