/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.logi.crypto.Crypto;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.modes.DecryptMode;
import org.logi.crypto.protocols.CryptoProtocolException;
import org.logi.crypto.protocols.NoninterKeyExServer;
import org.logi.crypto.protocols.NoninterProtocolServer;

public class DecryptStream
extends FilterInputStream {
    private DecryptMode dmode;
    private byte[] buffer;
    private int bufPos;
    private int cipherBufferSize;

    private void execute(NoninterProtocolServer noninterProtocolServer, boolean bl) throws IOException, CryptoProtocolException {
        InputStream inputStream = bl ? this : this.in;
        int n = Crypto.readInt(inputStream);
        if (n < 0 || n > noninterProtocolServer.maxMessageSize()) {
            throw new CryptoProtocolException(n + " is not a valid message size for this protocol.");
        }
        if (n > 0) {
            byte[] byArray = new byte[n];
            int n2 = Crypto.readBlock(inputStream, byArray, 0, n);
            if (n2 == -1) {
                throw new CryptoProtocolException("EOF while executing protocol");
            }
            noninterProtocolServer.message(byArray);
        } else {
            noninterProtocolServer.message(null);
        }
        if (!noninterProtocolServer.completed()) {
            throw new CryptoProtocolException("The protocol was not completed");
        }
        if (bl) {
            this.drain();
        }
    }

    public void execute(NoninterProtocolServer noninterProtocolServer) throws IOException, CryptoProtocolException {
        this.execute(noninterProtocolServer, true);
    }

    private boolean fillBuffer() throws IOException {
        byte[] byArray = new byte[this.cipherBufferSize];
        int n = this.in.read(byArray);
        if (n == -1) {
            this.buffer = new byte[0];
            this.bufPos = 0;
            return false;
        }
        this.buffer = this.dmode.decrypt(byArray, 0, n);
        this.bufPos = 0;
        return true;
    }

    public synchronized int read() throws IOException {
        while (this.bufPos == this.buffer.length) {
            if (this.fillBuffer()) continue;
            return -1;
        }
        return this.buffer[this.bufPos++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        while (this.bufPos == this.buffer.length) {
            if (this.fillBuffer()) continue;
            return -1;
        }
        int n3 = n2 <= this.buffer.length - this.bufPos ? n2 : this.buffer.length - this.bufPos;
        System.arraycopy(this.buffer, this.bufPos, byArray, n, n3);
        this.bufPos += n3;
        return n3;
    }

    public synchronized int available() throws IOException {
        int n = this.buffer.length - this.bufPos;
        if (n > 0) {
            return n;
        }
        int n2 = this.in.available();
        if (n2 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n2];
        if ((n2 = this.in.read(byArray, 0, n2)) > 0) {
            this.buffer = this.dmode.decrypt(byArray, 0, n2);
            this.bufPos = 0;
            return this.buffer.length - this.bufPos;
        }
        return 0;
    }

    public long skip(long l) throws IOException {
        return 0L;
    }

    public int drain() {
        int n = this.dmode.plainBlockSize();
        int n2 = this.bufPos % n;
        if (n2 == 0) {
            return 0;
        }
        int n3 = n - n2;
        this.bufPos += n3;
        return n3;
    }

    public void close() throws IOException {
        this.dmode.close();
        this.in.close();
    }

    public boolean markSupported() {
        return false;
    }

    public DecryptStream(InputStream inputStream, NoninterKeyExServer noninterKeyExServer, DecryptMode decryptMode) throws CryptoProtocolException, IOException {
        super(inputStream);
        this.dmode = decryptMode;
        if (noninterKeyExServer != null) {
            this.execute(noninterKeyExServer, false);
            try {
                CipherKey cipherKey = (CipherKey)noninterKeyExServer.sessionKey();
                if (cipherKey == null) {
                    throw new CryptoProtocolException("A non-interactive protocol should only need one message.");
                }
                decryptMode.setKey(cipherKey);
            }
            catch (ClassCastException classCastException) {
                throw new CryptoProtocolException("The key-exchange protocol proposes to use a non-cipher key for decryption.");
            }
        }
        if (decryptMode.getKey() == null) {
            throw new CryptoProtocolException("No key specified or exchanged");
        }
        int n = decryptMode.getKey().cipherBlockSize();
        this.cipherBufferSize = (1024 / n + 1) * n;
        this.buffer = new byte[0];
    }
}

