/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.chunks.AbstractChunk;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class LongChunk
extends AbstractChunk {
    private static final BigInteger MAX_VALUE = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    private BigInteger value;

    protected LongChunk(String type, String name, long value) {
        super(type, name);
        this.setValue(value);
    }

    protected LongChunk(String type, String name, String value) {
        super(type, name);
        this.setValue(value);
    }

    protected LongChunk(String type, String name, BigInteger value) {
        super(type, name);
        this.setValue(value);
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.setValue(new BigInteger(Long.toHexString(value), 16));
    }

    public void setValue(String value) {
        this.setValue(new BigInteger(value, 16));
    }

    public void setValue(BigInteger value) {
        if (value == null || value.compareTo(MAX_VALUE) > 0) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    public int getLength() {
        return 8;
    }

    public int getType() {
        return 7;
    }

    public void serialize(OutputStream out) throws IOException {
        super.serialize(out);
        byte[] bytes = this.value.toByteArray();
        byte[] tmp = new byte[this.getLength()];
        int i = this.getLength() - 1;
        for (int j = bytes.length - 1; i >= 0 && j >= 0; --i, --j) {
            tmp[i] = bytes[j];
        }
        out.write(tmp, 0, tmp.length);
    }

    public String toString() {
        return super.toString() + "=" + this.getValue();
    }
}

