/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapException;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.Transaction;
import de.kapsi.net.daap.Txn;
import de.kapsi.net.daap.chunks.AbstractChunk;
import de.kapsi.net.daap.chunks.Chunk;
import de.kapsi.net.daap.chunks.DummyChunk;
import de.kapsi.net.daap.chunks.impl.DeletedIdListing;
import de.kapsi.net.daap.chunks.impl.ItemCount;
import de.kapsi.net.daap.chunks.impl.ItemId;
import de.kapsi.net.daap.chunks.impl.ItemName;
import de.kapsi.net.daap.chunks.impl.Listing;
import de.kapsi.net.daap.chunks.impl.ListingItem;
import de.kapsi.net.daap.chunks.impl.PersistentId;
import de.kapsi.net.daap.chunks.impl.PlaylistSongs;
import de.kapsi.net.daap.chunks.impl.ReturnedCount;
import de.kapsi.net.daap.chunks.impl.SmartPlaylist;
import de.kapsi.net.daap.chunks.impl.SpecifiedTotalCount;
import de.kapsi.net.daap.chunks.impl.Status;
import de.kapsi.net.daap.chunks.impl.UpdateType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Playlist
implements Cloneable {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$Playlist == null ? (class$de$kapsi$net$daap$Playlist = Playlist.class$("de.kapsi.net.daap.Playlist")) : class$de$kapsi$net$daap$Playlist));
    private static int PLAYLIST_ID = 0;
    private static final SmartPlaylist IS_SMART_PLAYLIST = new SmartPlaylist(false);
    private static final DummyChunk IS_NOT_SMART_PLAYLIST = new DummyChunk(IS_SMART_PLAYLIST);
    private ItemId itemId;
    private ItemName itemName;
    private PersistentId persistentId;
    private ItemCount itemCount;
    private HashSet items;
    private HashSet newItems;
    private HashSet deletedItems;
    private HashMap properties;
    private byte[] playlistSongs;
    private byte[] playlistSongsUpdate;
    private Playlist masterPlaylist;
    private boolean isSmartPlaylist = false;
    private boolean notifyMasterPlaylistOnAdd = true;
    private boolean notifyMasterPlaylistOnRemove = false;
    private boolean notifyMasterPlaylistOnUpdate = true;
    static /* synthetic */ Class class$de$kapsi$net$daap$Playlist;

    public Playlist(String name) {
        this(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Playlist(String name, boolean emptyPlaylist) {
        Class clazz = class$de$kapsi$net$daap$Playlist == null ? (class$de$kapsi$net$daap$Playlist = Playlist.class$("de.kapsi.net.daap.Playlist")) : class$de$kapsi$net$daap$Playlist;
        synchronized (clazz) {
            this.itemId = new ItemId(++PLAYLIST_ID);
        }
        this.items = new HashSet();
        this.newItems = new HashSet();
        this.deletedItems = new HashSet();
        this.properties = new HashMap();
        this.itemName = new ItemName(name);
        this.persistentId = new PersistentId(Library.nextPersistentId());
        this.itemCount = new ItemCount();
        this.add(this.itemId);
        this.add(this.itemName);
        this.add(this.persistentId);
        this.add(IS_NOT_SMART_PLAYLIST);
        this.add(this.itemCount);
        if (emptyPlaylist) {
            this.playlistSongs = new PlaylistSongsImpl(this, false).getBytes();
            this.playlistSongsUpdate = new PlaylistSongsImpl(this, true).getBytes();
        }
    }

    private Playlist(Playlist orig) {
        this.properties = new HashMap();
        this.itemId = new ItemId(orig.getId());
        this.itemName = new ItemName(orig.getName());
        this.persistentId = new PersistentId(this.itemId.getValue());
        this.itemCount = new ItemCount(orig.itemCount.getValue());
        this.add(this.itemId);
        this.add(this.itemName);
        this.add(this.persistentId);
        if (orig.isSmartPlaylist()) {
            this.add(IS_SMART_PLAYLIST);
        } else {
            this.add(IS_NOT_SMART_PLAYLIST);
        }
        this.add(this.itemCount);
        this.playlistSongs = orig.playlistSongs;
        this.playlistSongsUpdate = orig.playlistSongsUpdate;
        this.notifyMasterPlaylistOnAdd = orig.notifyMasterPlaylistOnAdd;
        this.notifyMasterPlaylistOnRemove = orig.notifyMasterPlaylistOnRemove;
        this.notifyMasterPlaylistOnUpdate = orig.notifyMasterPlaylistOnUpdate;
    }

    Txn openTxn(Transaction txn) throws DaapException {
        if (!txn.isOpen()) {
            throw new DaapException("Transaction is not open");
        }
        PlaylistTxn obj = (PlaylistTxn)txn.getAttribute(this);
        if (obj == null) {
            obj = new PlaylistTxn(this);
            txn.setAttribute(this, obj);
        }
        return obj;
    }

    void setMasterPlaylist(Playlist masterPlaylist) {
        this.masterPlaylist = masterPlaylist;
    }

    public int getId() {
        return this.itemId.getValue();
    }

    private void add(AbstractChunk chunk) {
        this.properties.put(chunk.getName(), chunk);
    }

    public Chunk getProperty(String property) {
        return (Chunk)this.properties.get(property);
    }

    public void setName(Transaction txn, String name) throws DaapException {
        PlaylistTxn obj = (PlaylistTxn)this.openTxn(txn);
        obj.setName(name);
    }

    public String getName() {
        return this.itemName.getValue();
    }

    public void setNotifyMasterPlaylistOnAdd(boolean notify) {
        this.notifyMasterPlaylistOnAdd = notify;
    }

    public void setNotifyMasterPlaylistOnRemove(boolean notify) {
        this.notifyMasterPlaylistOnRemove = notify;
    }

    public void setNotifyMasterPlaylistOnUpdate(boolean notify) {
        this.notifyMasterPlaylistOnUpdate = notify;
    }

    public void setSmartPlaylist(Transaction txn, boolean smart) throws DaapException {
        PlaylistTxn obj = (PlaylistTxn)this.openTxn(txn);
        obj.setSmartPlaylist(smart);
    }

    public boolean isSmartPlaylist() {
        return this.isSmartPlaylist;
    }

    Song getSong(int songId) {
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            Song song = (Song)it.next();
            if (song.getId() != songId) continue;
            return song;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int size() {
        return this.items.size();
    }

    public Set getSongs() {
        return Collections.unmodifiableSet(this.items);
    }

    public Set getNewSongs() {
        return Collections.unmodifiableSet(this.newItems);
    }

    public Set getDeletedSongs() {
        return Collections.unmodifiableSet(this.deletedItems);
    }

    public void update(Transaction txn, Song song) throws DaapException {
        if (!this.items.contains(song)) {
            return;
        }
        PlaylistTxn obj = (PlaylistTxn)this.openTxn(txn);
        obj.update(song);
    }

    public void add(Transaction txn, Song song) throws DaapException {
        PlaylistTxn obj = (PlaylistTxn)this.openTxn(txn);
        obj.add(song);
    }

    public void remove(Transaction txn, Song song) throws DaapException {
        PlaylistTxn obj = (PlaylistTxn)this.openTxn(txn);
        obj.remove(song);
    }

    public synchronized Object select(DaapRequest request) {
        if (request.isPlaylistSongsRequest()) {
            if (request.isUpdateType()) {
                return this.playlistSongsUpdate;
            }
            return this.playlistSongs;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Unknown request: " + request));
        }
        return null;
    }

    public boolean contains(Song song) {
        return this.items.contains(song);
    }

    public Object clone() throws CloneNotSupportedException {
        return new Playlist(this);
    }

    public String toString() {
        return this.getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ byte[] access$2002(Playlist x0, byte[] x1) {
        x0.playlistSongs = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$2102(Playlist x0, byte[] x1) {
        x0.playlistSongsUpdate = x1;
        return x1;
    }

    private static final class PlaylistSongsImpl
    extends PlaylistSongs {
        private PlaylistSongsImpl(Playlist playlist, boolean updateType) {
            Song song;
            this.add(new Status(200));
            this.add(new UpdateType(updateType));
            int secifiedTotalCount = playlist.items.size() - playlist.deletedItems.size();
            int returnedCount = playlist.newItems.size();
            this.add(new SpecifiedTotalCount(secifiedTotalCount));
            this.add(new ReturnedCount(returnedCount));
            Listing listing = new Listing();
            Iterator it = (updateType ? playlist.newItems : playlist.items).iterator();
            while (it.hasNext()) {
                ListingItem listingItem = new ListingItem();
                song = (Song)it.next();
                Iterator<String> properties = Arrays.asList(DaapUtil.PLAYLIST_SONGS_META).iterator();
                while (properties.hasNext()) {
                    String key = properties.next();
                    Chunk chunk = song.getProperty(key);
                    if (chunk != null) {
                        listingItem.add(chunk);
                        continue;
                    }
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)("Unknown chunk type: " + key));
                }
                listing.add(listingItem);
            }
            this.add(listing);
            if (updateType && (it = playlist.deletedItems.iterator()).hasNext()) {
                DeletedIdListing deletedListing = new DeletedIdListing();
                while (it.hasNext()) {
                    song = (Song)it.next();
                    deletedListing.add(new ItemId(song.getId()));
                }
                this.add(deletedListing);
            }
        }

        public byte[] getBytes() {
            return this.getBytes(true);
        }

        public byte[] getBytes(boolean compress) {
            try {
                return DaapUtil.serialize(this, compress);
            }
            catch (IOException err) {
                LOG.error((Object)err);
                return null;
            }
        }
    }

    private static class PlaylistTxn
    implements Txn {
        private Playlist playlist;
        private String name;
        private boolean isSmartPlaylist;
        private HashSet newItems = new HashSet();
        private HashSet deletedItems = new HashSet();
        private HashSet updateItems = new HashSet();

        private PlaylistTxn(Playlist playlist) {
            this.playlist = playlist;
            this.name = playlist.getName();
            this.isSmartPlaylist = playlist.isSmartPlaylist();
        }

        private void setName(String name) {
            this.name = name;
        }

        private void setSmartPlaylist(boolean smart) {
            this.isSmartPlaylist = smart;
        }

        private void add(Song song) {
            if (!this.newItems.contains(song)) {
                this.newItems.add(song);
                this.deletedItems.remove(song);
                this.updateItems.remove(song);
            }
        }

        private void remove(Song song) {
            if (!this.deletedItems.contains(song)) {
                this.deletedItems.add(song);
                this.newItems.remove(song);
                this.updateItems.remove(song);
            }
        }

        private void update(Song song) {
            if (!(this.updateItems.contains(song) || this.newItems.contains(song) || this.deletedItems.contains(song))) {
                this.updateItems.add(song);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit(Transaction txn) {
            Playlist playlist = this.playlist;
            synchronized (playlist) {
                Song song;
                if (this.playlist.getName() != this.name) {
                    this.playlist.itemName.setValue(this.name);
                }
                if (this.playlist.isSmartPlaylist() != this.isSmartPlaylist) {
                    this.playlist.isSmartPlaylist = this.isSmartPlaylist;
                    if (this.isSmartPlaylist) {
                        this.playlist.add(IS_SMART_PLAYLIST);
                    } else {
                        this.playlist.add(IS_NOT_SMART_PLAYLIST);
                    }
                }
                Playlist masterPlaylist = this.playlist.masterPlaylist;
                Iterator it = this.newItems.iterator();
                while (it.hasNext()) {
                    song = (Song)it.next();
                    if (this.playlist.items.contains(song)) continue;
                    this.playlist.items.add(song);
                    this.playlist.newItems.add(song);
                    this.playlist.deletedItems.remove(song);
                    if (!this.playlist.notifyMasterPlaylistOnAdd || this.playlist.masterPlaylist == null) continue;
                    this.playlist.masterPlaylist.add(txn, song);
                }
                it = this.updateItems.iterator();
                while (it.hasNext()) {
                    song = (Song)it.next();
                    if (!this.playlist.items.contains(song) || this.playlist.newItems.contains(song)) continue;
                    this.playlist.newItems.add(song);
                    if (!this.playlist.notifyMasterPlaylistOnUpdate || this.playlist.masterPlaylist == null) continue;
                    this.playlist.masterPlaylist.update(txn, song);
                }
                it = this.deletedItems.iterator();
                while (it.hasNext()) {
                    song = (Song)it.next();
                    if (!this.playlist.items.remove(song)) continue;
                    this.playlist.newItems.remove(song);
                    this.playlist.deletedItems.add(song);
                    if (!this.playlist.notifyMasterPlaylistOnRemove || this.playlist.masterPlaylist == null) continue;
                    this.playlist.masterPlaylist.remove(txn, song);
                }
                this.playlist.itemCount.setValue(this.playlist.items.size());
                Playlist.access$2002(this.playlist, new PlaylistSongsImpl(this.playlist, false).getBytes());
                Playlist.access$2102(this.playlist, new PlaylistSongsImpl(this.playlist, true).getBytes());
            }
            this.newItems.clear();
            this.deletedItems.clear();
            this.updateItems.clear();
        }

        public void rollback(Transaction txn) {
            this.newItems.clear();
            this.deletedItems.clear();
            this.updateItems.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup(Transaction txn) {
            Playlist playlist = this.playlist;
            synchronized (playlist) {
                this.playlist.newItems.clear();
                this.playlist.deletedItems.clear();
            }
            this.newItems.clear();
            this.deletedItems.clear();
            this.updateItems.clear();
        }

        public void join(Txn value) {
            PlaylistTxn obj = (PlaylistTxn)value;
            if (this.name != obj.name) {
                this.name = obj.name;
            }
            this.isSmartPlaylist = obj.isSmartPlaylist;
            Iterator it = obj.newItems.iterator();
            while (it.hasNext()) {
                this.add((Song)it.next());
            }
            it = obj.updateItems.iterator();
            while (it.hasNext()) {
                this.update((Song)it.next());
            }
            it = obj.deletedItems.iterator();
            while (it.hasNext()) {
                this.remove((Song)it.next());
            }
        }

        public String toString() {
            return "PlaylistTxn for " + this.playlist;
        }
    }
}

