/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapResponseWriter;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapSession;
import java.io.IOException;

public abstract class DaapConnection {
    protected static final int UNDEF = 0;
    protected static final int DAAP = 1;
    protected static final int AUDIO = 2;
    protected final DaapResponseWriter writer;
    private DaapServer server;
    private DaapSession session;
    private int type = 0;
    private int protocolVersion = 0;

    public DaapConnection(DaapServer server) {
        this.server = server;
        this.writer = new DaapResponseWriter();
    }

    public abstract void update() throws IOException;

    public boolean write() throws IOException {
        return !this.writer.write() || !this.isAudioStream();
    }

    public void close() {
        this.writer.clear();
        if (this.session != null) {
            this.session.invalidate();
            this.session = null;
        }
    }

    public DaapServer getServer() {
        return this.server;
    }

    protected void setConnectionType(int type) {
        this.type = type;
    }

    protected void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public boolean isAudioStream() {
        return this.type == 2;
    }

    public boolean isDaapConnection() {
        return this.type == 1;
    }

    public boolean isUndef() {
        return this.type == 0;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public DaapSession getSession(boolean create) {
        if (this.session == null && create) {
            this.session = new DaapSession(this.server.createSessionId());
        }
        return this.session;
    }
}

