/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public abstract class TAudioFileReader
extends AudioFileReader {
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            audioFileFormat = this.getAudioFileFormat(fileInputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat;
        InputStream inputStream = uRL.openStream();
        try {
            audioFileFormat = this.getAudioFileFormat(inputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return audioFileFormat;
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            return this.getAudioInputStream(fileInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            ((InputStream)fileInputStream).close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            ((InputStream)fileInputStream).close();
            throw iOException;
        }
    }

    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = uRL.openStream();
        try {
            return this.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            inputStream.close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            inputStream.close();
            throw iOException;
        }
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream);
        return new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    public static int readLittleEndianInt(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    public static short readLittleEndianShort(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n << 8) + (n2 << 0));
    }

    public static double readIeeeExtended(DataInputStream dataInputStream) throws IOException {
        double d = 0.0;
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        double d2 = 3.4028234663852886E38;
        n = dataInputStream.readUnsignedShort();
        long l3 = dataInputStream.readUnsignedShort();
        long l4 = dataInputStream.readUnsignedShort();
        l = l3 << 16 | l4;
        l3 = dataInputStream.readUnsignedShort();
        l4 = dataInputStream.readUnsignedShort();
        l2 = l3 << 16 | l4;
        if (n == 0 && l == 0L && l2 == 0L) {
            d = 0.0;
        } else if (n == Short.MAX_VALUE) {
            d = d2;
        } else {
            n -= 16383;
            d = (double)l * Math.pow(2.0, n -= 31);
            d += (double)l2 * Math.pow(2.0, n -= 32);
        }
        return d;
    }
}

