/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import java.io.IOException;
import java.io.OutputStream;

public class QueuedUploadState
extends UploadState {
    private final int POSITION;

    public QueuedUploadState(int n, HTTPUploader hTTPUploader) {
        super(hTTPUploader);
        this.POSITION = n;
    }

    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        Assert.that(this.POSITION != -1);
        String string = "HTTP/1.1 503 Service Unavailable\r\n";
        outputStream.write(string.getBytes());
        HTTPUtils.writeHeader(HTTPHeaderName.SERVER, ConstantHTTPHeaderValue.SERVER_VALUE, outputStream);
        string = "X-Queue: position=" + (this.POSITION + 1) + ", pollMin=" + 45 + ", pollMax=" + 120 + "\r\n";
        outputStream.write(string.getBytes());
        this.writeAlts(outputStream);
        this.writeRanges(outputStream);
        if (this.UPLOADER.isFirstReply()) {
            HTTPUtils.writeFeatures(outputStream);
        }
        if (this.FILE_DESC.getHashTree() != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.THEX_URI, (HTTPHeaderValue)this.FILE_DESC.getHashTree(), outputStream);
        }
        string = "\r\n";
        outputStream.write(string.getBytes());
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
    }

    public boolean getCloseConnection() {
        return false;
    }
}

