/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class PushRequest
extends Message
implements Serializable {
    private static final int STANDARD_PAYLOAD_SIZE = 26;
    public static final long FW_TRANS_INDEX = 0x7FFFFFFDL;
    private byte[] payload;

    public PushRequest(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
        super(byArray, (byte)64, by, by2, byArray2.length, n);
        if (byArray2.length < 26) {
            ReceivedErrorStat.PUSH_INVALID_PAYLOAD.incrementStat();
            throw new BadPacketException("Payload too small: " + byArray2.length);
        }
        this.payload = byArray2;
        if (!NetworkUtils.isValidPort(this.getPort())) {
            ReceivedErrorStat.PUSH_INVALID_PORT.incrementStat();
            throw new BadPacketException("invalid port");
        }
        String string = NetworkUtils.ip2string(byArray2, 20);
        if (!NetworkUtils.isValidAddress(string)) {
            ReceivedErrorStat.PUSH_INVALID_ADDRESS.incrementStat();
            throw new BadPacketException("invalid address: " + string);
        }
    }

    public PushRequest(byte[] byArray, byte by, byte[] byArray2, long l, byte[] byArray3, int n) {
        this(byArray, by, byArray2, l, byArray3, n, -1);
    }

    public PushRequest(byte[] byArray, byte by, byte[] byArray2, long l, byte[] byArray3, int n, int n2) {
        super(byArray, (byte)64, by, (byte)0, 26, n2);
        if (byArray2.length != 16) {
            throw new IllegalArgumentException("invalid guid length: " + byArray2.length);
        }
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + l);
        }
        if (byArray3.length != 4) {
            throw new IllegalArgumentException("invalid ip length: " + byArray3.length);
        }
        if (!NetworkUtils.isValidAddress(byArray3)) {
            throw new IllegalArgumentException("invalid ip " + NetworkUtils.ip2string(byArray3));
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        this.payload = new byte[26];
        System.arraycopy(byArray2, 0, this.payload, 0, 16);
        ByteOrder.int2leb((int)l, this.payload, 16);
        this.payload[20] = byArray3[0];
        this.payload[21] = byArray3[1];
        this.payload[22] = byArray3[2];
        this.payload[23] = byArray3[3];
        ByteOrder.short2leb((short)n, this.payload, 24);
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.payload);
        SentMessageStatHandler.TCP_PUSH_REQUESTS.addMessage(this);
    }

    public byte[] getClientGUID() {
        byte[] byArray = new byte[16];
        System.arraycopy(this.payload, 0, byArray, 0, 16);
        return byArray;
    }

    public long getIndex() {
        return ByteOrder.uint2long(ByteOrder.leb2int(this.payload, 16));
    }

    public boolean isFirewallTransferPush() {
        return this.getIndex() == 0x7FFFFFFDL;
    }

    public byte[] getIP() {
        byte[] byArray = new byte[]{this.payload[20], this.payload[21], this.payload[22], this.payload[23]};
        return byArray;
    }

    public int getPort() {
        return ByteOrder.ushort2int(ByteOrder.leb2short(this.payload, 24));
    }

    public Message stripExtendedPayload() {
        byte[] byArray = new byte[26];
        System.arraycopy(this.payload, 0, byArray, 0, 26);
        try {
            return new PushRequest(this.getGUID(), this.getTTL(), this.getHops(), byArray, this.getNetwork());
        }
        catch (BadPacketException badPacketException) {
            Assert.that(false, "Standard packet length not allowed!");
            return null;
        }
    }

    public void recordDrop() {
        DroppedSentMessageStatHandler.TCP_PUSH_REQUESTS.addMessage(this);
    }

    public String toString() {
        return "PushRequest(" + super.toString() + " " + NetworkUtils.ip2string(this.getIP()) + ":" + this.getPort() + ")";
    }
}

