/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.BufferInputStream;
import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.ChannelReadObserver;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.ReadTimeout;
import com.limegroup.gnutella.io.Shutdownable;
import com.limegroup.gnutella.io.SoTimeout;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;

class NIOInputStream
implements ChannelReadObserver,
InterestReadChannel,
ReadTimeout {
    private final Shutdownable shutdownHandler;
    private final SoTimeout soTimeoutHandler;
    private InterestReadChannel channel;
    private BufferInputStream source;
    private volatile Object bufferLock;
    private ByteBuffer buffer;
    private boolean shutdown;

    NIOInputStream(SoTimeout soTimeout, Shutdownable shutdownable, InterestReadChannel interestReadChannel) {
        this.soTimeoutHandler = soTimeout;
        this.shutdownHandler = shutdownable;
        this.channel = interestReadChannel;
    }

    synchronized NIOInputStream init() throws IOException {
        if (this.buffer != null) {
            throw new IllegalStateException("already init'd!");
        }
        if (this.shutdown) {
            throw new IOException("Already closed!");
        }
        this.buffer = NIODispatcher.instance().getBufferCache().getHeap();
        this.source = new BufferInputStream(this.buffer, this, this.shutdownHandler, this.channel);
        this.bufferLock = this.source.getBufferLock();
        return this;
    }

    public int read(ByteBuffer byteBuffer) {
        return BufferUtils.transfer(this.buffer, byteBuffer);
    }

    synchronized InputStream getInputStream() throws IOException {
        if (this.buffer == null) {
            this.init();
        }
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRead() throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            int n = 0;
            while (this.buffer.hasRemaining() && (n = this.channel.read(this.buffer)) > 0) {
            }
            if (n == -1) {
                this.source.finished();
            }
            if (this.buffer.position() > 0 || n == -1) {
                this.bufferLock.notify();
            }
            if (!this.buffer.hasRemaining() || n == -1) {
                this.channel.interest(false);
            }
        }
    }

    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.source != null) {
            this.source.shutdown();
        }
        if (this.buffer != null) {
            NIODispatcher.instance().invokeLater(new Runnable(){

                public void run() {
                    NIODispatcher.instance().getBufferCache().release(NIOInputStream.this.buffer);
                }
            });
        }
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("unsupported operation", iOException);
    }

    public void close() throws IOException {
    }

    public boolean isOpen() {
        return true;
    }

    public void interest(boolean bl) {
    }

    public InterestReadChannel getReadChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadChannel(InterestReadChannel interestReadChannel) {
        Object object = this.bufferLock;
        synchronized (object) {
            this.channel = interestReadChannel;
            this.source.setReadChannel(interestReadChannel);
        }
    }

    public long getReadTimeout() {
        try {
            return this.soTimeoutHandler.getSoTimeout();
        }
        catch (SocketException socketException) {
            return -1L;
        }
    }
}

