/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.AcceptObserver;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ServerSocketChannel;

public class BlockingServerSocketAdapter
extends ServerSocket {
    private final AcceptObserver observer;
    private final ServerSocket delegate = new ServerSocket();

    public BlockingServerSocketAdapter() throws IOException {
        this((AcceptObserver)null);
    }

    public BlockingServerSocketAdapter(AcceptObserver acceptObserver) throws IOException {
        this.observer = acceptObserver;
    }

    public BlockingServerSocketAdapter(int n) throws IOException {
        this(n, null);
    }

    public BlockingServerSocketAdapter(int n, AcceptObserver acceptObserver) throws IOException {
        this(acceptObserver);
        this.bind(new InetSocketAddress(n));
    }

    public BlockingServerSocketAdapter(int n, int n2) throws IOException {
        this(n, n2, (AcceptObserver)null);
    }

    public BlockingServerSocketAdapter(int n, int n2, AcceptObserver acceptObserver) throws IOException {
        this(acceptObserver);
        this.bind(new InetSocketAddress(n), n2);
    }

    public BlockingServerSocketAdapter(int n, int n2, InetAddress inetAddress) throws IOException {
        this(n, n2, inetAddress, null);
    }

    public BlockingServerSocketAdapter(int n, int n2, InetAddress inetAddress, AcceptObserver acceptObserver) throws IOException {
        this(acceptObserver);
        this.bind(new InetSocketAddress(inetAddress, n), n2);
    }

    public void bind(SocketAddress socketAddress, int n) throws IOException {
        this.delegate.bind(socketAddress, n);
        this.startListening();
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.delegate.bind(socketAddress);
        this.startListening();
    }

    public Socket accept() throws IOException {
        if (this.observer != null) {
            throw new IllegalBlockingModeException();
        }
        return this.delegate.accept();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public boolean equals(Object object) {
        return this.delegate.equals(object);
    }

    public ServerSocketChannel getChannel() {
        return this.delegate.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.delegate.getInetAddress();
    }

    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.delegate.getReceiveBufferSize();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.delegate.getReuseAddress();
    }

    public int getSoTimeout() throws IOException {
        return this.delegate.getSoTimeout();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isBound() {
        return this.delegate.isBound();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.delegate.setReceiveBufferSize(n);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.delegate.setReuseAddress(bl);
    }

    public void setSoTimeout(int n) throws SocketException {
        this.delegate.setSoTimeout(n);
    }

    public String toString() {
        return this.delegate.toString();
    }

    private void startListening() {
        if (this.observer != null) {
            ThreadFactory.startThread(new Runnable(){

                public void run() {
                    while (!BlockingServerSocketAdapter.this.isClosed()) {
                        try {
                            Socket socket = BlockingServerSocketAdapter.this.delegate.accept();
                            BlockingServerSocketAdapter.this.observer.handleAccept(socket);
                        }
                        catch (IOException iOException) {}
                    }
                    BlockingServerSocketAdapter.this.observer.shutdown();
                }
            }, "BlockingServerSocketEmulator");
        }
    }
}

