/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.io.ChannelWriter;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.WriteObserver;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeflaterWriter
implements ChannelWriter,
InterestWriteChannel {
    private static final Log LOG;
    private volatile InterestWriteChannel channel;
    private volatile WriteObserver observer;
    private ByteBuffer outgoing;
    private ByteBuffer incoming;
    private Deflater deflater;
    private int sync = 0;
    private static final byte[] EMPTY;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.connection.DeflaterWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        EMPTY = new byte[0];
    }

    public DeflaterWriter(Deflater deflater) {
        this(deflater, null);
    }

    public DeflaterWriter(Deflater deflater, InterestWriteChannel interestWriteChannel) {
        this.deflater = deflater;
        this.incoming = ByteBuffer.allocate(4096);
        this.outgoing = ByteBuffer.allocate(512);
        this.outgoing.flip();
        this.channel = interestWriteChannel;
    }

    public InterestWriteChannel getWriteChannel() {
        return this.channel;
    }

    public void setWriteChannel(InterestWriteChannel interestWriteChannel) {
        this.channel = interestWriteChannel;
        interestWriteChannel.interest(this, true);
    }

    public synchronized void interest(WriteObserver writeObserver, boolean bl) {
        this.observer = bl ? writeObserver : null;
        InterestWriteChannel interestWriteChannel = this.channel;
        if (interestWriteChannel != null) {
            interestWriteChannel.interest(this, true);
        }
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        if (this.incoming.hasRemaining()) {
            int n2;
            int n3 = this.incoming.remaining();
            if (n3 >= (n2 = byteBuffer.remaining())) {
                this.incoming.put(byteBuffer);
                n = n2;
            } else {
                int n4 = byteBuffer.limit();
                int n5 = byteBuffer.position();
                byteBuffer.limit(n5 + n3);
                this.incoming.put(byteBuffer);
                byteBuffer.limit(n4);
                n = n3;
            }
        }
        return n;
    }

    public void close() throws IOException {
        InterestWriteChannel interestWriteChannel = this.channel;
        if (interestWriteChannel != null) {
            interestWriteChannel.close();
        }
    }

    public boolean isOpen() {
        InterestWriteChannel interestWriteChannel = this.channel;
        return interestWriteChannel != null ? interestWriteChannel.isOpen() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleWrite() throws IOException {
        InterestWriteChannel interestWriteChannel = this.channel;
        if (interestWriteChannel == null) {
            throw new IllegalStateException("writing with no source.");
        }
        block9: while (true) {
            this.channel.write(this.outgoing);
            if (this.outgoing.hasRemaining()) {
                return true;
            }
            while (true) {
                int n;
                try {
                    n = this.deflater.deflate(this.outgoing.array());
                }
                catch (NullPointerException nullPointerException) {
                    throw (IOException)new IOException().initCause(nullPointerException);
                }
                if (n > 0) {
                    this.outgoing.position(0).limit(n);
                    continue block9;
                }
                try {
                    if (this.sync == 0) {
                        this.deflater.setInput(EMPTY);
                        this.deflater.setLevel(0);
                        this.sync = 1;
                        continue;
                    }
                    if (this.sync == 1) {
                        this.deflater.setLevel(-1);
                        this.sync = 2;
                        continue;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    throw (IOException)new IOException().initCause(nullPointerException);
                }
                if (this.incoming.position() == 0) {
                    WriteObserver writeObserver = this.observer;
                    if (writeObserver != null) {
                        writeObserver.handleWrite();
                    }
                    if (this.incoming.position() == 0) {
                        DeflaterWriter deflaterWriter = this;
                        synchronized (deflaterWriter) {
                            if (this.observer == null) {
                                interestWriteChannel.interest(this, false);
                            }
                        }
                        return false;
                    }
                }
                try {
                    this.deflater.setInput(this.incoming.array(), 0, this.incoming.position());
                }
                catch (NullPointerException nullPointerException) {
                    throw (IOException)new IOException().initCause(nullPointerException);
                }
                this.incoming.clear();
                this.sync = 0;
            }
            break;
        }
    }

    public void shutdown() {
        WriteObserver writeObserver = this.observer;
        if (writeObserver != null) {
            writeObserver.shutdown();
        }
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("Unsupported", iOException);
    }
}

