/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GuidMap;
import com.limegroup.gnutella.RouterService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class GuidMapFactory {
    private static long EXPIRE_POLL_TIME = 120000L;
    private static List toExpire = new LinkedList();
    private static boolean scheduled = false;

    private GuidMapFactory() {
    }

    public static GuidMap getMap() {
        return new GuidMapImpl();
    }

    public static synchronized void removeMap(GuidMap guidMap) {
        toExpire.remove(guidMap);
    }

    private static synchronized void addMapToExpire(GuidMapImpl guidMapImpl) {
        if (!scheduled) {
            RouterService.schedule(new GuidExpirer(), 0L, EXPIRE_POLL_TIME);
            scheduled = true;
        }
        toExpire.add(guidMapImpl);
    }

    private static class GuidExpirer
    implements Runnable {
        static /* synthetic */ Class class$0;

        private GuidExpirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.limegroup.gnutella.GuidMapFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                Iterator iterator = toExpire.iterator();
                while (iterator.hasNext()) {
                    GuidMapImpl guidMapImpl;
                    GuidMapImpl guidMapImpl2 = guidMapImpl = (GuidMapImpl)iterator.next();
                    synchronized (guidMapImpl2) {
                        Map map = guidMapImpl.getMap();
                        Iterator iterator2 = map.keySet().iterator();
                        while (iterator2.hasNext()) {
                            GUID.TimedGUID timedGUID = (GUID.TimedGUID)iterator2.next();
                            if (!timedGUID.shouldExpire()) continue;
                            iterator2.remove();
                        }
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    private static class GuidMapImpl
    implements GuidMap {
        private static long TIMED_GUID_LIFETIME = 600000L;
        private Map map;

        private GuidMapImpl() {
        }

        public String toString() {
            return "impl, map: " + this.map;
        }

        Map getMap() {
            return this.map;
        }

        public void addMapping(byte[] byArray, byte[] byArray2) {
            this.addMapping(byArray, byArray2, TIMED_GUID_LIFETIME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMapping(byte[] byArray, byte[] byArray2, long l) {
            boolean bl = false;
            GuidMapImpl guidMapImpl = this;
            synchronized (guidMapImpl) {
                if (this.map == null) {
                    this.map = new HashMap();
                    bl = true;
                }
                GUID.TimedGUID timedGUID = new GUID.TimedGUID(new GUID(byArray2), l);
                this.map.put(timedGUID, new GUID(byArray));
            }
            if (bl) {
                GuidMapFactory.addMapToExpire(this);
            }
        }

        public synchronized byte[] getOriginalGUID(byte[] byArray) {
            GUID.TimedGUID timedGUID;
            GUID gUID;
            if (this.map != null && (gUID = (GUID)this.map.get(timedGUID = new GUID.TimedGUID(new GUID(byArray), 0L))) != null) {
                return gUID.bytes();
            }
            return null;
        }

        public synchronized GUID getNewGUID(GUID gUID) {
            if (this.map != null) {
                Iterator iterator = this.map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    GUID gUID2 = (GUID)entry.getValue();
                    if (!gUID2.equals(gUID)) continue;
                    GUID.TimedGUID timedGUID = (GUID.TimedGUID)entry.getKey();
                    return timedGUID.getGUID();
                }
            }
            return null;
        }
    }
}

